/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.wizards;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.wizards.BaseWizard;
import com.aptana.ide.core.ui.wizards.WizardPageFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.wizard.IWizardPage;

public final class WizardPageExtensionLoader {
    public static final String ID_ATTR = "id";
    public static final String CLASS_ATTR = "class";
    private static Map<String, List<WizardPageFactory>> pages;

    private WizardPageExtensionLoader() {
    }

    public static IWizardPage[] createWizardPages(BaseWizard wizard, String id) {
        List<WizardPageFactory> elements;
        if (pages == null) {
            WizardPageExtensionLoader.loadPages();
        }
        if ((elements = pages.get(id)) != null) {
            ArrayList<IWizardPage> wizardPages = new ArrayList<IWizardPage>();
            for (WizardPageFactory element : elements) {
                IWizardPage page = element.createWizardPage(wizard);
                if (page == null) continue;
                wizardPages.add(page);
            }
            Collections.sort(wizardPages, new Comparator<IWizardPage>(){

                @Override
                public int compare(IWizardPage w1, IWizardPage w2) {
                    return w1.getName().compareTo(w2.getName());
                }
            });
            return wizardPages.toArray(new IWizardPage[0]);
        }
        return new IWizardPage[0];
    }

    private static void loadPages() {
        pages = new HashMap<String, List<WizardPageFactory>>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(CoreUIPlugin.WIZARD_EXTENSION_POINT);
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                String id = ce[j].getAttribute(ID_ATTR);
                String className = ce[j].getAttribute(CLASS_ATTR);
                if (id != null && className != null) {
                    List<WizardPageFactory> elements = pages.get(id);
                    if (elements == null) {
                        elements = new ArrayList<WizardPageFactory>();
                        pages.put(id, elements);
                    }
                    try {
                        Object obj = ce[j].createExecutableExtension(CLASS_ATTR);
                        if (obj instanceof WizardPageFactory) {
                            elements.add((WizardPageFactory)obj);
                        }
                    }
                    catch (CoreException e) {
                        IdeLog.logInfo((Plugin)CoreUIPlugin.getDefault(), (String)"Error creating wizard page factory from extension point", (Throwable)e);
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

