/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.user;

import com.aptana.ide.core.ui.IValidator;
import com.aptana.ide.core.ui.widgets.IBackgroundColorWidget;
import com.aptana.ide.core.ui.widgets.IEnableWidget;
import com.aptana.ide.core.ui.widgets.IForegroundColorWidget;
import com.aptana.ide.core.ui.widgets.IValidatedWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UsernamePasswordWidget
implements IValidatedWidget,
IEnableWidget,
IBackgroundColorWidget,
IForegroundColorWidget {
    private Composite displayArea;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private StringBuffer username = new StringBuffer();
    private StringBuffer password = new StringBuffer();
    private String errorMessage = null;
    private IValidator validator;
    private boolean canStartValidation = false;

    private void attachListener(final Text field, final StringBuffer data) {
        field.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                data.delete(0, data.length());
                data.append(field.getText());
                UsernamePasswordWidget.this.validate();
                if (UsernamePasswordWidget.this.validator != null && UsernamePasswordWidget.this.canStartValidation) {
                    UsernamePasswordWidget.this.validator.validate();
                }
            }
        });
    }

    private void validate() {
        if (this.username.toString().trim().length() == 0) {
            this.errorMessage = "User name cannot be empty";
            return;
        }
        if (this.password.toString().trim().length() == 0) {
            this.errorMessage = "Password cannot be empty";
            return;
        }
        this.errorMessage = null;
    }

    public void setEnabled(boolean enabled) {
        this.usernameText.setEnabled(enabled);
        this.passwordText.setEnabled(enabled);
    }

    public String getUsername() {
        return this.username.toString();
    }

    public String getPassword() {
        return this.password.toString();
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(2, false);
        this.displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        this.displayArea.setLayoutData((Object)daData);
        GridData textData = new GridData(4, 4, false, false);
        textData.widthHint = 150;
        this.usernameLabel = new Label(this.displayArea, 16384);
        this.usernameLabel.setText("Username:");
        this.usernameText = new Text(this.displayArea, 2052);
        this.usernameText.setLayoutData((Object)textData);
        this.attachListener(this.usernameText, this.username);
        this.passwordLabel = new Label(this.displayArea, 16384);
        this.passwordLabel.setText("Password:");
        this.passwordText = new Text(this.displayArea, 0x400804);
        this.passwordText.setLayoutData((Object)textData);
        this.attachListener(this.passwordText, this.password);
        this.canStartValidation = true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setValidator(IValidator validator) {
        this.validator = validator;
        if (this.validator != null) {
            this.validate();
            if (this.validator != null && this.canStartValidation) {
                this.validator.validate();
            }
        }
    }

    public void setBackground(Color color) {
        this.passwordLabel.setBackground(color);
        this.usernameLabel.setBackground(color);
        this.displayArea.setBackground(color);
    }

    public void setForeground(Color color) {
        this.passwordLabel.setForeground(color);
        this.usernameLabel.setForeground(color);
        this.displayArea.setForeground(color);
    }
}

