/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.preferences;

import com.aptana.ide.core.AptanaAuthenticator;
import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.dialogs.BooleanFieldEditorPublic;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer credentialList;
    private Button removeButton;
    private Button removeAllButton;
    private List<HostCredentials> credentials;
    private BooleanFieldEditorPublic enableCaching;
    private Composite composite;

    protected Control createContents(Composite parent) {
        this.composite = this.createPageRoot(parent);
        Label tableLabel = new Label(this.composite, 0);
        tableLabel.setText("Aptana password manager securely stores passwords in a non-reversible\nencryption format. Use this screen to control which aptana.com passwords are stored\non your local machine.\n\n");
        GridData data = new GridData();
        data.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)data);
        Font font = parent.getFont();
        this.composite.setFont(font);
        tableLabel.setFont(font);
        this.enableCaching = new BooleanFieldEditorPublic("com.aptana.ide.core.PREF_ENABLE_PASSWORD_CACHING", "Enable password caching", this.composite);
        boolean enabled = AptanaCorePlugin.getDefault().getPluginPreferences().getBoolean("com.aptana.ide.core.PREF_ENABLE_PASSWORD_CACHING");
        Button checkbox = this.enableCaching.getChangeControl(this.composite);
        checkbox.setSelection(enabled);
        Table table = this.createCredentialsTable(this.composite);
        this.createCredentialsTableViewer(table);
        this.createButtonGroup(this.composite);
        this.fillWithCredentials();
        this.enableButtons();
        return this.composite;
    }

    private void fillWithCredentials() {
        this.credentials = this.loadCredentials();
        this.credentialList.setInput(this.credentials);
        this.credentialList.refresh();
    }

    private List<HostCredentials> loadCredentials() {
        Set hosts = AptanaAuthenticator.getSavedHosts();
        ArrayList<HostCredentials> credentials = new ArrayList<HostCredentials>();
        for (String host : hosts) {
            if (host.trim().length() == 0) continue;
            String username = AptanaAuthenticator.getUserName((String)host);
            HostCredentials cred = new HostCredentials(host, username);
            credentials.add(cred);
        }
        return credentials;
    }

    protected Composite createPageRoot(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected Table createCredentialsTable(Composite composite) {
        Table table = new Table(composite, 67584);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableColumn column = new TableColumn(table, 0);
        column.setText("Host");
        column.setWidth(250);
        column = new TableColumn(table, 0);
        column.setText("Username");
        column.setWidth(125);
        return table;
    }

    protected void createCredentialsTableViewer(Table table) {
        this.credentialList = new TableViewer(table);
        this.credentialList.setLabelProvider((IBaseLabelProvider)new CredentialsTableLabelProvider());
        this.credentialList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List creds = (List)inputElement;
                return creds.toArray();
            }
        });
        this.credentialList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                PasswordsPreferencePage.this.enableButtons();
            }
        });
    }

    protected HostCredentials getSelectedCredentials() {
        IStructuredSelection selection = (IStructuredSelection)this.credentialList.getSelection();
        return (HostCredentials)selection.getFirstElement();
    }

    protected void enableButtons() {
        if (this.getSelectedCredentials() != null) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    protected void createButtonGroup(Composite composite) {
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.setText("Remove");
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                PasswordsPreferencePage.this.removeCredentials();
            }
        });
        this.removeAllButton = new Button(buttons, 8);
        this.removeAllButton.setLayoutData((Object)new GridData(768));
        this.removeAllButton.setText("Remove All");
        this.removeAllButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                PasswordsPreferencePage.this.removeAllCredentials();
            }
        });
    }

    protected void removeAllCredentials() {
        for (HostCredentials credential : this.credentials) {
            credential.remove();
        }
        this.credentials = new ArrayList<HostCredentials>();
        this.credentialList.setInput(this.credentials);
        this.credentialList.refresh();
    }

    protected void removeCredentials() {
        HostCredentials creds = this.getSelectedCredentials();
        creds.remove();
        this.credentials.remove(creds);
        this.credentialList.setInput(this.credentials);
        this.credentialList.refresh();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CoreUIPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        boolean cachingEnabled = this.enableCaching.getBooleanValue();
        Preferences prefs = AptanaCorePlugin.getDefault().getPluginPreferences();
        prefs.setValue("com.aptana.ide.core.PREF_ENABLE_PASSWORD_CACHING", cachingEnabled);
        prefs.setToDefault("com.aptana.ide.core.CACHED_KEY");
        return super.performOk();
    }

    protected void performDefaults() {
        boolean enabled = AptanaCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean("com.aptana.ide.core.PREF_ENABLE_PASSWORD_CACHING");
        Button checkbox = this.enableCaching.getChangeControl(this.composite);
        checkbox.setSelection(enabled);
        super.performDefaults();
    }

    private class HostCredentials {
        private String host;
        private String username;

        HostCredentials(String host, String username) {
            this.host = host;
            this.username = username;
        }

        public String getHost() {
            return this.host;
        }

        public String getUsername() {
            return this.username;
        }

        public void remove() {
            AptanaAuthenticator.removeCachedAuthentication((String)this.host);
        }
    }

    private class CredentialsTableLabelProvider
    implements ITableLabelProvider {
        private CredentialsTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            HostCredentials cred = (HostCredentials)element;
            switch (columnIndex) {
                case 0: {
                    return cred.getHost();
                }
                case 1: {
                    return cred.getUsername();
                }
            }
            return "Unknown column";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

