/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.preferences;

import com.aptana.ide.core.URLEncoder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class ApplicationPreferences {
    private static final String aptanaSettings = ".aptana-settings";
    private static ApplicationPreferences instance;
    private Map<String, String> _keyValuePairs = new HashMap<String, String>();
    private boolean _hasLoaded;
    private ListenerList listenerList = new ListenerList();

    private ApplicationPreferences() {
    }

    public static ApplicationPreferences getInstance() {
        if (instance == null) {
            instance = new ApplicationPreferences();
            instance.loadPreferences();
        }
        return instance;
    }

    private File getSettingsFile() {
        File config = ApplicationPreferences.getConfigurationDirectory();
        return new File(config, aptanaSettings);
    }

    public static File getConfigurationDirectory() {
        String homeDir = System.getProperty("osgi.configuration.area");
        URL fileURL = ApplicationPreferences.uriToURL(homeDir);
        File f = ApplicationPreferences.urlToFile(fileURL);
        f.mkdirs();
        return f;
    }

    public void loadPreferences() {
        File settings = this.getSettingsFile();
        if (this._hasLoaded || !settings.exists()) {
            return;
        }
        FileReader fr = null;
        try {
            try {
                fr = new FileReader(settings);
                BufferedReader br = new BufferedReader(fr);
                String line = br.readLine();
                while (line != null) {
                    int colonIndex = line.indexOf(":");
                    if (colonIndex == -1) continue;
                    String key = line.substring(0, colonIndex);
                    String value = line.substring(colonIndex + 1, line.length());
                    this._keyValuePairs.put(key, value);
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                ApplicationPreferences.logError("Unable to read Aptana settings", e);
            }
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    ApplicationPreferences.logError("Unable to close Aptana settings", e);
                }
            }
            this._hasLoaded = true;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.firePropertyChangeEvent(new PropertyChangeEvent((Object)this, name, oldValue, newValue));
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public void savePreferences() {
        BufferedWriter bw = null;
        try {
            try {
                File settings = this.getSettingsFile();
                FileWriter fw = new FileWriter(settings);
                bw = new BufferedWriter(fw);
                Set<Map.Entry<String, String>> entries = this._keyValuePairs.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    bw.write(entry.getKey());
                    bw.write(":");
                    bw.write(entry.getValue());
                    bw.newLine();
                }
            }
            catch (Exception e) {
                ApplicationPreferences.logError("Unable to write Aptana settings", e);
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    ApplicationPreferences.logError("Unable to close Aptana settings", e);
                }
            }
        }
    }

    public boolean getBoolean(String preferenceName) {
        return "true".equals(this.getString(preferenceName));
    }

    public String getString(String preferenceName) {
        if (preferenceName == null) {
            throw new IllegalArgumentException("preference name must be defined");
        }
        String result = null;
        if (this._keyValuePairs.containsKey(preferenceName)) {
            result = this._keyValuePairs.get(preferenceName);
        }
        return result;
    }

    public void setBoolean(String preferenceName, boolean preferenceValue) {
        this.setString(preferenceName, preferenceValue ? "true" : "false");
    }

    public void setString(String preferenceName, String preferenceValue) {
        if (preferenceName == null) {
            throw new IllegalArgumentException("preference name must be defined");
        }
        this._keyValuePairs.put(preferenceName, preferenceValue);
        this.firePropertyChangeEvent(preferenceName, "", preferenceValue);
    }

    public static URL uriToURL(String uri) {
        try {
            String encodedUri = URLEncoder.encode((String)uri, null, null);
            URI uri2 = new URI(encodedUri);
            return uri2.toURL();
        }
        catch (MalformedURLException e) {
            ApplicationPreferences.logError("Unable to convert uri {0} to URL. Malformed " + uri, e);
            return null;
        }
        catch (URISyntaxException e) {
            ApplicationPreferences.logError("Unable to convert uri {0} to URL. Syntax is incorrec t" + uri, e);
            return null;
        }
    }

    public static File urlToFile(URL url) {
        try {
            URI uri = url.toURI();
            if ("file".equals(uri.getScheme())) {
                return new File(uri.getSchemeSpecificPart());
            }
        }
        catch (Exception e) {
            ApplicationPreferences.logError("Failed to convert url to file.", e);
        }
        return null;
    }

    private static void logError(String errorMessage, Throwable e) {
        Status status = new Status(4, ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), 0, errorMessage, e);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }
}

