/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.AptanaNavigator;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.Messages;
import com.aptana.ide.core.ui.WebPerspectiveFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;

public class InitialStartup
implements IStartup {
    protected IPerspectiveListener perpListener;
    private Image editorAreaImage;
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            int drawHeight;
            int drawWidth;
            Rectangle rect = ((Composite)e.widget).getClientArea();
            Rectangle imageSize = InitialStartup.this.editorAreaImage.getBounds();
            if (rect.width > imageSize.width && rect.height > imageSize.height) {
                drawWidth = imageSize.width;
                drawHeight = imageSize.height;
            } else if (rect.width * imageSize.height > rect.height * imageSize.width) {
                drawHeight = rect.height;
                drawWidth = drawHeight * imageSize.width / imageSize.height;
            } else {
                drawWidth = rect.width;
                drawHeight = drawWidth * imageSize.height / imageSize.width;
            }
            e.gc.drawImage(InitialStartup.this.editorAreaImage, 0, 0, imageSize.width, imageSize.height, (rect.width - drawWidth) / 2, (rect.height - drawHeight) / 2, drawWidth, drawHeight);
        }
    };
    protected Map<IWorkbenchWindow, IPerspectiveListener> windows = new HashMap<IWorkbenchWindow, IPerspectiveListener>();

    public void earlyStartup() {
        Preferences prefs;
        boolean hasRunFirstStartup;
        ImageDescriptor imageDescriptor = CoreUIPlugin.getImageDescriptor("icons/editorarea.png");
        if (imageDescriptor != null) {
            this.editorAreaImage = imageDescriptor.createImage();
        }
        if (!(hasRunFirstStartup = (prefs = CoreUIPlugin.getDefault().getPluginPreferences()).getBoolean("com.aptana.ide.core.ui.PREF_KEY_FIRST_STARTUP"))) {
            this.initForFirstTimeStartup();
            prefs.setValue("com.aptana.ide.core.ui.PREF_KEY_FIRST_STARTUP", true);
            CoreUIPlugin.getDefault().savePluginPreferences();
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        this.perpListener = new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                InitialStartup.this.checkPerspective(page, perspective);
                InitialStartup.this.setEditorAreaPaintListener(page);
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        };
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow w = workbench.getActiveWorkbenchWindow();
                InitialStartup.this.addListenerToWindow(w);
            }
        });
        this.addWindowListener(workbench);
        final IPartListener _partListener = this.createPartActivationListener();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    window.getPartService().addPartListener(_partListener);
                }
            }
        });
    }

    private void addWindowListener(IWorkbench workbench) {
        workbench.addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                window.removePerspectiveListener(InitialStartup.this.perpListener);
                if (InitialStartup.this.windows.containsKey(window)) {
                    InitialStartup.this.windows.remove(window);
                }
            }

            public void windowOpened(IWorkbenchWindow window) {
                if (!InitialStartup.this.windows.containsKey(window)) {
                    InitialStartup.this.addListenerToWindow(window);
                    InitialStartup.this.windows.put(window, InitialStartup.this.perpListener);
                }
            }
        });
    }

    private IPartListener createPartActivationListener() {
        IPartListener _partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                try {
                    WorkbenchPage wp;
                    Perspective persp;
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (part.getSite().getPart() instanceof AptanaNavigator && page instanceof WorkbenchPage && WebPerspectiveFactory.isSameOrDescendantPerspective((persp = (wp = (WorkbenchPage)page).getActivePerspective()).getDesc())) {
                        String[] existing = persp.getNewWizardShortcuts();
                        List<String> fileWizards = WebPerspectiveFactory.getFileWizardShortcuts();
                        ArrayList<String> ids = new ArrayList<String>();
                        int i = 0;
                        while (i < existing.length) {
                            if (!fileWizards.contains(existing[i])) {
                                ids.add(existing[i]);
                            }
                            ++i;
                        }
                        List<String> projectWizards = WebPerspectiveFactory.getProjectWizardShortcuts();
                        for (String id : projectWizards) {
                            if (ids.contains(id)) continue;
                            ids.add(id);
                        }
                        persp.setNewWizardActionIds(ids);
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.InitialStartup_UnableToSwitchNewFileWizardListing, (Throwable)ex);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                try {
                    WorkbenchPage wp;
                    Perspective persp;
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (part.getSite().getPart() instanceof AptanaNavigator && WebPerspectiveFactory.isSameOrDescendantPerspective((persp = (wp = (WorkbenchPage)page).getActivePerspective()).getDesc())) {
                        String[] existing = persp.getNewWizardShortcuts();
                        List<String> projectWizards = WebPerspectiveFactory.getProjectWizardShortcuts();
                        ArrayList<String> ids = new ArrayList<String>();
                        int i = 0;
                        while (i < existing.length) {
                            if (!projectWizards.contains(existing[i])) {
                                ids.add(existing[i]);
                            }
                            ++i;
                        }
                        List<String> fileWizards = WebPerspectiveFactory.getFileWizardShortcuts();
                        for (String id : fileWizards) {
                            if (ids.contains(id)) continue;
                            ids.add(id);
                        }
                        persp.setNewWizardActionIds(ids);
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.InitialStartup_UnableToSwitchNewFileWizardListing, (Throwable)ex);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }
        };
        return _partListener;
    }

    private void addListenerToWindow(final IWorkbenchWindow w) {
        if (w == null) {
            return;
        }
        IWorkbenchPage page = w.getActivePage();
        if (page != null) {
            this.checkPerspective(page, page.getPerspective());
            w.addPerspectiveListener(this.perpListener);
            w.getPartService().addPartListener(new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    IWorkbenchPage page = w.getActivePage();
                    if (part instanceof IEditorPart && page != null && page.getEditorReferences().length == 0) {
                        InitialStartup.this.setEditorAreaPaintListener(page);
                    }
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partOpened(IWorkbenchPart part) {
                }
            });
            this.setEditorAreaPaintListener(page);
        }
    }

    private boolean checkPerspective(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (WebPerspectiveFactory.isSameOrDescendantPerspective(perspective)) {
            this.onWebPerspectiveActivated(page);
            return true;
        }
        return false;
    }

    private void onWebPerspectiveActivated(IWorkbenchPage page) {
        Preferences prefs = CoreUIPlugin.getDefault().getPluginPreferences();
        int lastWorkspace = prefs.getInt("com.aptana.ide.core.ui.WEB_PERSPECTIVE_LAST_VERSION");
        if (64 > lastWorkspace) {
            Preferences p = CoreUIPlugin.getDefault().getPluginPreferences();
            p.setValue("com.aptana.ide.core.ui.WEB_PERSPECTIVE_RESET_PERSPECTIVE", false);
            CoreUIPlugin.getDefault().savePluginPreferences();
            WebPerspectiveFactory.resetPerspective(page);
        }
    }

    private void initForFirstTimeStartup() {
        Preferences prefs = CoreUIPlugin.getDefault().getPluginPreferences();
        prefs.setValue("com.aptana.ide.core.ui.WEB_PERSPECTIVE_LAST_VERSION", 64);
        CoreUIPlugin.getDefault().savePluginPreferences();
    }

    private void setEditorAreaPaintListener(IWorkbenchPage page) {
        if (this.editorAreaImage == null) {
            return;
        }
        ViewForm control = null;
        Control[] list = ((Composite)((WorkbenchPage)page).getEditorPresentation().getWorkbookFromID("DefaultEditorWorkbook").getControl()).getChildren();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof ViewForm) {
                control = (ViewForm)list[i];
                break;
            }
            ++i;
        }
        if (control == null) {
            return;
        }
        IPerspectiveDescriptor perspective = page.getPerspective();
        if (WebPerspectiveFactory.isSameOrDescendantPerspective(perspective)) {
            if (control.getData("editorarea.custom_paint") != null) {
                return;
            }
            control.addPaintListener(this.paintListener);
            control.setData("editorarea.custom_paint", (Object)Boolean.TRUE);
            control.redraw();
        } else {
            if (control.getData("editorarea.custom_paint") == null) {
                return;
            }
            control.removePaintListener(this.paintListener);
            control.setData("editorarea.custom_paint", null);
            control.redraw();
        }
    }
}

