/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.core.model;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.resources.IUniformResourceMarker;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.model.IJSExceptionBreakpoint;
import com.aptana.ide.debug.core.model.IJSVariable;
import com.aptana.ide.debug.core.model.IJSWatchpoint;
import com.aptana.ide.debug.core.model.ISourceLink;
import com.aptana.ide.debug.internal.core.model.JSDebugExceptionBreakpoint;
import com.aptana.ide.debug.internal.core.model.JSDebugLineBreakpoint;
import com.aptana.ide.debug.internal.core.model.JSDebugSourceLink;
import com.aptana.ide.debug.internal.core.model.JSDebugWatchpoint;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IVariable;

public final class JSDebugModel {
    private JSDebugModel() {
    }

    public static String getModelIdentifier() {
        return "com.aptana.ide.debug.core";
    }

    public static ILineBreakpoint createLineBreakpoint(IResource resource, int line) throws CoreException {
        return new JSDebugLineBreakpoint(resource, line);
    }

    public static ILineBreakpoint createLineBreakpoint(IResource resource, int line, Map attributes, boolean register) throws CoreException {
        return new JSDebugLineBreakpoint(resource, line, attributes, register);
    }

    public static ILineBreakpoint createLineBreakpoint(IUniformResource resource, int line) throws CoreException {
        return new JSDebugLineBreakpoint(resource, line);
    }

    public static ILineBreakpoint createLineBreakpoint(IUniformResource resource, int line, Map attributes, boolean register) throws CoreException {
        return new JSDebugLineBreakpoint(resource, line, attributes, register);
    }

    public static ILineBreakpoint createLineBreakpointForResource(Object resource, int line, Map attributes, boolean register) throws CoreException {
        URI location = null;
        if (resource instanceof IResource) {
            location = ((IResource)resource).getLocation().makeAbsolute().toFile().toURI();
        } else if (resource instanceof IUniformResource) {
            location = ((IUniformResource)resource).getURI();
        }
        if (location == null) {
            return null;
        }
        attributes.put("com.aptana.ide.debug.core.breakpointLocation", location);
        return new JSDebugLineBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), line, attributes, register);
    }

    public static ILineBreakpoint lineBreakpointExists(IResource resource, int lineNumber) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JSDebugModel.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            try {
                if (breakpoint instanceof ILineBreakpoint && resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                    return (ILineBreakpoint)breakpoint;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
            }
            ++i;
        }
        return null;
    }

    public static ILineBreakpoint lineBreakpointExists(IUniformResource resource, int lineNumber) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JSDebugModel.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            try {
                IMarker marker = breakpoint.getMarker();
                if (breakpoint instanceof ILineBreakpoint && marker instanceof IUniformResourceMarker && resource.equals(((IUniformResourceMarker)marker).getUniformResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                    return (ILineBreakpoint)breakpoint;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
            }
            ++i;
        }
        return null;
    }

    public static IJSExceptionBreakpoint createExceptionBreakpoint(IResource resource, String exceptionTypeName) throws CoreException {
        return new JSDebugExceptionBreakpoint(resource, exceptionTypeName);
    }

    public static IJSExceptionBreakpoint createExceptionBreakpoint(IUniformResource resource, String exceptionTypeName) throws CoreException {
        return new JSDebugExceptionBreakpoint(resource, exceptionTypeName);
    }

    public static IJSExceptionBreakpoint exceptionBreakpointExists(String exceptionTypeName) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JSDebugModel.getModelIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            try {
                if (breakpoint instanceof IJSExceptionBreakpoint && exceptionTypeName.equals(((IJSExceptionBreakpoint)breakpoint).getExceptionTypeName())) {
                    return (IJSExceptionBreakpoint)breakpoint;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
            }
            ++i;
        }
        return null;
    }

    public static IJSWatchpoint createWatchpoint(IJSVariable variable) throws CoreException {
        return new JSDebugWatchpoint(variable);
    }

    public static boolean watchpointExists(IVariable variable) {
        return false;
    }

    public static ISourceLink createSourceLink(String location) {
        return new JSDebugSourceLink(location);
    }
}

