/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.core;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.SocketUtil;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.IActiveResourcePathGetterAdapter;
import com.aptana.ide.debug.core.IHttpServerProviderAdapter;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.JSLaunchConfigurationHelper;
import com.aptana.ide.debug.core.Messages;
import com.aptana.ide.debug.internal.core.BrowserUtil;
import com.aptana.ide.debug.internal.core.LocalResourceMapper;
import com.aptana.ide.debug.internal.core.browsers.Firefox;
import com.aptana.ide.debug.internal.core.browsers.InternetExplorer;
import com.aptana.ide.debug.internal.core.model.DebugConnection;
import com.aptana.ide.debug.internal.core.model.HttpServerProcess;
import com.aptana.ide.debug.internal.core.model.JSDebugProcess;
import com.aptana.ide.debug.internal.core.model.JSDebugTarget;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

public class JSLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    protected static final int DEFAULT_PORT = 8999;
    protected static final IStatus launchBrowserPromptStatus = new Status(1, "com.aptana.ide.debug.core", 302, "", null);

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block120: {
            IServer associatedServer;
            int n;
            int n2;
            IServer[] iServerArray;
            IServer server;
            URL baseURL;
            boolean launchServerDebugger;
            boolean launchHttpServer;
            HttpServerProcess httpServer;
            LocalResourceMapper resourceMapper;
            boolean appendProjectName;
            int startActionType;
            boolean advancedRun;
            boolean debug;
            boolean debugAvailable;
            boolean debugCompatible;
            String browserExecutable;
            block117: {
                IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(promptStatus);
                if ("debug".equals(mode)) {
                    IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
                    IDebugTarget activeSession = null;
                    int i = 0;
                    while (i < targets.length) {
                        if (targets[i].getModelIdentifier().equals("com.aptana.ide.debug.core") && !targets[i].isTerminated()) {
                            activeSession = targets[i];
                            break;
                        }
                        ++i;
                    }
                    if (activeSession != null) {
                        Object result = prompter.handleStatus(launchBrowserPromptStatus, null);
                        if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                            activeSession.terminate();
                        } else {
                            String errorMessage = String.valueOf(Messages.JSLaunchConfigurationDelegate_MultipleJavaScriptDebugNotSupported) + Messages.JSLaunchConfigurationDelegate_PleaseTerminateActiveSession;
                            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 4, errorMessage, null));
                        }
                    }
                }
                if ((browserExecutable = configuration.getAttribute("browserExecutable", null)) == null || !new File(browserExecutable).exists()) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, StringUtils.format((String)Messages.JSLaunchConfigurationDelegate_WebBrowserDoesNotExist, (String)browserExecutable), null));
                }
                JSLaunchConfigurationHelper.initializeLaunchAttributes(configuration, launch);
                debugCompatible = BrowserUtil.isBrowserDebugCompatible(browserExecutable);
                debugAvailable = false;
                debug = "debug".equals(mode);
                advancedRun = configuration.getAttribute("advancedRunEnabled", false);
                if (debugCompatible && ("debug".equals(mode) || advancedRun)) {
                    monitor.subTask(Messages.JSLaunchConfigurationDelegate_CheckingBrowserForDebugger);
                    debugAvailable = BrowserUtil.isBrowserDebugAvailable(browserExecutable);
                    if (!debugAvailable) {
                        if (!BrowserUtil.installDebugExtension(browserExecutable, prompter, monitor)) {
                            monitor.setCanceled(true);
                            return;
                        }
                        debugAvailable = BrowserUtil.isBrowserDebugAvailable(browserExecutable);
                    }
                    if (debug && !debugAvailable) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_DebuggerExtensionNotInstalled, null));
                    }
                }
                int serverType = configuration.getAttribute("serverType", 1);
                startActionType = configuration.getAttribute("startActionType", 1);
                appendProjectName = configuration.getAttribute("appendProjectName", false);
                resourceMapper = null;
                httpServer = null;
                launchHttpServer = false;
                launchServerDebugger = false;
                baseURL = null;
                try {
                    if (serverType == 1) {
                        if (startActionType != 3) {
                            launchHttpServer = true;
                        }
                        break block117;
                    }
                    if (serverType == 2 || serverType == 3) {
                        String externalBaseUrl;
                        if (serverType == 2) {
                            externalBaseUrl = configuration.getAttribute("externalBaseUrl", "").trim();
                        } else {
                            String serverId = configuration.getAttribute("serverName", null);
                            String host = null;
                            server = ServerCore.getServerManager().findServer(serverId);
                            if (server != null) {
                                host = server.getHost();
                                if (host == null) {
                                    host = "localhost";
                                }
                                iServerArray = server.getAssociatedServers();
                                n2 = 0;
                                n = iServerArray.length;
                                while (n2 < n) {
                                    associatedServer = iServerArray[n2];
                                    if ("Jaxer Server".equals(associatedServer.getDescription())) {
                                        launchServerDebugger = true;
                                    }
                                    ++n2;
                                }
                            }
                            if (host == null) {
                                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, "Managed server host is not specified", null));
                            }
                            externalBaseUrl = StringUtils.format((String)"http://{0}/", (String)host);
                        }
                        if (externalBaseUrl.length() == 0) {
                            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, "Empty external server URL", null));
                        }
                        if (externalBaseUrl.charAt(externalBaseUrl.length() - 1) != '/') {
                            externalBaseUrl = String.valueOf(externalBaseUrl) + '/';
                        }
                        baseURL = new URL(externalBaseUrl);
                        resourceMapper = new LocalResourceMapper();
                        resourceMapper.addMapping(baseURL, ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile());
                        break block117;
                    }
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, "Server type is not specified", null));
                }
                catch (MalformedURLException e) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_MalformedServerURL, (Throwable)e));
                }
            }
            try {
                String[] args;
                ArrayList<String> browserArgs;
                Process process;
                URL launchURL;
                block121: {
                    Socket socket;
                    block122: {
                        ServerSocket listenSocket;
                        block119: {
                            launchURL = null;
                            try {
                                if (startActionType == 3) {
                                    if (resourceMapper != null) {
                                        JSLaunchConfigurationHelper.setResourceMapping(configuration, baseURL, resourceMapper, httpServer);
                                    }
                                    launchURL = new URL(configuration.getAttribute("startPageUrl", ""));
                                } else {
                                    String resourcePath;
                                    IResource resource = null;
                                    if (startActionType == 1) {
                                        resource = this.getCurrentEditorResource();
                                    } else if (startActionType == 2 && (resourcePath = configuration.getAttribute("startPagePath", null)) != null && resourcePath.length() > 0) {
                                        resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(resourcePath));
                                    }
                                    if (resource != null) {
                                        if (baseURL == null && launchHttpServer) {
                                            monitor.subTask(Messages.JSLaunchConfigurationDelegate_LaunchingHTTPServer);
                                            IHttpServerProviderAdapter httpServerProvider = (IHttpServerProviderAdapter)this.getContributedAdapter(IHttpServerProviderAdapter.class);
                                            server = null;
                                            if (httpServerProvider != null && (server = httpServerProvider.getServer(resource)) != null) {
                                                iServerArray = server.getAssociatedServers();
                                                n2 = 0;
                                                n = iServerArray.length;
                                                while (n2 < n) {
                                                    associatedServer = iServerArray[n2];
                                                    if ("Jaxer Server".equals(associatedServer.getDescription())) {
                                                        launchServerDebugger = true;
                                                    }
                                                    ++n2;
                                                }
                                                IPath documentRoot = server.getDocumentRoot();
                                                if (documentRoot != null && documentRoot.equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation())) {
                                                    appendProjectName = true;
                                                }
                                            }
                                            File root = resource.getProject().getLocation().toFile();
                                            if (server != null) {
                                                baseURL = new URL(StringUtils.format((String)"http://{0}/", (String)server.getHost()));
                                            } else {
                                                httpServer = new HttpServerProcess(launch);
                                                httpServer.setServerRoot(root);
                                                baseURL = httpServer.getBaseURL();
                                            }
                                            if (appendProjectName) {
                                                IProject project = resource.getProject();
                                                baseURL = new URL(baseURL, String.valueOf(project.getName()) + '/');
                                            }
                                            resourceMapper = new LocalResourceMapper();
                                            resourceMapper.addMapping(baseURL, root);
                                            JSLaunchConfigurationHelper.setResourceMapping(configuration, baseURL, resourceMapper, httpServer);
                                            launchURL = resourceMapper.resolveLocalURI(resource.getLocationURI()).toURL();
                                        } else if (baseURL != null) {
                                            IProject project = resource.getProject();
                                            if (appendProjectName) {
                                                baseURL = new URL(baseURL, String.valueOf(project.getName()) + '/');
                                            }
                                            resourceMapper.addMapping(baseURL, project.getLocation().toFile());
                                            JSLaunchConfigurationHelper.setResourceMapping(configuration, baseURL, resourceMapper, httpServer);
                                            launchURL = resourceMapper.resolveLocalURI(resource.getLocationURI()).toURL();
                                        } else {
                                            launchURL = resource.getLocation().toFile().toURI().toURL();
                                        }
                                    } else if (startActionType == 1) {
                                        IPath path = this.getCurrentEditorPath();
                                        if (path != null) {
                                            if (debug && InternetExplorer.isBrowserExecutable(browserExecutable)) {
                                                String errorMessage = "Only project file debugging is currently supported. Use \"Promote to Project\" in the File view to convert a folder to a project.";
                                                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 4, errorMessage, null));
                                            }
                                            launchURL = path.toFile().toURI().toURL();
                                        } else {
                                            launchURL = this.getCurrentEditorURL();
                                            if (launchURL == null) {
                                                monitor.setCanceled(true);
                                                return;
                                            }
                                        }
                                    }
                                }
                                if (launchURL == null) {
                                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_LaunchURLNotDefined, null));
                                }
                                if (launchURL.toExternalForm().endsWith(".js") && InternetExplorer.isBrowserExecutable(browserExecutable)) {
                                    String errorMessage = "Debugging straight JavaScript files is not supported in IE Debugger, please include the script file in an HTML page";
                                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 4, errorMessage, null));
                                }
                                String httpGetQuery = configuration.getAttribute("httpGetData", "");
                                if (httpGetQuery != null && httpGetQuery.length() > 0 && launchURL.getQuery() == null && launchURL.getRef() == null) {
                                    if (httpGetQuery.charAt(0) != '?') {
                                        httpGetQuery = String.valueOf('?') + httpGetQuery;
                                    }
                                    launchURL = new URL(launchURL, String.valueOf(launchURL.getFile()) + httpGetQuery);
                                }
                            }
                            catch (MalformedURLException e) {
                                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_MalformedLaunchURL, (Throwable)e));
                            }
                            monitor.subTask(Messages.JSLaunchConfigurationDelegate_LaunchingBrowser);
                            process = null;
                            browserArgs = new ArrayList<String>();
                            String browserCmdLine = configuration.getAttribute("browserCmdLine", "");
                            if (browserCmdLine != null && browserCmdLine.length() > 0) {
                                args = browserCmdLine.split(" ");
                                int i = 0;
                                while (i < args.length) {
                                    if (args[i].trim().length() > 0) {
                                        browserArgs.add(args[i].trim());
                                    }
                                    ++i;
                                }
                            }
                            args = new ArrayList();
                            if (!debugAvailable) break block121;
                            int port = SocketUtil.findFreePort();
                            if ("true".equals(Platform.getDebugOption((String)"com.aptana.ide.debug.core/debugger_debug"))) {
                                port = 2525;
                            }
                            if (port == -1) {
                                port = 8999;
                            }
                            listenSocket = null;
                            try {
                                listenSocket = new ServerSocket(port);
                                if (!"true".equals(Platform.getDebugOption((String)"com.aptana.ide.debug.core/debugger_debug"))) {
                                    listenSocket.setSoTimeout(30000);
                                }
                            }
                            catch (IOException e) {
                                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_SocketConnectionError, (Throwable)e));
                            }
                            String debuggerLaunchUrl = "http://www.aptana.com/?debugger=true&port=" + Integer.toString(port);
                            if ((launchServerDebugger || "true".equals(Platform.getDebugOption((String)"com.aptana.ide.debug.core/external_server_is_jaxer"))) && "true".equals(Platform.getDebugOption((String)"com.aptana.ide.debug.core/jaxer_debugger"))) {
                                debuggerLaunchUrl = launchURL.toExternalForm();
                                if (launchURL.getQuery() == null) {
                                    debuggerLaunchUrl = String.valueOf(debuggerLaunchUrl) + '?';
                                }
                                debuggerLaunchUrl = String.valueOf(debuggerLaunchUrl) + "__JAXER_DEBUGGER=" + Integer.toString(port);
                            }
                            try {
                                if ("macosx".equals(Platform.getOS())) {
                                    args.add("/usr/bin/open");
                                    if (System.getProperty("os.version", "").startsWith("10.3.")) {
                                        args.add("-a");
                                        args.add(browserExecutable);
                                    } else {
                                        args.add("-b");
                                        args.add(BrowserUtil.getMacOSXApplicationIdentifier(browserExecutable));
                                    }
                                    args.add(debuggerLaunchUrl);
                                } else if (InternetExplorer.isBrowserExecutable(browserExecutable)) {
                                    args.add(browserExecutable);
                                    args.add(debuggerLaunchUrl);
                                } else {
                                    args.add(browserExecutable);
                                    args.add(debuggerLaunchUrl);
                                }
                                if ("true".equals(Platform.getDebugOption((String)"com.aptana.ide.debug.core/debugger_debug"))) {
                                    args = null;
                                }
                                if (args != null) {
                                    args.addAll(browserArgs);
                                    process = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
                                }
                            }
                            catch (IOException e) {
                                if (listenSocket != null) {
                                    try {
                                        listenSocket.close();
                                    }
                                    catch (IOException iOException) {}
                                    listenSocket = null;
                                }
                                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_LaunchProcessError, (Throwable)e));
                            }
                            socket = null;
                            try {
                                try {
                                    monitor.subTask(StringUtils.format((String)Messages.JSLaunchConfigurationDelegate_OpeningSocketOnPort, (int)port));
                                    socket = listenSocket.accept();
                                }
                                catch (IOException e) {
                                    BrowserUtil.resetBrowserCache(browserExecutable);
                                    if (debug) {
                                        throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_SocketConnectionError, (Throwable)e));
                                    }
                                    break block119;
                                }
                            }
                            catch (Throwable throwable) {
                                if (listenSocket != null) {
                                    try {
                                        listenSocket.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                throw throwable;
                            }
                            if (listenSocket != null) {
                                try {
                                    listenSocket.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block122;
                        }
                        if (listenSocket != null) {
                            try {
                                listenSocket.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (socket != null) {
                        monitor.subTask(Messages.JSLaunchConfigurationDelegate_InitializingDebugger);
                        JSDebugTarget debugTarget = null;
                        try {
                            JSDebugProcess debugProcess = new JSDebugProcess(launch, browserExecutable, null);
                            DebugConnection controller = DebugConnection.createConnection(socket);
                            debugTarget = new JSDebugTarget(launch, debugProcess, httpServer, resourceMapper, controller, debug);
                            monitor.subTask(StringUtils.format((String)Messages.JSLaunchConfigurationDelegate_OpeningPage, (Object)launchURL));
                            debugTarget.openURL(launchURL);
                            break block120;
                        }
                        catch (CoreException e) {
                            JSDebugPlugin.log(e);
                            if (debugTarget != null) {
                                debugTarget.terminate();
                            } else {
                                try {
                                    socket.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw e;
                        }
                    }
                    DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)browserExecutable);
                    break block120;
                }
                if ("run".equals(mode)) {
                    try {
                        String launchPage = launchURL.toExternalForm();
                        if ("macosx".equals(Platform.getOS())) {
                            args.add("/usr/bin/open");
                            if (System.getProperty("os.version", "").startsWith("10.3.")) {
                                args.add("-a");
                                args.add(browserExecutable);
                            } else {
                                args.add("-b");
                                args.add(BrowserUtil.getMacOSXApplicationIdentifier(browserExecutable));
                            }
                            args.add(launchPage);
                        } else {
                            args.add(browserExecutable);
                            if (debugCompatible && Firefox.isBrowserExecutable(browserExecutable)) {
                                if (advancedRun) {
                                    args.add("-new-window");
                                    browserArgs.remove("-new-window");
                                    browserArgs.remove("-new-tab");
                                } else {
                                    if (browserArgs.contains("-new-window")) {
                                        args.add("-new-window");
                                    } else {
                                        args.add("-new-tab");
                                    }
                                    browserArgs.remove("-new-window");
                                    browserArgs.remove("-new-tab");
                                }
                            }
                            args.add(launchPage);
                        }
                        args.addAll(browserArgs);
                        process = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, Messages.JSLaunchConfigurationDelegate_LaunchProcessError, (Throwable)e));
                    }
                    DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)browserExecutable);
                    break block120;
                }
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.debug.core", 0, StringUtils.format((String)Messages.JSLaunchConfigurationDelegate_ConfiguredBrowserDoesNotSupportDebugging, (String)browserExecutable), null));
            }
            catch (CoreException e) {
                if (httpServer != null) {
                    launch.removeProcess(httpServer);
                    try {
                        httpServer.terminate();
                    }
                    catch (DebugException e1) {
                        IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e1);
                    }
                }
                throw e;
            }
        }
    }

    protected IResource getCurrentEditorResource() throws MalformedURLException {
        IActiveResourcePathGetterAdapter adapter = (IActiveResourcePathGetterAdapter)this.getContributedAdapter(IActiveResourcePathGetterAdapter.class);
        if (adapter != null) {
            return adapter.getActiveResource();
        }
        return null;
    }

    protected IPath getCurrentEditorPath() throws MalformedURLException {
        IActiveResourcePathGetterAdapter adapter = (IActiveResourcePathGetterAdapter)this.getContributedAdapter(IActiveResourcePathGetterAdapter.class);
        if (adapter != null) {
            return adapter.getActiveResourcePath();
        }
        return null;
    }

    protected URL getCurrentEditorURL() throws MalformedURLException {
        IActiveResourcePathGetterAdapter adapter = (IActiveResourcePathGetterAdapter)this.getContributedAdapter(IActiveResourcePathGetterAdapter.class);
        if (adapter != null) {
            return adapter.getActiveResourceURL();
        }
        return null;
    }

    protected Object getContributedAdapter(Class clazz) {
        Object adapter = null;
        IAdapterManager manager = Platform.getAdapterManager();
        if (manager.hasAdapter((Object)this, clazz.getName()) && (adapter = manager.getAdapter((Object)this, clazz.getName())) == null) {
            adapter = manager.loadAdapter((Object)this, clazz.getName());
        }
        return adapter;
    }
}

