/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ssh.impl.preferences;

import com.aptana.ide.ssh.Activator;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;

public class SSHPreferences {
    public static final String SSH_COMMAND = "ssh";
    private static String defaultSSHCommand = "";

    static {
        if ("macosx".equals(Platform.getOS())) {
            defaultSSHCommand = "/usr/bin/osascript \"{terminal.scpt}\" {user@host}";
        } else if ("win32".equals(Platform.getOS())) {
            defaultSSHCommand = "cmd /C start \"\\\"ssh\\\"\" \"{putty.exe}\" \"{user@host}\"";
        } else if ("linux".equals(Platform.getOS())) {
            defaultSSHCommand = new File("/usr/bin/gnome-terminal").exists() ? "/usr/bin/gnome-terminal -x /usr/bin/ssh \"{user@host}\"" : (new File("/usr/bin/Konsole").exists() ? "/usr/bin/Konsole -x /usr/bin/ssh \"{user@host}\"" : "/usr/bin/xterm -e /usr/bin/ssh \"{user@host}\"");
        } else if ("solaris".equals(Platform.getOS())) {
            defaultSSHCommand = "/usr/bin/xterm -e /usr/bin/ssh \"{user@host}\"";
        }
    }

    public static void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(SSH_COMMAND, defaultSSHCommand);
    }

    public static String getSSHCommand() {
        return Activator.getDefault().getPreferenceStore().getString(SSH_COMMAND);
    }

    public static void setSSHCommand(String SSHCommand) {
        Activator.getDefault().getPreferenceStore().setValue(SSH_COMMAND, SSHCommand);
    }
}

