/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ssh.actions;

import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.server.cloud.server.CloudGroupServer;
import com.aptana.ide.server.cloud.server.CloudServer;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.ssh.Activator;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ServersViewSSHAction
implements IViewActionDelegate {
    private IServer cloudServer;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.cloudServer == null) {
            return;
        }
        User signedInUser = AptanaUser.getSignedInUser();
        if (!signedInUser.hasCredentials()) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("user", signedInUser.getUsername());
        parameters.put("host", this.cloudServer.getHost());
        parameters.put("user@host", String.valueOf(signedInUser.getUsername()) + "@" + this.cloudServer.getHost());
        Activator.getDefault().getSSHLauncher().launchSSH(parameters);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.cloudServer = null;
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            CloudGroupServer cloudGroupServer;
            Set servers;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof CloudServer) {
                this.cloudServer = (IServer)firstElement;
                action.setEnabled(true);
                return;
            }
            if (firstElement instanceof CloudGroupServer && (servers = (cloudGroupServer = (CloudGroupServer)firstElement).getServers()).iterator().hasNext()) {
                this.cloudServer = (IServer)servers.iterator().next();
                action.setEnabled(true);
                return;
            }
        }
    }
}

