/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.formatting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.epl.Activator;
import java.util.Arrays;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public abstract class UnifiedBracketInserterBase
implements VerifyKeyListener,
ILinkedModeListener {
    protected ISourceViewer sourceViewer;
    protected boolean fCloseBrackets = true;
    protected boolean fCloseStrings = true;
    protected boolean fCloseAngularBrackets = false;
    private final String CATEGORY = this.toString();
    private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
    private Stack fBracketLevelStack = new Stack();

    public UnifiedBracketInserterBase(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public static boolean hasPeerCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': 
            case '(': 
            case ')': 
            case '<': 
            case '>': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    public static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '<': {
                return '>';
            }
            case '>': {
                return '<';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isStringBalanced(String source, char charToCheck, boolean isInserting) {
        int insertCount;
        if (!UnifiedBracketInserterBase.hasPeerCharacter(charToCheck)) {
            return true;
        }
        char peer = UnifiedBracketInserterBase.getPeerCharacter(charToCheck);
        char[] sourceChars = source.toCharArray();
        int charCount = 0;
        int peerCount = 0;
        int i = 0;
        while (i < sourceChars.length) {
            if (sourceChars[i] == charToCheck) {
                ++charCount;
            } else if (sourceChars[i] == peer) {
                ++peerCount;
            }
            ++i;
        }
        if (charToCheck == '\"' || charToCheck == '\'') {
            double firstChangeOnly = charCount + 1;
            return firstChangeOnly % 2.0 == 0.0;
        }
        int n = insertCount = isInserting ? 1 : -1;
        return charCount + insertCount == peerCount;
    }

    public void setCloseBracketsEnabled(boolean enabled) {
        this.fCloseBrackets = enabled;
    }

    public void setCloseStringsEnabled(boolean enabled) {
        this.fCloseStrings = enabled;
    }

    public void setCloseAngularBracketsEnabled(boolean enabled) {
        this.fCloseAngularBrackets = enabled;
    }

    protected boolean isAngularIntroducer(String identifier) {
        return identifier.length() > 0 && (Character.isUpperCase(identifier.charAt(0)) || identifier.startsWith("final") || identifier.startsWith("public") || identifier.startsWith("public") || identifier.startsWith("protected") || identifier.startsWith("private"));
    }

    public ITextEditorExtension3.InsertMode getInsertMode() {
        return AbstractDecoratedTextEditor.SMART_INSERT;
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || this.getInsertMode() != AbstractDecoratedTextEditor.SMART_INSERT) {
            return;
        }
        if (!this.isAutoInsertCharacter(event.character)) {
            return;
        }
        if (!this.isAutoInsertEnabled()) {
            return;
        }
        IDocument document = this.sourceViewer.getDocument();
        Point selection = this.sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            if (!this.isValidAutoInsertLocation(event.character, offset, length)) {
                return;
            }
            char character = event.character;
            char closingCharacter = UnifiedBracketInserterBase.getPeerCharacter(character);
            StringBuffer buffer = new StringBuffer();
            buffer.append(character);
            buffer.append(closingCharacter);
            if (offset == document.getLength()) {
                String delim = null;
                if (document instanceof IDocumentExtension4) {
                    delim = ((IDocumentExtension4)document).getDefaultLineDelimiter();
                }
                if (delim == null) {
                    delim = System.getProperty("line.separator", "\r\n");
                }
                buffer.append(delim);
            }
            document.replace(offset, length, buffer.toString());
            BracketLevel level = new BracketLevel();
            this.fBracketLevelStack.push(level);
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
            LinkedModeModel model = new LinkedModeModel();
            model.addLinkingListener((ILinkedModeListener)this);
            model.addGroup(group);
            model.forceInstall();
            level.fOffset = offset;
            level.fLength = 2;
            if (this.fBracketLevelStack.size() == 1) {
                document.addPositionCategory(this.CATEGORY);
                document.addPositionUpdater(this.fUpdater);
            }
            level.fFirstPosition = new Position(offset, 1);
            level.fSecondPosition = new Position(offset + 1, 1);
            document.addPosition(this.CATEGORY, level.fFirstPosition);
            document.addPosition(this.CATEGORY, level.fSecondPosition);
            level.fUI = new EditorLinkedModeUI(model, (ITextViewer)this.sourceViewer);
            level.fUI.setSimpleMode(true);
            level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, UnifiedBracketInserterBase.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
            level.fUI.setExitPosition((ITextViewer)this.sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
            level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            level.fUI.enter();
            IRegion newSelection = level.fUI.getSelectedRegion();
            this.sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
            event.doit = this.doEvent(event);
            this.triggerAssistPopup(event);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Bad location", (Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Bad location", (Throwable)e);
        }
    }

    protected boolean doEvent(VerifyEvent event) {
        return false;
    }

    public void left(LinkedModeModel environment, int flags) {
        final BracketLevel level = (BracketLevel)this.fBracketLevelStack.pop();
        if (flags != 8) {
            return;
        }
        IDocument document = this.sourceViewer.getDocument();
        if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                public void perform(IDocument document, IDocumentListener owner) {
                    if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                        try {
                            document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, null);
                        }
                        catch (BadLocationException e) {
                            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Bad location", (Throwable)e);
                        }
                    }
                    if (UnifiedBracketInserterBase.this.fBracketLevelStack.size() == 0) {
                        document.removePositionUpdater(UnifiedBracketInserterBase.this.fUpdater);
                        try {
                            document.removePositionCategory(UnifiedBracketInserterBase.this.CATEGORY);
                        }
                        catch (BadPositionCategoryException e) {
                            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Bad location", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void suspend(LinkedModeModel environment) {
    }

    public void resume(LinkedModeModel environment, int flags) {
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    protected boolean isValidAutoInsertLocation(char character, int offset, int length) {
        return true;
    }

    private boolean isAutoInsertCharacter(char c) {
        char[] arr = this.getAutoInsertCharacters();
        Arrays.sort(arr);
        int val = Arrays.binarySearch(arr, c);
        return val >= 0;
    }

    protected char[] getAutoInsertCharacters() {
        return new char[]{'\"', '\'', '(', '[', '{'};
    }

    protected boolean isAutoInsertEnabled() {
        return true;
    }

    protected void triggerAssistPopup(VerifyEvent event) {
    }

    protected void triggerAssistClose(VerifyEvent event) {
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        public String getCategory() {
            return this.fCategory;
        }
    }

    private static class BracketLevel {
        int fOffset;
        int fLength;
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        private BracketLevel() {
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack fStack;
        final int fSize;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                if (event.character == this.fExitCharacter) {
                    BracketLevel level = (BracketLevel)this.fStack.peek();
                    if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                        return null;
                    }
                    if (level.fSecondPosition.offset == offset && length == 0) {
                        UnifiedBracketInserterBase.this.triggerAssistClose(event);
                        return new LinkedModeUI.ExitFlags(2, false);
                    }
                }
                if (event.character == '\r' && offset > 0) {
                    IDocument document = UnifiedBracketInserterBase.this.sourceViewer.getDocument();
                    try {
                        if (document.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = UnifiedBracketInserterBase.this.sourceViewer.getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }
}

