/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.BaseFileEditorInput;
import com.aptana.ide.core.BaseFileStorage;
import com.aptana.ide.core.io.IVirtualFile;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class BaseFileEditorInputImpl
implements InvocationHandler,
BaseFileEditorInput {
    private static Class IURIEditorInputClass;
    protected IFileStore fFileStore;
    private WorkbenchAdapter fWorkbenchAdapter = new WorkbenchAdapter();
    private IStorage fStorage;
    private IPath fPath;
    private IVirtualFile virtualFile;

    static {
        try {
            IURIEditorInputClass = Class.forName("org.eclipse.ui.IURIEditorInput");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public BaseFileEditorInputImpl(IFileStore fileStore) {
        Assert.isNotNull((Object)fileStore);
        Assert.isTrue((boolean)"file".equals(fileStore.getFileSystem().getScheme()));
        this.fFileStore = fileStore;
        this.fWorkbenchAdapter = new WorkbenchAdapter();
        this.virtualFile = null;
    }

    public boolean exists() {
        return this.fFileStore.fetchInfo().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fFileStore.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fFileStore.toString();
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class.equals((Object)adapter)) {
            return this;
        }
        if (IWorkbenchAdapter.class.equals((Object)adapter)) {
            return this.fWorkbenchAdapter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath(Object element) {
        if (element instanceof BaseFileEditorInput) {
            return ((BaseFileEditorInput)element).getPath();
        }
        return null;
    }

    public IPath getPath() {
        if (this.fPath == null) {
            this.fPath = new Path(this.fFileStore.toURI().getPath());
        }
        return this.fPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BaseFileEditorInputImpl) {
            BaseFileEditorInputImpl input = (BaseFileEditorInputImpl)o;
            return this.fFileStore.equals(input.fFileStore);
        }
        if (o instanceof IPathEditorInput) {
            IPathEditorInput input = (IPathEditorInput)o;
            return this.getPath().equals((Object)input.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.fFileStore.hashCode();
    }

    public IStorage getStorage() throws CoreException {
        if (this.fStorage == null) {
            this.fStorage = new BaseFileStorage(this.fFileStore);
        }
        return this.fStorage;
    }

    public static IEditorInput create(IFileStore localFile) {
        try {
            BaseFileEditorInputImpl baseFileEditorInput = new BaseFileEditorInputImpl(localFile);
            if (IURIEditorInputClass != null) {
                return (IEditorInput)Proxy.newProxyInstance(BaseFileEditorInput.class.getClassLoader(), new Class[]{BaseFileEditorInput.class, IURIEditorInputClass}, (InvocationHandler)baseFileEditorInput);
            }
            return baseFileEditorInput;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public IVirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    public void setVirtualFile(IVirtualFile virtualFile) {
        this.virtualFile = virtualFile;
    }

    public URI getURI() {
        return this.fFileStore.toURI();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        method = this.getClass().getMethod(method.getName(), method.getParameterTypes());
        return method.invoke((Object)this, args);
    }

    private class WorkbenchAdapter
    implements IWorkbenchAdapter {
        private WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((BaseFileEditorInput)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

