/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.validator;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.css.Messages;
import com.aptana.ide.editor.css.parsing.CSSParseState;
import com.aptana.ide.editor.css.parsing.CSSParser;
import com.aptana.ide.editor.css.validator.NewLineUtils;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.UnifiedErrorReporter;
import com.aptana.ide.editors.unified.utils.Entities;
import com.aptana.ide.editors.validator.ValidatorBase;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.ParserInitializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleReportFactory;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.properties.PropertiesLoader;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Utf8Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylesheetValidator
extends ValidatorBase {
    private static final String APTANA_PROFILE = "AptanaProfile";
    private static final String CONFIG_FILE = "AptanaCSSConfig.properties";
    private static final String PROFILES_CONFIG_FILE = "AptanaCSSProfiles.properties";
    private static final String[] CUSTOM_PROPERTIES = new String[]{"-moz-binding", "-moz-border-radius", "-moz-border-radius-bottomleft", "-moz-border-radius-bottomright", "-moz-border-radius-topleft", "-moz-border-radius-topright", "-moz-border-top-colors", "-moz-border-right-colors", "-moz-border-bottom-colors", "-moz-border-left-colors", "-moz-opacity", "-moz-outline", "-moz-outline-color", "-moz-outline-style", "-moz-outline-width", "-moz-user-focus", "-moz-user-input", "-moz-user-modify", "-moz-user-select", "-o-link", "-o-link-source"};
    private static Pattern errorPattern = Pattern.compile("<(error)>(.*?)</\\1>", 40);
    private static Pattern propertiesPattern = Pattern.compile("<([-A-Za-z0-9_:]+)>(.*?)</\\1>", 40);
    private static Pattern warningPattern = Pattern.compile("<(warning)>(.*?)</\\1>", 40);
    private static final Set<String> NO_MINUS_CUSTOM_PROPERTIES_SET = new HashSet<String>();

    static {
        int i = 0;
        while (i < CUSTOM_PROPERTIES.length) {
            if (CUSTOM_PROPERTIES[i].startsWith("-")) {
                NO_MINUS_CUSTOM_PROPERTIES_SET.add(CUSTOM_PROPERTIES[i].substring(1, CUSTOM_PROPERTIES[i].length()));
            }
            ++i;
        }
    }

    public StylesheetValidator() throws IOException {
        this.loadAptanaCSSProfile();
    }

    public IFileError[] parseForErrors(String path, String source, IFileSourceProvider sourceProvider, boolean collectErrors, boolean collectWarnings, boolean collectInfos) {
        UnifiedErrorReporter reporter = new UnifiedErrorReporter(sourceProvider);
        NewLineUtils newLineUtils = new NewLineUtils(source);
        String patchedSource = this.patchCSSProperties(source, reporter, newLineUtils);
        String report = this.getReport(path, patchedSource);
        String uri = CoreUIUtils.getURI((String)path);
        if (collectErrors) {
            this.processErrorsInReport(report, reporter, uri, false, newLineUtils);
        }
        if (collectWarnings) {
            this.processWarningsInReport(report, reporter, uri, false);
        }
        return reporter.getErrors();
    }

    private String getReport(String path, String sourceString) {
        StyleSheetParser parser = new StyleSheetParser();
        ApplContext ac = new ApplContext("en");
        ac.setCssVersion(APTANA_PROFILE);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(sourceString.getBytes());
            URL url = new URL("file://" + path);
            parser.parseStyleElement(ac, (InputStream)stream, null, null, url, 0);
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)StringUtils.format((String)Messages.CSSErrorManager_InvalidUL, (String)path), (Throwable)e);
        }
        int warningLevel = 2;
        StyleSheet styleSheet = parser.getStyleSheet();
        styleSheet.findConflicts(ac);
        StyleReport style = StyleReportFactory.getStyleReport((ApplContext)ac, (String)"Title", (StyleSheet)styleSheet, (String)"soap12", (int)warningLevel);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        style.print(new PrintWriter(bout));
        String report = bout.toString().replaceAll("m:", "");
        return report;
    }

    private void processErrorsInReport(String report, UnifiedErrorReporter reporter, String baseUri, boolean includeExternal, NewLineUtils utils) {
        int offset = 0;
        String elementName = "errorlist";
        String startTag = "<" + elementName + ">";
        String endTag = "</" + elementName + ">";
        while (offset < report.length()) {
            int errorListStart = report.indexOf(startTag, offset);
            if (errorListStart != -1) {
                int uriStart = report.indexOf("<uri>", errorListStart += startTag.length()) + "<uri>".length();
                int uriEnd = report.indexOf("</uri>", uriStart);
                String uri = report.substring(uriStart, uriEnd);
                int errorListEnd = report.indexOf(endTag, errorListStart);
                String tempPath = CoreUIUtils.getURI((String)uri);
                if ((tempPath = StringUtils.urlEncodeFilename((char[])tempPath.toCharArray())).equals(baseUri) || includeExternal) {
                    String listString = report.substring(errorListStart, errorListEnd);
                    String[] errors = StylesheetValidator.getContent(errorPattern, listString);
                    this.parseCSSErrors(reporter, errors, uri, utils);
                }
                offset = errorListEnd + endTag.length();
                continue;
            }
            offset = report.length();
        }
    }

    private void processWarningsInReport(String report, UnifiedErrorReporter reporter, String baseUri, boolean includeExternal) {
        int offset = 0;
        String elementName = "warninglist";
        String startTag = "<" + elementName + ">";
        String endTag = "</" + elementName + ">";
        while (offset < report.length()) {
            int errorListStart = report.indexOf(startTag, offset);
            if (errorListStart != -1) {
                int uriStart = report.indexOf("<uri>", errorListStart += startTag.length()) + "<uri>".length();
                int uriEnd = report.indexOf("</uri>", uriStart);
                String uri = report.substring(uriStart, uriEnd);
                int errorListEnd = report.indexOf(endTag, errorListStart);
                String tempPath = CoreUIUtils.getURI((String)uri);
                if ((tempPath = StringUtils.urlEncodeFilename((char[])tempPath.toCharArray())).equals(baseUri) || includeExternal) {
                    String listString = report.substring(errorListStart, errorListEnd);
                    String[] warnings = StylesheetValidator.getContent(warningPattern, listString);
                    this.parseCSSWarnings(reporter, warnings, uri);
                }
                offset = errorListEnd + endTag.length();
                continue;
            }
            offset = report.length();
        }
    }

    private void parseCSSErrors(UnifiedErrorReporter err, String[] errors, String filename, NewLineUtils utils) {
        int i = 0;
        while (i < errors.length) {
            Entities e;
            Map<String, String> map = StylesheetValidator.getProperties(errors[i]);
            int line = Integer.parseInt(map.get("line"));
            String msg = map.get("message");
            String context = map.get("context");
            String property = map.get("property");
            String skippedstring = map.get("skippedstring");
            String errorsubtype = map.get("errorsubtype");
            if (msg == null) {
                if (property == null) {
                    property = context;
                }
                if (skippedstring.equals("[empty string]")) {
                    skippedstring = "no properties defined";
                }
                msg = StringUtils.format((String)Messages.CSSErrorManager_ErrorParseMessage, (Object[])new String[]{errorsubtype, skippedstring, property});
            }
            if ((msg = (e = Entities.HTML40).unescape(msg)) != null) {
                int errorOffset = utils.getFirstNonWhitespaceCharacterOffset(line - 1);
                if (errorOffset == -1) {
                    errorOffset = 0;
                }
                err.error(msg, filename, line, context, errorOffset);
            }
            ++i;
        }
    }

    private void parseCSSWarnings(UnifiedErrorReporter err, String[] warnings, String filename) {
        String last = "";
        int i = 0;
        while (i < warnings.length) {
            Map<String, String> map = StylesheetValidator.getProperties(warnings[i]);
            int line = Integer.parseInt(map.get("line"));
            int level = Integer.parseInt(map.get("level"));
            String msg = StringUtils.format((String)Messages.CSSErrorManager_LevelWarningMessage, (Object[])new String[]{map.get("message"), String.valueOf(level)});
            String context = map.get("context");
            String hash = String.valueOf(line) + ":" + level + ":" + msg + ":" + context;
            if (!last.equals(hash) && msg != null) {
                err.warning(msg, filename, line, context, 1);
            }
            last = hash;
            ++i;
        }
    }

    private static Map<String, String> getProperties(String source) {
        Pattern pattern = propertiesPattern;
        Matcher matcher = pattern.matcher(source);
        HashMap<String, String> result = new HashMap<String, String>();
        while (matcher.find()) {
            result.put(matcher.group(1), matcher.group(2));
        }
        return result;
    }

    private static String[] getContent(Pattern pattern, String source) {
        Matcher matcher = pattern.matcher(source);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(matcher.group(2));
        }
        return result.toArray(new String[0]);
    }

    private void loadAptanaCSSProfile() throws IOException {
        InputStream configStream = StylesheetValidator.class.getResourceAsStream(CONFIG_FILE);
        InputStream profilesStream = StylesheetValidator.class.getResourceAsStream(PROFILES_CONFIG_FILE);
        try {
            try {
                Utf8Properties configProperties = new Utf8Properties();
                configProperties.load(configStream);
                Utf8Properties profiles = new Utf8Properties();
                profiles.load(profilesStream);
                PropertiesLoader.config = configProperties;
                Field field = PropertiesLoader.class.getDeclaredField("profiles");
                field.setAccessible(true);
                field.set(null, profiles);
            }
            catch (Throwable th) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Failed to load Aptana CSS profile", (Throwable)th);
            }
        }
        finally {
            configStream.close();
            profilesStream.close();
        }
    }

    private String patchCSSProperties(String source, UnifiedErrorReporter reporter, NewLineUtils utils) {
        try {
            CSSParser parser = new CSSParser();
            CSSParseState state = new CSSParseState();
            state.setEditState(source, source, 0, 0);
            parser.parse((IParseState)state);
            LexemeList lexemes = state.getLexemeList();
            LexemeList lexemesToReplace = new LexemeList();
            int i = 0;
            while (i < lexemes.size()) {
                Lexeme currentLexeme = lexemes.get(i);
                String currentLexemeText = currentLexeme.getText();
                if (this.isCustomPropertyWithoutMinus(currentLexemeText)) {
                    int errorLineNumber = utils.getLineOfOffset(currentLexeme.getStartingOffset());
                    int errorOffset = utils.getFirstNonWhitespaceCharacterOffset(errorLineNumber);
                    if (errorLineNumber == -1) {
                        errorLineNumber = 0;
                    }
                    if (errorOffset == -1) {
                        errorOffset = 0;
                    }
                    reporter.error(String.valueOf(Messages.StylesheetValidator_ILLEGAL_PROPERTY_MESSAGE) + currentLexemeText, "", errorLineNumber + 1, "", errorOffset);
                }
                if (currentLexeme.typeIndex == 47 && currentLexemeText.startsWith("-")) {
                    lexemesToReplace.add(currentLexeme);
                }
                ++i;
            }
            StringBuffer result = new StringBuffer();
            if (lexemesToReplace.size() != 0) {
                int offset = 0;
                int i2 = 0;
                while (i2 < lexemesToReplace.size()) {
                    Lexeme currentLexeme = lexemesToReplace.get(i2);
                    result.append(source.substring(offset, currentLexeme.getStartingOffset()));
                    offset = currentLexeme.getEndingOffset();
                    String currentLexemeText = currentLexeme.getText();
                    String patchedText = currentLexemeText.substring(1, currentLexemeText.length());
                    result.append(patchedText);
                    ++i2;
                }
                Lexeme lastLexeme = lexemesToReplace.get(lexemesToReplace.size() - 1);
                result.append(source.substring(lastLexeme.getEndingOffset()));
            } else {
                result.append(source);
            }
            return result.toString();
        }
        catch (ParserInitializationException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Failed to patch CSS properties", (Throwable)e);
            return source;
        }
        catch (LexerException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Failed to patch CSS properties", (Throwable)e);
            return source;
        }
    }

    private boolean isCustomPropertyWithoutMinus(String propertyName) {
        return NO_MINUS_CUSTOM_PROPERTIES_SET.contains(propertyName);
    }
}

