/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.formatting;

import com.aptana.ide.editor.css.CSSFileLanguageService;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.UnifiedAutoIndentStrategy;
import com.aptana.ide.editors.unified.UnifiedConfiguration;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class CSSAutoIndentStrategy
extends UnifiedAutoIndentStrategy {
    private String linePrefix;

    public CSSAutoIndentStrategy(EditorFileContext context, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        super(context, configuration, sourceViewer);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text == null || command.length > 0) {
            return;
        }
        if (UnifiedConfiguration.isNewlineString((String)command.text)) {
            if (this.isIndentComment(document, command)) {
                this.indentCommentAfterNewLine(document, command);
            } else if (!this.indentAfterOpenBrace(document, command)) {
                super.customizeDocumentCommand(document, command);
            }
        } else {
            super.customizeDocumentCommand(document, command);
        }
    }

    private boolean isIndentComment(IDocument document, DocumentCommand command) {
        LexemeList lexemeList = this.getLexemeList();
        int lexemeFloorIndex = lexemeList.getLexemeFloorIndex(command.offset);
        if (lexemeFloorIndex == -1) {
            return false;
        }
        Lexeme lexemeFromOffset = lexemeList.get(lexemeFloorIndex);
        if (lexemeFromOffset == null) {
            return false;
        }
        int typeIndex = lexemeFromOffset.getToken().getTypeIndex();
        return typeIndex == 3;
    }

    public IPreferenceStore getPreferenceStore() {
        return CSSPlugin.getDefault().getPreferenceStore();
    }

    protected LexemeList getLexemeList() {
        CSSFileLanguageService ls = (CSSFileLanguageService)this.context.getLanguageService("text/css");
        return ls.getFileContext().getLexemeList();
    }

    protected char[] getAutoInsertCharacters() {
        return new char[0];
    }

    protected boolean indentCloseToken(IDocument doc, DocumentCommand c, int offset, int lineOffset, int firstNonWS) {
        boolean isClose = false;
        if (doc.getLength() < 2 || offset < 2) {
            isClose = true;
        } else {
            try {
                if (doc.getChar(offset - 1) == '/' && doc.getChar(offset - 2) == '*') {
                    isClose = true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        if (isClose) {
            String append = this.getIndentationString(doc, lineOffset, firstNonWS);
            if (append.endsWith(" ")) {
                append = append.substring(0, append.length() - 1);
            }
            c.text = String.valueOf(c.text) + append;
            return true;
        }
        return false;
    }

    protected void indentCommentAfterNewLine(IDocument d, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            if (this.indentCloseToken(d, c, offset, lineOffset, firstNonWS)) {
                return;
            }
            if (d.getLength() > firstNonWS + 1 && d.getChar(firstNonWS + 1) == '/') {
                super.indentAfterNewLine(d, c);
                return;
            }
            IPreferenceStore store = CSSPlugin.getDefault().getPreferenceStore();
            boolean useStar = true;
            if (store != null) {
                useStar = true;
            }
            this.linePrefix = useStar ? "* " : " ";
            StringBuffer buf = new StringBuffer(c.text);
            IRegion prefix = this.findPrefixRange(d, line);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            if (firstNonWS < offset && d.getChar(firstNonWS) == '/') {
                buf.append(" " + this.linePrefix);
                if (this.isNewComment(d, offset)) {
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + buf.length();
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                    String endTag = String.valueOf(lineDelimiter) + indentation + " */";
                    if (d.getLength() > firstNonWS + 2 && d.getChar(firstNonWS + 1) == '*') {
                        d.replace(offset, 0, endTag);
                    } else {
                        buf.append(endTag);
                    }
                }
            }
            if (lengthToAdd < prefix.getLength()) {
                c.caretOffset = offset + prefix.getLength() - lengthToAdd;
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    protected boolean isNewComment(IDocument document, int commandOffset) {
        String comment;
        block14: {
            String subComment;
            block15: {
                int firstNewline;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                int lineIndex;
                                block9: {
                                    try {
                                        lineIndex = document.getLineOfOffset(commandOffset) + 1;
                                        if (lineIndex < document.getNumberOfLines()) break block9;
                                        return true;
                                    }
                                    catch (BadLocationException badLocationException) {
                                        return false;
                                    }
                                }
                                IRegion line = document.getLineInformation(lineIndex);
                                ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"__unified_partitioning", (int)commandOffset, (boolean)false);
                                int partitionEnd = partition.getOffset() + partition.getLength() - 1;
                                if (line.getOffset() < partitionEnd) break block10;
                                return true;
                            }
                            comment = this.getLexemeList().getLexemeFromOffset(commandOffset).getText();
                            if (comment.endsWith("*/")) break block11;
                            return true;
                        }
                        firstNewline = comment.indexOf(10);
                        if (comment.length() >= 4) break block12;
                        return true;
                    }
                    if (!comment.startsWith("/**/")) break block13;
                    return false;
                }
                if (firstNewline <= -1 || firstNewline > comment.length()) break block14;
                subComment = comment.substring(firstNewline).trim();
                if (!subComment.startsWith("*")) break block15;
                return false;
            }
            if (subComment.indexOf("\n") != -1) break block14;
            return true;
        }
        return comment.indexOf("/*", 2) != -1;
    }

    protected IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.get(indentEnd, this.linePrefix.length()).equals(this.linePrefix)) {
            ++indentEnd;
            while (indentEnd < lineEnd && document.getChar(indentEnd) == ' ') {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }
}

