/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.extras.plugins;

import com.aptana.ide.extras.plugins.FeatureUtil;
import com.aptana.ide.extras.plugins.Plugin;
import com.aptana.ide.extras.plugins.PluginImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.update.core.IFeatureReference;

public class PluginLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int NAME_COLUMN = 1;
    private static final int VERSION_COLUMN = 2;

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        if (element instanceof Plugin) {
            return null;
        }
        IFeatureReference ref = (IFeatureReference)element;
        if (FeatureUtil.isDisabled(ref)) {
            return PluginImages.getImage("IMG_PLUGIN_DISABLED");
        }
        return PluginImages.getImage("IMG_PLUGIN_ENABLED");
    }

    public String getColumnText(Object element, int columnIndex) {
        IFeatureReference plugin = (IFeatureReference)element;
        try {
            switch (columnIndex) {
                case 1: {
                    return plugin.getName();
                }
                case 2: {
                    return plugin.getVersionedIdentifier().getVersion().toString();
                }
            }
            return "";
        }
        catch (CoreException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getShortVersion(PluginVersionIdentifier version) {
        return "" + version.getMajorComponent() + '.' + version.getMinorComponent() + '.' + version.getServiceComponent();
    }
}

