/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.extras.plugins;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.update.core.IFeatureReference;

public class LatestFeatureFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IFeatureReference ref = (IFeatureReference)element;
        Collection matches = this.findMatching(viewer, ref);
        if (this.isOnlyMatch(matches)) {
            return true;
        }
        return !this.thereIsANewerMatch(ref, matches);
    }

    private boolean isOnlyMatch(Collection matches) {
        return matches.size() <= 1;
    }

    private boolean thereIsANewerMatch(IFeatureReference ref, Collection matches) {
        for (IFeatureReference ref2 : matches) {
            if (ref2.equals(ref)) continue;
            try {
                if (!ref2.getVersionedIdentifier().getVersion().isGreaterThan(ref.getVersionedIdentifier().getVersion())) continue;
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private Collection findMatching(Viewer viewer, IFeatureReference ref) {
        ArrayList<IFeatureReference> matches = new ArrayList<IFeatureReference>();
        Object input = viewer.getInput();
        if (input instanceof Collection) {
            Collection coll = (Collection)input;
            for (IFeatureReference ref2 : coll) {
                try {
                    if (!ref.getVersionedIdentifier().getIdentifier().equals(ref2.getVersionedIdentifier().getIdentifier())) continue;
                    matches.add(ref2);
                }
                catch (CoreException coreException) {}
            }
        }
        return matches;
    }
}

