/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.xul;

import com.aptana.ide.core.FirefoxUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.xul.XULPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.mozilla.interfaces.nsIFile;
import org.mozilla.interfaces.nsIProperties;
import org.mozilla.xpcom.IAppFileLocProvider;
import org.mozilla.xpcom.Mozilla;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FirefoxExtensionsSupport {
    private static final String NS_XPCOM_COMPONENT_DIR_LIST = "ComsDL";
    private static final String NS_CHROME_MANIFESTS_FILE_LIST = "ChromeML";
    private static final String NS_EXT_PREFS_DEFAULTS_DIR_LIST = "ExtPrefDL";
    private static final String NS_APP_APPLICATION_REGISTRY_DIR = "AppRegD";
    private static final String NS_XPCOM_INIT_CURRENT_PROCESS_DIR = "MozBinD";
    private static final String NS_OS_CURRENT_PROCESS_DIR = "CurProcD";
    private static final String NS_XPCOM_CURRENT_PROCESS_DIR = "XCurProcD";
    private static final String NS_GRE_DIR = "GreD";
    private static final String NS_XPCOM_COMPONENT_DIR = "ComsD";
    private static final String NS_GRE_COMPONENT_DIR = "GreComsD";
    private static final String NS_APP_PREF_DEFAULTS_50_DIR = "PrfDef";
    private static final String NS_OS_TEMP_DIR = "TmpD";
    private static final String NS_OS_HOME_DIR = "Home";
    private static final String NS_APP_CACHE_PARENT_DIR = "cachePDir";
    private static final String NS_APP_LOCALSTORE_50_FILE = "LclSt";
    private static final String NS_APP_USER_PROFILE_50_DIR = "ProfD";
    private static final String NS_APP_USER_CHROME_DIR = "UChrm";
    private static final String NS_APP_PREFS_50_DIR = "PrefD";
    private static final String NS_APP_PREFS_50_FILE = "PrefF";
    private static final String NS_APP_USER_MIMETYPES_50_FILE = "UMimTyp";
    private static final String NS_APP_HISTORY_50_FILE = "UHist";
    private static final String NS_APP_PLUGINS_DIR_LIST = "APluginsDL";
    private static final String NS_APP_CHROME_DIR_LIST = "AChromDL";
    private static final String NS_APP_PREFS_DEFAULTS_DIR_LIST = "PrefDL";
    private static final String NS_APP_CHROME_DIR = "AChrom";
    private static final String NS_XPCOM_COMPONENT_REGISTRY_FILE = "ComRegF";
    private static final String NS_XPCOM_XPTI_REGISTRY_FILE = "XptiRegF";
    private static final String NS_DIRECTORYSERVICE_CONTRACTID = "@mozilla.org/file/directory_service;1";
    private static final String XULRUNNER_PATH = "org.eclipse.swt.browser.XULRunnerPath";
    private static final String GRE_INITIALIZED = "org.eclipse.swt.browser.XULRunnerInitialized";
    private static final String XULRUNNER_PLUGIN = "org.mozilla.xulrunner";
    private static final String COMPREG_FILE = "compreg_x.dat";
    private static final String XPTI_FILE = "xpti_x.dat";
    private static final String XULAPPINFO_FILE = "XULAppInfo.js";
    private static final String XULAPPINFO_COMPONENT_DATA = "const CC = Components.classes;\nconst CI = Components.interfaces;\nconst CR = Components.results;\nconst CU = Components.utils;\nCU.import(\"resource://gre/modules/XPCOMUtils.jsm\");\nfunction XULAppInfo() {}\nXULAppInfo.prototype = {\n\tclassDescription: \"XULAppInfo\",\n\tclassID:          Components.ID(\"{c763b610-9d49-455a-bbd2-ede71682a1ac}\"),\n\tcontractID:       \"@mozilla.org/xre/app-info;1\",\n\t// nsISupports\n\tQueryInterface: XPCOMUtils.generateQI([CI.nsIXULAppInfo]),\n\t// nsIXULAppInfo\n\tvendor: \"Mozilla\",\n\tname: \"\",\n\tID: \"\",\n\tversion: \"\",\n\tappBuildID: \"\",\n\tplatformVersion: \"%platformVersion%\",\n\tplatformBuildID: \"%platformBuildID%\"\n};\nfunction NSGetModule(aCompMgr, aFileSpec) {\n\treturn XPCOMUtils.generateModule([XULAppInfo]);\n}\n";
    private static final String[] SUPPORTED_EXTENSIONS = new String[]{"{000a9d1c-beef-4f90-9363-039d445309b8}"};
    private static FirefoxExtensionsSupport instance;
    private File mozillaPath;
    private File profilePath;
    private File tempPath;
    private ArrayList<File> manifests;
    private ArrayList<File> components;
    private ArrayList<File> chromes;
    private ArrayList<File> defaults;

    private FirefoxExtensionsSupport() {
        if ("true".equals(System.getProperty(GRE_INITIALIZED))) {
            IdeLog.logImportant((Plugin)XULPlugin.getDefault(), (String)"Mozilla/GRE haas been already initialized");
            return;
        }
        String xulrunnerPath = System.getProperty(XULRUNNER_PATH);
        if (xulrunnerPath == null) {
            Bundle bundle = Platform.getBundle((String)("org.mozilla.xulrunner." + Platform.getWS() + "." + Platform.getOS() + "." + Platform.getOSArch()));
            if (bundle == null) {
                bundle = Platform.getBundle((String)("org.mozilla.xulrunner." + Platform.getWS() + "." + Platform.getOS()));
            }
            if (bundle == null) {
                bundle = Platform.getBundle((String)("org.mozilla.xulrunner." + Platform.getWS()));
            }
            if (bundle != null) {
                String bundleVersion = (String)bundle.getHeaders().get("Bundle-Version");
                if (bundleVersion.startsWith("1.8.")) {
                    return;
                }
                URL url = bundle.getEntry("/xulrunner");
                if (url != null) {
                    try {
                        url = FileLocator.toFileURL((URL)url);
                        if (url != null) {
                            xulrunnerPath = url.getFile();
                        }
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)XULPlugin.getDefault(), (String)"Error building XULRunner path", (Throwable)e);
                        return;
                    }
                }
            }
        }
        if (xulrunnerPath == null) {
            return;
        }
        this.mozillaPath = new File(xulrunnerPath);
        System.setProperty(XULRUNNER_PATH, this.mozillaPath.getAbsolutePath());
        this.manifests = new ArrayList();
        this.components = new ArrayList();
        this.chromes = new ArrayList();
        this.defaults = new ArrayList();
        this.tempPath = new File(System.getProperty("java.io.tmpdir"), "eclipse_xulrunner");
        String[] tempFiles = new String[]{COMPREG_FILE, XPTI_FILE, XULAPPINFO_FILE, ""};
        if (this.tempPath.exists()) {
            int i = 0;
            while (i < tempFiles.length) {
                File file = new File(this.tempPath, tempFiles[i]);
                if (file.exists() && !file.delete()) {
                    this.tempPath = new File(this.tempPath.getParentFile(), String.valueOf(this.tempPath.getName()) + System.currentTimeMillis());
                    break;
                }
                ++i;
            }
        }
        this.tempPath.mkdirs();
        int i = 0;
        while (i < tempFiles.length) {
            new File(this.tempPath, tempFiles[i]).deleteOnExit();
            ++i;
        }
        this.createXULAppInfo();
        File file = new File(this.mozillaPath, "chrome");
        if (file.isDirectory()) {
            this.chromes.add(file);
            this.manifests.add(file);
        }
        for (String path : this.loadExtensionsList()) {
            file = new File(path, "chrome.manifest");
            if (file.exists()) {
                this.manifests.add(file);
            }
            if ((file = new File(path, "components")).isDirectory()) {
                this.components.add(file);
            }
            if ((file = new File(path, "chrome")).isDirectory()) {
                this.chromes.add(file);
            }
            if (!(file = new File(path, "defaults" + File.separator + "preferences")).isDirectory()) continue;
            this.defaults.add(file);
        }
        Mozilla.getInstance().initialize(this.mozillaPath);
        Mozilla.getInstance().initXPCOM(this.mozillaPath, (IAppFileLocProvider)new LocationProvider());
        System.setProperty(GRE_INITIALIZED, "true");
        nsIProperties directoryService = (nsIProperties)Mozilla.getInstance().getServiceManager().getServiceByContractID(NS_DIRECTORYSERVICE_CONTRACTID, "{78650582-4e93-4b60-8e85-26ebd3eb14ca}");
        nsIFile nsFile = (nsIFile)directoryService.get(NS_APP_APPLICATION_REGISTRY_DIR, "{c8c0a080-0868-11d3-915f-d9d889d48e3c}");
        if (nsFile != null) {
            this.profilePath = new File(nsFile.getPath(), "eclipse");
        }
    }

    private List<String> loadExtensionsList() {
        ArrayList<String> extensions = new ArrayList<String>();
        File profile = FirefoxUtils.findDefaultProfileLocation();
        int i = 0;
        while (i < SUPPORTED_EXTENSIONS.length) {
            String extensionID = SUPPORTED_EXTENSIONS[i];
            String value = PlatformUtils.queryRegestryStringValue((String)"HKEY_LOCAL_MACHINE\\SOFTWARE\\Mozilla\\Firefox\\Extensions", (String)extensionID);
            if (value != null && value.length() > 0) {
                extensions.add(value);
            } else if (profile != null && FirefoxUtils.getExtensionVersion((String)extensionID, (File)profile) != null) {
                extensions.add(new File(new File(profile, "extensions"), extensionID).getAbsolutePath());
            }
            ++i;
        }
        return extensions;
    }

    private void createXULAppInfo() {
        String platformVersion = null;
        String platformBuildID = null;
        File platformIni = new File(this.mozillaPath, "platform.ini");
        if (platformIni.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(platformIni));
                platformVersion = props.getProperty("Milestone");
                platformBuildID = props.getProperty("BuildID");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (platformVersion == null) {
            platformVersion = "1.8";
            platformBuildID = "";
        }
        String data = XULAPPINFO_COMPONENT_DATA.replaceAll("%platformVersion%", platformVersion).replaceAll("%platformBuildID%", platformBuildID);
        try {
            File file = new File(this.tempPath, XULAPPINFO_FILE);
            FileWriter writer = new FileWriter(file, false);
            writer.write(data);
            writer.close();
            this.components.add(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void init() {
        if (instance == null) {
            try {
                instance = new FirefoxExtensionsSupport();
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)XULPlugin.getDefault(), (String)"Init Firefox extensions support failed", (Throwable)e);
            }
        }
    }

    private class LocationProvider
    implements IAppFileLocProvider {
        private LocationProvider() {
        }

        public File getFile(String prop, boolean[] persistent) {
            if (FirefoxExtensionsSupport.NS_XPCOM_INIT_CURRENT_PROCESS_DIR.equals(prop) || FirefoxExtensionsSupport.NS_OS_CURRENT_PROCESS_DIR.equals(prop) || FirefoxExtensionsSupport.NS_XPCOM_CURRENT_PROCESS_DIR.equals(prop) || FirefoxExtensionsSupport.NS_GRE_DIR.equals(prop)) {
                return FirefoxExtensionsSupport.this.mozillaPath;
            }
            if (FirefoxExtensionsSupport.NS_XPCOM_COMPONENT_DIR.equals(prop) || FirefoxExtensionsSupport.NS_GRE_COMPONENT_DIR.equals(prop)) {
                return new File(FirefoxExtensionsSupport.this.mozillaPath, "components");
            }
            if (FirefoxExtensionsSupport.NS_APP_CHROME_DIR.equals(prop)) {
                return new File(FirefoxExtensionsSupport.this.mozillaPath, "chrome");
            }
            if (FirefoxExtensionsSupport.NS_APP_PLUGINS_DIR_LIST.equals(prop)) {
                return new File(FirefoxExtensionsSupport.this.mozillaPath, "plugins");
            }
            if (FirefoxExtensionsSupport.NS_APP_PREF_DEFAULTS_50_DIR.equals(prop) || FirefoxExtensionsSupport.NS_APP_CACHE_PARENT_DIR.equals(prop) || FirefoxExtensionsSupport.NS_APP_USER_PROFILE_50_DIR.equals(prop) || FirefoxExtensionsSupport.NS_APP_PREFS_50_DIR.equals(prop)) {
                return FirefoxExtensionsSupport.this.profilePath;
            }
            if (FirefoxExtensionsSupport.NS_OS_TEMP_DIR.equals(prop)) {
                return FirefoxExtensionsSupport.this.tempPath;
            }
            if (FirefoxExtensionsSupport.NS_XPCOM_COMPONENT_REGISTRY_FILE.equals(prop)) {
                return new File(FirefoxExtensionsSupport.this.tempPath, FirefoxExtensionsSupport.COMPREG_FILE);
            }
            if (FirefoxExtensionsSupport.NS_XPCOM_XPTI_REGISTRY_FILE.equals(prop)) {
                return new File(FirefoxExtensionsSupport.this.tempPath, FirefoxExtensionsSupport.XPTI_FILE);
            }
            if (FirefoxExtensionsSupport.NS_OS_HOME_DIR.equals(prop)) {
                return new File(System.getProperty("user.home"));
            }
            if (FirefoxExtensionsSupport.NS_APP_LOCALSTORE_50_FILE.equals(prop)) {
                if (FirefoxExtensionsSupport.this.profilePath != null) {
                    return new File(FirefoxExtensionsSupport.this.profilePath, "localstore.rdf");
                }
            } else if (FirefoxExtensionsSupport.NS_APP_USER_CHROME_DIR.equals(prop)) {
                if (FirefoxExtensionsSupport.this.profilePath != null) {
                    return new File(FirefoxExtensionsSupport.this.profilePath, "chrome");
                }
            } else if (FirefoxExtensionsSupport.NS_APP_PREFS_50_FILE.equals(prop)) {
                if (FirefoxExtensionsSupport.this.profilePath != null) {
                    return new File(FirefoxExtensionsSupport.this.profilePath, "prefs.js");
                }
            } else if (FirefoxExtensionsSupport.NS_APP_USER_MIMETYPES_50_FILE.equals(prop)) {
                if (FirefoxExtensionsSupport.this.profilePath != null) {
                    return new File(FirefoxExtensionsSupport.this.profilePath, "mimeTypes.rdf");
                }
            } else if (FirefoxExtensionsSupport.NS_APP_HISTORY_50_FILE.equals(prop) && FirefoxExtensionsSupport.this.profilePath != null) {
                return new File(FirefoxExtensionsSupport.this.profilePath, "history.dat");
            }
            return null;
        }

        public File[] getFiles(String prop) {
            if (FirefoxExtensionsSupport.NS_XPCOM_COMPONENT_DIR_LIST.equals(prop) && !FirefoxExtensionsSupport.this.components.isEmpty()) {
                return FirefoxExtensionsSupport.this.components.toArray(new File[FirefoxExtensionsSupport.this.components.size()]);
            }
            if (FirefoxExtensionsSupport.NS_APP_CHROME_DIR_LIST.equals(prop) && !FirefoxExtensionsSupport.this.chromes.isEmpty()) {
                return FirefoxExtensionsSupport.this.chromes.toArray(new File[FirefoxExtensionsSupport.this.chromes.size()]);
            }
            if (FirefoxExtensionsSupport.NS_CHROME_MANIFESTS_FILE_LIST.equals(prop) && !FirefoxExtensionsSupport.this.manifests.isEmpty()) {
                return FirefoxExtensionsSupport.this.manifests.toArray(new File[FirefoxExtensionsSupport.this.manifests.size()]);
            }
            if (FirefoxExtensionsSupport.NS_APP_PREFS_DEFAULTS_DIR_LIST.equals(prop)) {
                return new File[]{new File(FirefoxExtensionsSupport.this.mozillaPath, "defaults" + File.separator + "pref")};
            }
            if (FirefoxExtensionsSupport.NS_EXT_PREFS_DEFAULTS_DIR_LIST.equals(prop) && !FirefoxExtensionsSupport.this.defaults.isEmpty()) {
                return FirefoxExtensionsSupport.this.defaults.toArray(new File[FirefoxExtensionsSupport.this.defaults.size()]);
            }
            return null;
        }
    }
}

