/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.sqlite.Codes;
import org.sqlite.Conn;
import org.sqlite.RS;

final class PrepStmt
extends RS
implements PreparedStatement,
ParameterMetaData,
Codes {
    private int columnCount;
    private int paramCount;
    private int batchPos;
    private Object[] batch;

    PrepStmt(Conn conn, String string) throws SQLException {
        super(conn);
        this.sql = string;
        this.db.prepare(this);
        this.colsMeta = this.db.column_names(this.pointer);
        this.columnCount = this.db.column_count(this.pointer);
        this.paramCount = this.db.bind_parameter_count(this.pointer);
        this.batch = new Object[this.paramCount];
        this.batchPos = 0;
    }

    public void close() throws SQLException {
        this.batch = null;
        if (this.pointer == 0L || this.db == null) {
            this.clearRS();
        } else {
            this.clearParameters();
        }
    }

    public void clearParameters() throws SQLException {
        this.checkOpen();
        this.clearRS();
        this.db.reset(this.pointer);
        this.batchPos = 0;
        if (this.batch != null) {
            for (int i = 0; i < this.batch.length; ++i) {
                this.batch[i] = null;
            }
        }
    }

    protected void finalize() throws SQLException {
        this.db.finalize(this);
    }

    public boolean execute() throws SQLException {
        this.checkExec();
        this.clearRS();
        this.db.reset(this.pointer);
        this.resultsWaiting = this.db.execute(this, this.batch);
        return this.columnCount != 0;
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkExec();
        if (this.columnCount == 0) {
            throw new SQLException("query does not return results");
        }
        this.clearRS();
        this.db.reset(this.pointer);
        this.resultsWaiting = this.db.execute(this, this.batch);
        return this.getResultSet();
    }

    public int executeUpdate() throws SQLException {
        this.checkExec();
        if (this.columnCount != 0) {
            throw new SQLException("query returns results");
        }
        this.clearRS();
        this.db.reset(this.pointer);
        return this.db.executeUpdate(this, this.batch);
    }

    public int[] executeBatch() throws SQLException {
        return this.db.executeBatch(this.pointer, this.batchPos / this.paramCount, this.batch);
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        if (this.pointer == 0L || this.resultsWaiting) {
            return -1;
        }
        return this.db.changes();
    }

    public void addBatch() throws SQLException {
        this.checkExec();
        this.batchPos += this.paramCount;
        if (this.batchPos + this.paramCount > this.batch.length) {
            Object[] objectArray = new Object[this.batch.length * 2];
            System.arraycopy(this.batch, 0, objectArray, 0, this.batch.length);
            this.batch = objectArray;
        }
    }

    public void clearBatch() throws SQLException {
        this.clearParameters();
    }

    public ParameterMetaData getParameterMetaData() {
        return this;
    }

    public int getParameterCount() throws SQLException {
        this.checkExec();
        return this.paramCount;
    }

    public String getParameterClassName(int n) throws SQLException {
        this.checkExec();
        return "java.lang.String";
    }

    public String getParameterTypeName(int n) {
        return "VARCHAR";
    }

    public int getParameterType(int n) {
        return 12;
    }

    public int getParameterMode(int n) {
        return 1;
    }

    public int getPrecision(int n) {
        return 0;
    }

    public int getScale(int n) {
        return 0;
    }

    public int isNullable(int n) {
        return 1;
    }

    public boolean isSigned(int n) {
        return true;
    }

    public Statement getStatement() {
        return this;
    }

    private void batch(int n, Object object) throws SQLException {
        this.checkExec();
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
        }
        this.batch[this.batchPos + n - 1] = object;
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setInt(n, bl ? 1 : 0);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setInt(n, by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.batch(n, byArray);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.batch(n, new Double(d));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, f);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.batch(n, new Integer(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.batch(n, new Long(l));
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setNull(n, n2, null);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.batch(n, null);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.batch(n, object == null ? null : object.toString());
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object);
    }

    public void setShort(int n, short s) throws SQLException {
        this.setInt(n, s);
    }

    public void setString(int n, String string) throws SQLException {
        this.batch(n, string);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setLong(n, date.getTime());
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setLong(n, date.getTime());
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setLong(n, time.getTime());
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setLong(n, time.getTime());
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setLong(n, timestamp.getTime());
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setLong(n, timestamp.getTime());
    }

    public boolean execute(String string) throws SQLException {
        throw this.unused();
    }

    public int executeUpdate(String string) throws SQLException {
        throw this.unused();
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw this.unused();
    }

    public void addBatch(String string) throws SQLException {
        throw this.unused();
    }

    private SQLException unused() {
        return new SQLException("not supported by PreparedStatment");
    }
}

