/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.regex.nfa;

import com.aptana.ide.regex.inputs.Input;

public class NFANode {
    Input _input;
    int _acceptState;
    int _next;
    int[] _epsilon;

    public int getAcceptState() {
        return this._acceptState;
    }

    public void setAcceptState(int state) {
        this._acceptState = state;
    }

    public int[] getEpsilons() {
        return this._epsilon;
    }

    public Input getInput() {
        return this._input;
    }

    public void setInput(Input input) {
        this._input = input;
    }

    public int getNext() {
        return this._next;
    }

    public void setNext(int next) {
        this._next = next;
    }

    public NFANode() {
        this.reset();
    }

    public void addEpsilon(int next) {
        int length = this._epsilon.length;
        int[] epsilons = new int[length + 1];
        System.arraycopy(this._epsilon, 0, epsilons, 0, length);
        epsilons[length] = next;
        this._epsilon = epsilons;
    }

    public void copy(NFANode node) {
        this._input = node._input;
        this._acceptState = node._acceptState;
        this._next = node._next;
        this._epsilon = node._epsilon;
    }

    public boolean hasInputChar(char input) {
        boolean result = false;
        if (this._input != null) {
            result = this._input.hasInput(input);
        }
        return result;
    }

    public void reset() {
        this._input = new Input();
        this._acceptState = -1;
        this._next = -1;
        this._epsilon = new int[0];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("next(");
        if (this._input != null) {
            sb.append(this._input.toString());
        } else {
            sb.append("-");
        }
        sb.append(" -> ");
        if (this._input != null && this._next != -1) {
            sb.append(this._next);
        } else {
            sb.append("-");
        }
        sb.append(")");
        if (this._acceptState != -1) {
            sb.append("+ ");
        } else {
            sb.append("  ");
        }
        sb.append("[");
        if (this._epsilon.length > 0) {
            StringBuffer sb2 = new StringBuffer();
            sb2.append(this._epsilon[0]);
            int i = 1;
            while (i < this._epsilon.length) {
                sb2.append(",").append(this._epsilon[i]);
                ++i;
            }
            sb.append(sb2.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

