/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.regex.nfa;

import com.aptana.ide.regex.IRegexRunner;
import com.aptana.ide.regex.dfa.DFAGraph;
import com.aptana.ide.regex.dfa.DFANode;
import com.aptana.ide.regex.nfa.NFAGraph;
import com.aptana.ide.regex.nfa.NFANode;
import com.aptana.ide.regex.sets.CharacterSet;
import com.aptana.ide.regex.sets.NumberSet;

public class NFAConverter {
    NFAGraph _nfa;
    DFAGraph _dfa;
    CharacterSet _transitionSet;

    public IRegexRunner toDFA(NFAGraph nfaGraph) {
        this._dfa = new DFAGraph();
        this._nfa = nfaGraph;
        this._dfa._transitionSet = this._transitionSet = nfaGraph.getInputSet();
        this._dfa.add(this.epsilonReachable(nfaGraph.getStart()));
        int index = 0;
        while (index < this._dfa.getSize()) {
            DFANode node = (DFANode)this._dfa.getItem(index);
            this.processTransitions(node);
            ++index;
        }
        return this._dfa;
    }

    private NumberSet epsilonReachable(int startIndex) {
        NumberSet result = new NumberSet();
        result.addMember(startIndex);
        int i = 0;
        while (i < result.getSize()) {
            int moveIndex = result.getItem(i);
            NFANode node = this._nfa.getItem(moveIndex);
            result.addMembers(node.getEpsilons());
            ++i;
        }
        return result;
    }

    private int nameIndex(NumberSet numberSet) {
        int result = -1;
        String testSet = numberSet.toString();
        int i = 0;
        while (i < this._dfa.getSize()) {
            DFANode move = (DFANode)this._dfa.getItem(i);
            String testString = move.getTransitionSet().toString();
            if (testSet.equals(testString)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    private void processTransitions(DFANode state) {
        char[] allTransitions = this._transitionSet.getMembers();
        int[] nfaStateIndexes = state.getTransitionSet().getMembers();
        int i = 0;
        while (i < allTransitions.length) {
            NumberSet reachableStates = new NumberSet();
            char inputChar = allTransitions[i];
            int j = 0;
            while (j < nfaStateIndexes.length) {
                int nfaStateIndex = nfaStateIndexes[j];
                NumberSet reachable = this.transitionReachable(nfaStateIndex, inputChar);
                reachableStates.union(reachable);
                int acceptState = this._nfa.getAcceptState(nfaStateIndex);
                if (acceptState != -1) {
                    state.setAcceptState(acceptState);
                }
                ++j;
            }
            if (reachableStates.getSize() != 0) {
                int match = this.nameIndex(reachableStates);
                if (match == -1) {
                    match = this._dfa.add(reachableStates);
                }
                state.setItem(i, match);
            } else {
                state.setItem(i, -1);
            }
            ++i;
        }
    }

    private NumberSet transitionReachable(int moveIndex, char inputChar) {
        NumberSet result;
        NFANode move = this._nfa.getItem(moveIndex);
        if (move.getInput().hasInput(inputChar)) {
            int nextIndex = move.getNext();
            result = this.epsilonReachable(nextIndex);
        } else {
            result = new NumberSet();
        }
        return result;
    }
}

