/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.nodes;

import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeAttribute;
import com.aptana.ide.parsing.nodes.Messages;
import com.aptana.ide.parsing.nodes.ParseFragment;
import com.aptana.ide.parsing.nodes.ParseNodeAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ParseNodeBase
implements IParseNode {
    private static final String SEPARATOR = "/";
    private String _name;
    private String _type;
    private int _typeIndex;
    private IParseNode _parent;
    private IParseNode[] _children;
    private int _size;
    private List<IParseNodeAttribute> _attributes;
    private String _language;
    private Lexeme _startingLexeme;
    private Lexeme _endingLexeme;

    public ParseNodeBase(int typeIndex, String language) {
        this(Integer.toString(typeIndex), typeIndex, language, null, null);
    }

    public ParseNodeBase(int typeIndex, String language, Lexeme startingLexeme) {
        this(Integer.toString(typeIndex), typeIndex, language, startingLexeme, startingLexeme);
    }

    public ParseNodeBase(int typeIndex, String language, Lexeme startingLexeme, Lexeme endingLexeme) {
        this(Integer.toString(typeIndex), typeIndex, language, startingLexeme, endingLexeme);
    }

    public ParseNodeBase(String type, int typeIndex, String language, Lexeme startingLexeme) {
        this(type, typeIndex, language, startingLexeme, startingLexeme);
    }

    public ParseNodeBase(String type, int typeIndex, String language, Lexeme startingLexeme, Lexeme endingLexeme) {
        this._type = type;
        this._typeIndex = typeIndex;
        this._language = language;
        this._startingLexeme = startingLexeme;
        this._endingLexeme = endingLexeme;
        this._children = new IParseNode[0];
    }

    private void add(IParseNode node) {
        int size = this._size + 1;
        int currentLength = this._children.length;
        if (size > currentLength) {
            int newLength = currentLength * 3 / 2 + 1;
            IParseNode[] newList = new IParseNode[newLength];
            System.arraycopy(this._children, 0, newList, 0, this._size);
            this._children = newList;
        }
        this._children[this._size] = node;
        ++this._size;
    }

    public void appendChild(IParseNode child) {
        if (child == null) {
            throw new NullPointerException(Messages.ParseNodeBase_Undefined_Child);
        }
        if (child instanceof ParseFragment) {
            ParseFragment fragment = (ParseFragment)child;
            int i = 0;
            while (i < fragment.getChildCount()) {
                this.appendChildHelper(fragment.getChild(i));
                ++i;
            }
            IParseNodeAttribute[] attributes = fragment.getAttributes();
            int i2 = 0;
            while (i2 < attributes.length) {
                IParseNodeAttribute attr = attributes[i2];
                this.setAttribute(attr.getName(), attr.getValue());
                ++i2;
            }
        } else {
            this.appendChildHelper(child);
        }
    }

    private void appendChildHelper(IParseNode child) {
        this.add(child);
        this.includeLexemesInRange(child.getStartingLexeme(), child.getEndingLexeme());
        if (child instanceof ParseNodeBase) {
            ((ParseNodeBase)child)._parent = this;
        }
    }

    public boolean containsOffset(int offset) {
        boolean result = false;
        if (this._startingLexeme != null && this._endingLexeme != null) {
            int startingOffset = this._startingLexeme.offset;
            int endingOffset = this._endingLexeme.getEndingOffset();
            result = startingOffset <= offset && offset < endingOffset;
        }
        return result;
    }

    protected IParseNodeAttribute createAttribute(String name, String value) {
        return new ParseNodeAttribute(this, name, value);
    }

    public String getAttribute(String attributeName) {
        String result = "";
        if (this._attributes != null) {
            int i = 0;
            while (i < this._attributes.size()) {
                IParseNodeAttribute attribute = this._attributes.get(i);
                if (attribute.getName().equals(attributeName)) {
                    result = attribute.getValue();
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public IParseNodeAttribute getAttributeNode(String attributeName) {
        IParseNodeAttribute result = null;
        if (this._attributes != null) {
            int i = 0;
            while (i < this._attributes.size()) {
                IParseNodeAttribute attribute = this._attributes.get(i);
                if (attribute.getName().equals(attributeName)) {
                    result = attribute;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public IParseNodeAttribute[] getAttributes() {
        if (this._attributes != null) {
            return this._attributes.toArray(new IParseNodeAttribute[this._attributes.size()]);
        }
        return new IParseNodeAttribute[0];
    }

    public IParseNode getChild(int index) {
        IParseNode result = null;
        if (index >= 0 && index < this._size) {
            result = this._children[index];
        }
        return result;
    }

    public int getChildCount() {
        return this._size;
    }

    public int getChildIndex() {
        IParseNode parent = this.getParent();
        int result = 0;
        if (parent != null) {
            int i = 0;
            while (i < parent.getChildCount()) {
                if (parent.getChild(i) == this) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public IParseNode[] getChildren() {
        IParseNode[] result = new IParseNode[this._size];
        if (this._size > 0) {
            System.arraycopy(this._children, 0, result, 0, this._size);
        }
        return result;
    }

    public Lexeme getEndingLexeme() {
        return this._endingLexeme;
    }

    public int getEndingOffset() {
        int result = -1;
        if (this._endingLexeme != null) {
            result = this._endingLexeme.getEndingOffset();
        }
        return result;
    }

    public String getLanguage() {
        return this._language;
    }

    public int getLength() {
        return this.getEndingOffset() - this.getStartingOffset();
    }

    public String getName() {
        if (this._name == null) {
            if (this._startingLexeme != null) {
                this._name = this._startingLexeme.getText();
            } else {
                String name = this.getClass().getName();
                this._name = name = name.substring(name.lastIndexOf(46) + 1);
            }
        }
        return this._name;
    }

    public IParseNode getNodeAtOffset(int offset) {
        IParseNode result = null;
        if (this.containsOffset(offset)) {
            result = this;
            int i = 0;
            while (i < this._size) {
                IParseNode child = this._children[i];
                if (child.containsOffset(offset)) {
                    result = child.getNodeAtOffset(offset);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public IParseNode getParent() {
        return this._parent;
    }

    public String getPath() {
        ArrayList<String> parts = new ArrayList<String>();
        IParseNode current = this;
        while (current != null) {
            parts.add(current.getName());
            parts.add(SEPARATOR);
            current = current.getParent();
        }
        Collections.reverse(parts);
        StringBuffer buffer = new StringBuffer();
        for (String item : parts) {
            buffer.append(item);
        }
        return buffer.toString();
    }

    public IParseNode getRootNode() {
        IParseNode root = this;
        IParseNode p = this._parent;
        while (p != null) {
            root = p;
            p = p.getParent();
        }
        return root;
    }

    public String getSource() {
        SourceWriter writer = new SourceWriter();
        this.getSource(writer);
        return writer.toString();
    }

    public void getSource(SourceWriter writer) {
    }

    public Lexeme getStartingLexeme() {
        return this._startingLexeme;
    }

    public int getStartingOffset() {
        int result = -1;
        if (this._startingLexeme != null) {
            result = this._startingLexeme.offset;
        }
        return result;
    }

    public String getText() {
        return "";
    }

    public String getType() {
        return this._type;
    }

    public int getTypeIndex() {
        return this._typeIndex;
    }

    public String getUniquePath() {
        ArrayList<String> parts = new ArrayList<String>();
        IParseNode current = this;
        while (current != null) {
            int index = current.getChildIndex() + 1;
            parts.add(String.valueOf(current.getName()) + "[" + index + "]");
            parts.add(SEPARATOR);
            current = current.getParent();
        }
        Collections.reverse(parts);
        StringBuffer buffer = new StringBuffer();
        for (String item : parts) {
            buffer.append(item);
        }
        return buffer.toString();
    }

    public String getXML() {
        SourceWriter writer = new SourceWriter();
        this.getXML(writer);
        return writer.toString();
    }

    public void getXML(SourceWriter writer) {
        writer.printWithIndent("<").print(this.getName());
        IParseNodeAttribute[] attrs = this.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            writer.print(" ");
            attrs[i].getSource(writer);
            ++i;
        }
        if (this.hasChildren()) {
            writer.println(">");
            writer.increaseIndent();
            i = 0;
            while (i < this.getChildCount()) {
                this.getChild(i).getXML(writer);
                ++i;
            }
            writer.decreaseIndent();
            writer.printWithIndent("</").print(this.getName()).println(">");
        } else {
            writer.println("/>");
        }
    }

    public boolean hasAttribute(String attributeName) {
        boolean result = false;
        if (this._attributes != null) {
            int i = 0;
            while (i < this._attributes.size()) {
                IParseNodeAttribute attribute = this._attributes.get(i);
                if (attribute.getName().equals(attributeName)) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean hasAttributes() {
        return this._attributes != null && this._attributes.size() > 0;
    }

    public boolean hasChildren() {
        return this._size > 0;
    }

    public boolean includeLexemeInRange(Lexeme lexeme) {
        return this.includeLexemesInRange(lexeme, lexeme);
    }

    public boolean includeLexemesInRange(Lexeme startingLexeme, Lexeme endingLexeme) {
        boolean result = false;
        if (startingLexeme != null && endingLexeme != null && startingLexeme.offset <= endingLexeme.offset) {
            IParseNode parent;
            if (this._startingLexeme == null || startingLexeme.offset != -1 && startingLexeme.getEndingOffset() <= this._startingLexeme.offset) {
                this._startingLexeme = startingLexeme;
                result = true;
            }
            if (this._endingLexeme == null || endingLexeme.offset != -1 && this._endingLexeme.getEndingOffset() <= endingLexeme.offset) {
                this._endingLexeme = endingLexeme;
                result = true;
            }
            if (result && (parent = this._parent) != null) {
                parent.includeLexemesInRange(startingLexeme, endingLexeme);
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.getLength() == 0;
    }

    public void setAttribute(String name, String value) {
        if (name != null && name.length() > 0 && value != null) {
            boolean found = false;
            if (this._attributes != null) {
                int i = 0;
                while (i < this._attributes.size()) {
                    IParseNodeAttribute attribute = this._attributes.get(i);
                    if (attribute.getName().equals(name)) {
                        attribute.setValue(value);
                        found = true;
                        break;
                    }
                    ++i;
                }
            } else {
                this._attributes = new ArrayList<IParseNodeAttribute>();
            }
            if (!found) {
                IParseNodeAttribute attribute = this.createAttribute(name, value);
                this._attributes.add(attribute);
            }
        }
    }

    public void setEndingLexeme(Lexeme endLexeme) {
        this.includeLexemeInRange(endLexeme);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void appendChildBefore(IParseNode node, IParseNode child) {
        if (this._children != null) {
            ArrayList<IParseNode> list = new ArrayList<IParseNode>((Collection)Arrays.asList(this._children));
            int indexOf = list.indexOf(node);
            if (indexOf == -1) {
                this.appendChild(child);
                return;
            }
            ParseNodeBase base = (ParseNodeBase)child;
            base._parent = this;
            list.add(indexOf, child);
            this._children = list.toArray(new IParseNode[list.size()]);
            ++this._size;
        } else {
            this.appendChild(child);
        }
    }

    public void setChildren(IParseNode[] array) {
        this._children = array;
        this._size = array.length;
        IParseNode[] iParseNodeArray = array;
        int n = 0;
        int n2 = iParseNodeArray.length;
        while (n < n2) {
            IParseNode n3 = iParseNodeArray[n];
            ParseNodeBase b = (ParseNodeBase)n3;
            b._parent = this;
            ++n;
        }
    }
}

