/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.bnf.nodes;

import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.DynamicEnumerationMap;
import com.aptana.ide.lexer.IEnumerationMap;
import com.aptana.ide.parsing.bnf.Item;
import com.aptana.ide.parsing.bnf.TerminalList;
import com.aptana.ide.parsing.bnf.nodes.EmptyNode;
import com.aptana.ide.parsing.bnf.nodes.GrammarNodeBase;
import com.aptana.ide.parsing.bnf.nodes.IGrammarNode;
import com.aptana.ide.parsing.bnf.nodes.NonTerminalNode;
import com.aptana.ide.parsing.bnf.nodes.ProductionNode;
import com.aptana.ide.parsing.bnf.nodes.SequenceNode;
import com.aptana.ide.parsing.bnf.nodes.TerminalNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GrammarNode
extends GrammarNodeBase {
    private Map<String, List<ProductionNode>> _productions;
    private String _startingName;
    private TerminalNode _eofNode;
    private IEnumerationMap _terminalMap = new DynamicEnumerationMap();
    private IEnumerationMap _nonTerminalMap = new DynamicEnumerationMap();
    private Map<NodeKey, IGrammarNode> _nodeCache;

    public GrammarNode(String name) {
        super(null, 1, name);
        this._terminalMap.getIntValue("$");
        this._nodeCache = new HashMap<NodeKey, IGrammarNode>();
    }

    public void appendChild(IGrammarNode child) {
        super.appendChild(child);
        if (child.getTypeIndex() == 2) {
            ProductionNode production = (ProductionNode)child;
            String name = production.getName();
            if (this._startingName == null) {
                this._startingName = production.getName();
            }
            if (this._productions == null) {
                this._productions = new HashMap<String, List<ProductionNode>>();
            }
            if (!this._productions.containsKey(name)) {
                this._productions.put(name, new ArrayList());
            }
            this._productions.get(name).add(production);
        }
    }

    public SequenceNode createSequenceNode() {
        return new SequenceNode(this);
    }

    public TerminalNode createEOFNode() {
        if (this._eofNode == null) {
            this._eofNode = this.createTerminalNode("$");
        }
        return this._eofNode;
    }

    public EmptyNode createEmptyNode() {
        return new EmptyNode(this);
    }

    public NonTerminalNode createNonTerminalNode(String name) {
        int index = this._nonTerminalMap.getIntValue(name);
        return new NonTerminalNode(this, name, index);
    }

    public ProductionNode createProductionNode(String name) {
        return new ProductionNode(this, name);
    }

    public TerminalNode createTerminalNode(String name) {
        TerminalNode result;
        int index = this._terminalMap.getIntValue(name);
        NodeKey key = new NodeKey(56, name);
        if (this._nodeCache.containsKey(key)) {
            result = (TerminalNode)this._nodeCache.get(key);
        } else {
            result = new TerminalNode(this, name, index);
            this._nodeCache.put(key, result);
        }
        return result;
    }

    public GrammarNode getExpandedGrammar() {
        GrammarNode result = new GrammarNode(this.getName());
        int i = 0;
        while (i < this.getChildCount()) {
            IGrammarNode child = (IGrammarNode)this.getChild(i);
            if (child.getTypeIndex() == 2) {
                ProductionNode production = (ProductionNode)child;
                String name = production.getName();
                int j = 0;
                while (j < production.getChildCount()) {
                    ProductionNode newProduction = result.createProductionNode(name);
                    newProduction.appendChild(production.getChild(j));
                    result.appendChild(newProduction);
                    ++j;
                }
            }
            ++i;
        }
        result.setStartingName(this.getStartingName());
        return result;
    }

    public TerminalList getFirst(String name) {
        ProductionNode[] productions = this.getProductionsByName(name);
        TerminalList result = new TerminalList();
        int i = 0;
        while (i < productions.length) {
            ProductionNode production = productions[i];
            production.getFirst(result);
            ++i;
        }
        return result;
    }

    public TerminalList getFollow(String name) {
        TerminalList terminals = new TerminalList();
        this.getFollow(name, terminals);
        return terminals;
    }

    public void getFollow(String name, TerminalList terminals) {
        if (name.equals(this._startingName)) {
            terminals.add(this.createEOFNode());
        }
        Item[] itemArray = this.getProductionsWithNonTerminal(name);
        int n = 0;
        int n2 = itemArray.length;
        while (n < n2) {
            Item item = itemArray[n];
            item.getFollow(terminals);
            ++n;
        }
    }

    private Item[] getProductionsWithNonTerminal(String name) {
        ArrayList<Item> result = new ArrayList<Item>();
        int i = 0;
        while (i < this.getChildCount()) {
            ProductionNode productionNode = (ProductionNode)this.getChild(i);
            Item item = productionNode.findNonTerminal(name);
            if (item != null) {
                result.add(item);
            }
            ++i;
        }
        return result.toArray(new Item[result.size()]);
    }

    public String[] getProductionNames() {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < this.getChildCount()) {
            ProductionNode production;
            String name;
            IGrammarNode child = (IGrammarNode)this.getChild(i);
            if (child.getTypeIndex() == 2 && !names.contains(name = (production = (ProductionNode)child).getName())) {
                names.add(name);
            }
            ++i;
        }
        return names.toArray(new String[names.size()]);
    }

    public ProductionNode[] getProductionsByName(String name) {
        List<Object> result = this._productions.containsKey(name) ? this._productions.get(name) : new ArrayList();
        return result.toArray(new ProductionNode[result.size()]);
    }

    public String getStartingName() {
        return this._startingName;
    }

    public IGrammarNode[] getSymbols() {
        ArrayList<IGrammarNode> symbols = new ArrayList<IGrammarNode>();
        symbols.add(this.createEOFNode());
        int i = 0;
        while (i < this.getChildCount()) {
            IGrammarNode child = (IGrammarNode)this.getChild(i);
            child.getSymbols(symbols);
            ++i;
        }
        IGrammarNode[] result = symbols.toArray(new GrammarNodeBase[symbols.size()]);
        Arrays.sort(result, new Comparator<GrammarNodeBase>(){

            @Override
            public int compare(GrammarNodeBase o1, GrammarNodeBase o2) {
                int type1 = o1.getTypeIndex();
                int type2 = o2.getTypeIndex();
                int result = 0;
                if (type1 == type2) {
                    if (type1 == 56) {
                        int index1 = ((TerminalNode)o1).getIndex();
                        int index2 = ((TerminalNode)o2).getIndex();
                        result = index1 - index2;
                    } else {
                        result = o1.getName().compareTo(o2.getName());
                    }
                } else {
                    result = type1 == 56 ? -1 : 1;
                }
                return result;
            }
        });
        return result;
    }

    public void setStartingName(String startingName) {
        this._startingName = startingName;
    }

    public void getSource(SourceWriter writer) {
        if (this.hasChildren()) {
            this.getChild(0).getSource(writer);
            int i = 1;
            while (i < this.getChildCount()) {
                writer.println();
                this.getChild(i).getSource(writer);
                ++i;
            }
        }
    }

    private static class NodeKey {
        public int type;
        public String name;

        public NodeKey(IGrammarNode node) {
            this(node.getTypeIndex(), node.getName());
        }

        public NodeKey(int type, String name) {
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (this == obj) {
                result = true;
            } else if (obj instanceof NodeKey) {
                NodeKey nodeKey = (NodeKey)obj;
                result = this.type == nodeKey.type && this.name == nodeKey.name;
            }
            return result;
        }

        public int hashCode() {
            return this.type ^ this.name.hashCode();
        }
    }
}

