/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing;

import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Offset;
import com.aptana.ide.parsing.IErrorMessage;
import com.aptana.ide.parsing.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ErrorList {
    private List<IErrorMessage> _errors = new ArrayList<IErrorMessage>();

    public IErrorMessage get(int index) {
        return this._errors.get(index);
    }

    public IErrorMessage[] getErrors() {
        return this._errors.toArray(new IErrorMessage[0]);
    }

    public int size() {
        return this._errors.size();
    }

    public void sanityCheck() {
    }

    public void add(IErrorMessage error) {
        if (error == null) {
            throw new IllegalArgumentException(Messages.ErrorList_CannotAddNullErrorNode);
        }
        int insertIndex = Collections.binarySearch(this._errors, error);
        if (insertIndex >= 0) {
            throw new IllegalArgumentException(Messages.ErrorList_ListAlreadyContainsErrorInSameRange);
        }
        insertIndex = -(insertIndex + 1);
        this._errors.add(insertIndex, error);
        error.setOwningList(this);
    }

    public void clear() {
        while (this._errors.size() > 0) {
            this.get(0).clear();
        }
    }

    public int indexOf(int offset) {
        return Collections.binarySearch(this._errors, new Offset(offset));
    }

    public void remove(IErrorMessage error) {
        int index = this._errors.indexOf(error);
        if (index < 0 || index >= this._errors.size() || this.get(index) != error) {
            throw new IllegalStateException(Messages.ErrorList_ListDoesNotContainErrorBeingDeleted);
        }
        this._errors.remove(index);
        error.setOwningList(null);
    }

    public void remove(IRange range) {
        this.remove(range.getStartingOffset(), range.getEndingOffset());
    }

    public void remove(int startingOffset, int endingOffset) {
        int startingIndex = this.indexOf(startingOffset);
        int endingIndex = this.indexOf(endingOffset);
        if (startingIndex < 0) {
            startingIndex = -(startingIndex + 1);
        }
        endingIndex = endingIndex < 0 ? -(endingIndex + 1) : ++endingIndex;
        int count = endingIndex - startingIndex;
        while (count > 0) {
            this.get(startingIndex).clear();
            --count;
        }
    }
}

