/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.ICodeBasedTokenList;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.Messages;
import com.aptana.ide.lexer.matcher.OrMatcher;
import java.util.HashMap;
import java.util.Map;

public class MatcherTokenList
extends TokenList
implements ICodeBasedTokenList {
    private Map<String, OrMatcher> _matchersByName = new HashMap<String, OrMatcher>();
    private OrMatcher _currentMatcher;
    private int _lastMatchedTokenIndex;

    public MatcherTokenList() {
    }

    public MatcherTokenList(String language) {
        super(language);
    }

    public void addMatcherToGroup(ITextMatcher matcher, String group) {
        OrMatcher matchers = null;
        if (this._matchersByName.containsKey(group)) {
            matchers = this._matchersByName.get(group);
        } else {
            matchers = new OrMatcher();
            this._matchersByName.put(group, matchers);
        }
        matchers.appendChild(matcher);
    }

    public Range find(char[] source, int startingPosition, int eofOffset) {
        Range result = Range.Empty;
        return result;
    }

    public int getLastMatchedTokenIndex() {
        return this._lastMatchedTokenIndex;
    }

    public int match(char[] source, int startingPosition, int eofOffset) {
        int result = -1;
        if (startingPosition < eofOffset && this._currentMatcher != null && (result = this._currentMatcher.match(source, startingPosition, eofOffset)) != -1) {
            IToken matchedToken = this._currentMatcher.getMatchedToken();
            if (matchedToken != null) {
                this._lastMatchedTokenIndex = matchedToken.getIndex();
            } else {
                result = -1;
            }
        }
        return result;
    }

    public void seal() throws LexerException {
        super.seal();
        int groupCount = this.getGroupCount();
        int i = 0;
        while (i < groupCount) {
            String group = this.getGroup(i);
            if (this._matchersByName.containsKey(group)) {
                OrMatcher or = this._matchersByName.get(group);
                or.buildFirstCharacterMap();
            }
            ++i;
        }
    }

    public void setCurrentGroup(String groupName) throws LexerException {
        super.setCurrentGroup(groupName);
        OrMatcher newGroup = this._matchersByName.get(groupName);
        if (newGroup == null) {
            throw new LexerException(String.valueOf(Messages.MatcherTokenList_Unrecognzied_Group_Name) + groupName, null);
        }
        this._currentMatcher = newGroup;
    }

    public void setCurrentGroup(int index) {
        super.setCurrentGroup(index);
        this._currentMatcher = this._matchersByName.get(this.getCurrentGroup());
    }

    public OrMatcher getCurrentMatcher() {
        return this._currentMatcher;
    }

    public boolean hasGroup(String groupName) {
        return this._matchersByName.containsKey(groupName);
    }
}

