/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatcherMap {
    private static final ITextMatcher[] NO_MATCHERS = new ITextMatcher[0];
    private Map<Character, List<ITextMatcher>> _map;
    private Map<Character, ITextMatcher[]> _sealedMap;
    private CharacterClassMap _uncategorizedMatchers;
    private boolean _hasBuiltinCharacterClass;
    private boolean _sealed;
    private CharacterClassMap _digitMatchers;
    private CharacterClassMap _letterMatchers;
    private CharacterClassMap _whitespaceMatchers;
    private CharacterClassMap _negatedDigitMatchers;
    private CharacterClassMap _negatedLetterMatchers;
    private CharacterClassMap _negatedWhitespaceMatchers;

    public void addCharacterMatcher(char c, ITextMatcher matcher) {
        if (!this._sealed && matcher != null) {
            List<ITextMatcher> list;
            if (this._map == null) {
                this._map = new HashMap<Character, List<ITextMatcher>>();
            }
            if (!this._map.containsKey(Character.valueOf(c))) {
                this._map.put(Character.valueOf(c), new ArrayList());
            }
            if (!(list = this._map.get(Character.valueOf(c))).contains(matcher)) {
                list.add(matcher);
            }
        }
    }

    public void addDigitMatcher(ITextMatcher matcher) {
        if (!this._sealed) {
            if (this._digitMatchers == null) {
                this._digitMatchers = new CharacterClassMap();
            }
            this._digitMatchers.addMatcher(matcher);
        }
    }

    public void addLetterMatcher(ITextMatcher matcher) {
        if (!this._sealed) {
            if (this._letterMatchers == null) {
                this._letterMatchers = new CharacterClassMap();
            }
            this._letterMatchers.addMatcher(matcher);
        }
    }

    public void addNegatedCharacterMatcher(char c, ITextMatcher matcher) {
        this.addUncategorizedMatcher(matcher);
    }

    public void addNegatedDigitMatcher(ITextMatcher matcher) {
        if (!this._sealed) {
            if (this._negatedDigitMatchers == null) {
                this._negatedDigitMatchers = new CharacterClassMap();
            }
            this._negatedDigitMatchers.addMatcher(matcher);
        }
    }

    public void addNegatedLetterMatcher(ITextMatcher matcher) {
        if (!this._sealed) {
            if (this._negatedLetterMatchers == null) {
                this._negatedLetterMatchers = new CharacterClassMap();
            }
            this._negatedLetterMatchers.addMatcher(matcher);
        }
    }

    public void addNegatedWhitespaceMatcher(ITextMatcher matcher) {
        if (!this._sealed) {
            if (this._negatedWhitespaceMatchers == null) {
                this._negatedWhitespaceMatchers = new CharacterClassMap();
            }
            this._negatedWhitespaceMatchers.addMatcher(matcher);
        }
    }

    public void addUncategorizedMatcher(ITextMatcher matcher) {
        if (!this._sealed) {
            if (this._uncategorizedMatchers == null) {
                this._uncategorizedMatchers = new CharacterClassMap();
            }
            this._uncategorizedMatchers.addMatcher(matcher);
        }
    }

    public void addWhitespaceMatcher(ITextMatcher matcher) {
        if (!this._sealed) {
            if (this._whitespaceMatchers == null) {
                this._whitespaceMatchers = new CharacterClassMap();
            }
            this._whitespaceMatchers.addMatcher(matcher);
        }
    }

    private void appendToList(boolean isInCharacterClass, CharacterClassMap map, List<ITextMatcher> matchers) {
        if (isInCharacterClass && map != null) {
            matchers.addAll(map.getMatcherList());
        }
    }

    private void appendToMap(boolean isInCharacteClass, List<ITextMatcher> matcher, CharacterClassMap map) {
        if (isInCharacteClass && map != null) {
            map.addAllMatchers(matcher);
        }
    }

    public ITextMatcher[] getMatchers(char c) {
        if (!this._sealed) {
            throw new IllegalStateException(Messages.MatcherMap_Call_SetSeal_Before_GetMatchers);
        }
        ITextMatcher[] result = null;
        if (this._sealedMap != null) {
            result = this._sealedMap.get(Character.valueOf(c));
        }
        if (result == null) {
            result = NO_MATCHERS;
            if (this._hasBuiltinCharacterClass) {
                if (this._letterMatchers != null && Character.isLetter(c)) {
                    result = this._letterMatchers.getMatchers();
                } else if (this._digitMatchers != null && Character.isDigit(c)) {
                    result = this._digitMatchers.getMatchers();
                } else if (this._whitespaceMatchers != null && Character.isWhitespace(c)) {
                    result = this._whitespaceMatchers.getMatchers();
                } else if (this._negatedDigitMatchers != null && !Character.isDigit(c)) {
                    result = this._negatedDigitMatchers.getMatchers();
                } else if (this._negatedLetterMatchers != null && !Character.isLetter(c)) {
                    result = this._negatedLetterMatchers.getMatchers();
                } else if (this._negatedWhitespaceMatchers != null && !Character.isWhitespace(c)) {
                    result = this._negatedWhitespaceMatchers.getMatchers();
                } else if (this._uncategorizedMatchers != null) {
                    result = this._uncategorizedMatchers.getMatchers();
                }
            } else if (this._uncategorizedMatchers != null) {
                result = this._uncategorizedMatchers.getMatchers();
            }
        }
        return result;
    }

    public ITextMatcher[] getUncategorizedMatchers() {
        if (!this._sealed) {
            throw new IllegalStateException(Messages.MatcherMap_Call_SetSeal_Before_GetMatchers);
        }
        ITextMatcher[] result = NO_MATCHERS;
        if (this._uncategorizedMatchers != null) {
            result = this._uncategorizedMatchers.getMatchers();
        }
        return result;
    }

    public boolean hasUncategorizedMatchers() {
        boolean result = false;
        if (this._uncategorizedMatchers != null) {
            result = this._uncategorizedMatchers.hasMatchers();
        }
        return result;
    }

    private void sealCharacterClass(CharacterClassMap map) {
        if (map != null) {
            map.setSealed();
        }
    }

    public void setSealed() {
        if (this._map != null) {
            Set<Character> keys = this._map.keySet();
            Iterator<Character> iter = keys.iterator();
            this._sealedMap = new HashMap<Character, ITextMatcher[]>();
            while (iter.hasNext()) {
                char c = iter.next().charValue();
                List<ITextMatcher> matcherList = this._map.get(Character.valueOf(c));
                this.appendToList(Character.isLetter(c), this._letterMatchers, matcherList);
                this.appendToList(Character.isDigit(c), this._digitMatchers, matcherList);
                this.appendToList(Character.isWhitespace(c), this._whitespaceMatchers, matcherList);
                this.appendToList(!Character.isLetter(c), this._negatedLetterMatchers, matcherList);
                this.appendToList(!Character.isDigit(c), this._negatedDigitMatchers, matcherList);
                this.appendToList(!Character.isWhitespace(c), this._negatedWhitespaceMatchers, matcherList);
                this.appendToList(true, this._uncategorizedMatchers, matcherList);
                Object[] matchers = matcherList.toArray(new ITextMatcher[matcherList.size()]);
                Arrays.sort(matchers);
                this._sealedMap.put(Character.valueOf(c), (ITextMatcher[])matchers);
            }
            this._map = null;
        }
        if (this.hasUncategorizedMatchers()) {
            List<ITextMatcher> matcherList = this._uncategorizedMatchers.getMatcherList();
            this.appendToMap(true, matcherList, this._letterMatchers);
            this.appendToMap(true, matcherList, this._digitMatchers);
            this.appendToMap(true, matcherList, this._whitespaceMatchers);
            this.appendToMap(true, matcherList, this._negatedLetterMatchers);
            this.appendToMap(true, matcherList, this._negatedDigitMatchers);
            this.appendToMap(true, matcherList, this._negatedWhitespaceMatchers);
        }
        this.sealCharacterClass(this._uncategorizedMatchers);
        this.sealCharacterClass(this._letterMatchers);
        this.sealCharacterClass(this._digitMatchers);
        this.sealCharacterClass(this._whitespaceMatchers);
        this.sealCharacterClass(this._negatedDigitMatchers);
        this.sealCharacterClass(this._negatedLetterMatchers);
        this.sealCharacterClass(this._negatedWhitespaceMatchers);
        this._sealed = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CharacterClassMap {
        private List<ITextMatcher> _matchers;
        private ITextMatcher[] _cache;
        private boolean _sealed;

        public void addAllMatchers(List<ITextMatcher> matchers) {
            if (!this._sealed && matchers != null) {
                this._matchers.addAll(matchers);
            }
        }

        public void addMatcher(ITextMatcher matcher) {
            if (!this._sealed) {
                if (this._matchers == null) {
                    this._matchers = new ArrayList<ITextMatcher>();
                }
                if (!this._matchers.contains(matcher)) {
                    this._matchers.add(matcher);
                    this._cache = null;
                    MatcherMap.this._hasBuiltinCharacterClass = true;
                }
            }
        }

        public List<ITextMatcher> getMatcherList() {
            return this._matchers;
        }

        public ITextMatcher[] getMatchers() {
            if (this._cache == null && this._matchers != null) {
                this._cache = this._matchers.toArray(new ITextMatcher[this._matchers.size()]);
                Arrays.sort(this._cache);
            }
            return this._cache;
        }

        public boolean hasMatchers() {
            return this._matchers != null && this._matchers.size() > 0 || this._cache != null && this._cache.length > 0;
        }

        public void setSealed() {
            if (!this._sealed) {
                this._sealed = true;
                this._cache = null;
                this.getMatchers();
                this._matchers = null;
            }
        }
    }
}

