/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer;

import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.Messages;
import com.aptana.ide.lexer.Range;

public class LexemeList {
    private static final Lexeme[] NO_LEXEMES = new Lexeme[0];
    private transient Lexeme[] _lexemes;
    private int _size;
    private Range _affectedRegion;

    public LexemeList() {
        this._lexemes = new Lexeme[128];
        this._affectedRegion = new Range();
    }

    public LexemeList(Lexeme[] lexemes) {
        this._lexemes = lexemes;
        this._affectedRegion = new Range();
        this._size = lexemes.length;
    }

    private void add(int index, Lexeme lexeme) {
        int size = this._size + 1;
        int currentLength = this._lexemes.length;
        if (size > currentLength) {
            int newLength = currentLength * 3 / 2 + 1;
            Lexeme[] newList = new Lexeme[newLength];
            System.arraycopy(this._lexemes, 0, newList, 0, this._size);
            this._lexemes = newList;
        }
        System.arraycopy(this._lexemes, index, this._lexemes, index + 1, this._size - index);
        this._lexemes[index] = lexeme;
        ++this._size;
    }

    public synchronized void add(Lexeme lexeme) {
        if (lexeme == null || lexeme.offset < 0) {
            throw new IllegalArgumentException(Messages.LexemeList_Lexeme_Must_Be_Defined);
        }
        int lexemeIndex = this.getLexemeIndex(lexeme.offset);
        if (lexemeIndex < 0) {
            int insertIndex = -(lexemeIndex + 1);
            this.add(insertIndex, lexeme);
            this._affectedRegion.includeInRange(lexeme);
            int followingIndex = insertIndex + 1;
            while (followingIndex < this._size) {
                if (!this._lexemes[followingIndex].isOverlapping(lexeme)) break;
                this._affectedRegion.includeInRange(this._lexemes[followingIndex]);
                this.remove(followingIndex);
            }
        }
    }

    public synchronized void clear() {
        int i = 0;
        while (i < this._size) {
            this._lexemes[i] = null;
            ++i;
        }
        this._size = 0;
        this._affectedRegion.clear();
    }

    public synchronized Lexeme[] cloneRange(int startingIndex, int endingIndex) {
        Lexeme[] result = NO_LEXEMES;
        if (startingIndex >= 0 && startingIndex < this._size && endingIndex >= 0 && endingIndex < this._size && startingIndex <= endingIndex) {
            int size = endingIndex - startingIndex + 1;
            result = new Lexeme[size];
            int i = startingIndex;
            while (i <= endingIndex) {
                Lexeme lexeme = this._lexemes[i];
                try {
                    result[i - startingIndex] = (Lexeme)lexeme.clone();
                }
                catch (Exception exception) {
                    result[i - startingIndex] = lexeme;
                }
                ++i;
            }
        }
        return result;
    }

    public synchronized Lexeme[] copyRange(int startingIndex, int endingIndex) {
        Lexeme[] result = NO_LEXEMES;
        if (startingIndex >= 0 && startingIndex < this._size && endingIndex >= 0 && endingIndex < this._size && startingIndex <= endingIndex) {
            int size = endingIndex - startingIndex + 1;
            result = new Lexeme[size];
            System.arraycopy(this._lexemes, startingIndex, result, 0, size);
        }
        return result;
    }

    public synchronized Lexeme get(int index) {
        Lexeme result = null;
        if (index >= 0 && index < this._size) {
            result = this._lexemes[index];
        }
        return result;
    }

    public synchronized Range getAffectedRegion() {
        return this._affectedRegion;
    }

    public synchronized Lexeme getCeilingLexeme(int offset) {
        int index = this.getLexemeCeilingIndex(offset);
        Lexeme result = null;
        if (index >= 0) {
            result = this._lexemes[index];
        }
        return result;
    }

    public synchronized Lexeme getFloorLexeme(int offset) {
        int index = this.getLexemeFloorIndex(offset);
        Lexeme result = null;
        if (index >= 0) {
            result = this._lexemes[index];
        }
        return result;
    }

    public synchronized int getLexemeCeilingIndex(int offset) {
        int length = this._size;
        int result = -1;
        if (length > 0 && (result = this.getLexemeIndex(offset)) < 0 && (result = -(result + 1)) >= length) {
            result = -1;
        }
        return result;
    }

    public synchronized int getLexemeFloorIndex(int offset) {
        int result = -1;
        if (this._size > 0 && (result = this.getLexemeIndex(offset)) < 0 && (result = -(result + 1) - 1) < 0) {
            result = -1;
        }
        return result;
    }

    public synchronized Lexeme getLexemeFromOffset(int offset) {
        int index = this.getLexemeIndex(offset);
        Lexeme result = null;
        if (index >= 0 && index < this._size) {
            result = this._lexemes[index];
        }
        return result;
    }

    public synchronized int getLexemeIndex(int offset) {
        int low = 0;
        int high = this._size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Lexeme candidate = this._lexemes[mid];
            if (offset < candidate.offset) {
                high = mid - 1;
                continue;
            }
            if (candidate.offset + candidate.length <= offset) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public synchronized int getLexemeIndex(Lexeme lexeme) {
        int candidate;
        int result = -1;
        if (lexeme != null && (candidate = this.getLexemeIndex(lexeme.offset)) >= 0 && this._lexemes[candidate] == lexeme) {
            result = candidate;
        }
        return result;
    }

    public synchronized void remove(int index) {
        if (index >= 0 && index < this._size) {
            int remainder = this._size - index - 1;
            if (remainder > 0) {
                System.arraycopy(this._lexemes, index + 1, this._lexemes, index, remainder);
            }
            --this._size;
            this._lexemes[this._size] = null;
        }
    }

    public synchronized void remove(int startingIndex, int endingIndex) {
        if (startingIndex >= 0 && startingIndex < this._size && endingIndex >= 0 && endingIndex < this._size && startingIndex <= endingIndex) {
            int i = startingIndex;
            while (i <= endingIndex) {
                this.remove(startingIndex);
                ++i;
            }
        }
    }

    public synchronized void remove(Lexeme lexeme) {
        int index;
        if (lexeme != null && (index = this.getLexemeIndex(lexeme.offset)) >= 0 && this._lexemes[index] == lexeme) {
            this.remove(index);
        }
    }

    public synchronized void remove(Lexeme startingLexeme, Lexeme endingLexeme) {
        if (startingLexeme != null && endingLexeme != null) {
            int startingIndex = this.getLexemeIndex(startingLexeme.offset);
            int endingIndex = this.getLexemeIndex(endingLexeme.offset);
            if (startingIndex >= 0 && endingIndex >= 0 && startingIndex <= endingIndex && startingLexeme == this._lexemes[startingIndex] && endingLexeme == this._lexemes[endingIndex]) {
                int i = startingIndex;
                while (i <= endingIndex) {
                    this.remove(startingIndex);
                    ++i;
                }
            }
        }
    }

    public synchronized void shiftLexemeOffsets(int startingIndex, int offsetDelta) {
        if (startingIndex >= 0) {
            int i = startingIndex;
            while (i < this._size) {
                this._lexemes[i].adjustOffset(offsetDelta);
                ++i;
            }
        }
    }

    public synchronized int size() {
        return this._size;
    }

    public Lexeme[] toArray() {
        if (this._size > 0) {
            return this.copyRange(0, this._size - 1);
        }
        return NO_LEXEMES;
    }

    public void setContents(Lexeme[] array) {
        this._lexemes = array;
        this._size = array.length;
    }
}

