/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.portal.comet;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.licensing.ClientKey;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.server.jetty.comet.CometClient;
import com.aptana.ide.server.portal.PortalPlugin;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import org.eclipse.core.runtime.Plugin;

public class LicenseClient
extends CometClient {
    public static final String LICENSE_CHANNEL = "/portal/license";
    public static final String TYPE = "type";
    public static final String PRO = "pro";
    public static final String NONE = "none";
    public static final String TRIAL = "trial";
    public static final String EXPIRES = "expires";
    public static final String DAYS_LEFT = "daysLeft";
    public static final String LICENSE_STATUS = "licenseStatus";

    protected Object getResponse(String toChannel, Object request) {
        if (LICENSE_CHANNEL.equals(toChannel)) {
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            responseData.put("response", LICENSE_STATUS);
            ClientKey key = CoreUIPlugin.getActivationKey();
            if (key != null) {
                if (!key.isValid()) {
                    responseData.put(TYPE, NONE);
                    responseData.put(DAYS_LEFT, 0);
                    IdeLog.logError((Plugin)PortalPlugin.getDefault(), (String)"License Channel: Key Is No Longer Valid.");
                } else {
                    if (key.isTrial()) {
                        responseData.put(TYPE, TRIAL);
                    } else if (key.isPro()) {
                        responseData.put(TYPE, PRO);
                    }
                    Calendar cal = key.getExpiration();
                    if (cal != null) {
                        responseData.put(EXPIRES, String.valueOf(cal.get(2)) + "/" + cal.get(5) + "/" + cal.get(1));
                        Calendar currentCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                        long currMilis = currentCalendar.getTimeInMillis();
                        long expMillis = key.getExpiration().getTimeInMillis();
                        long daysLeft = expMillis - currMilis;
                        double days = (double)daysLeft / 8.64E7;
                        daysLeft = (long)Math.floor(days);
                        if (daysLeft < 0L) {
                            daysLeft = 0L;
                        }
                        responseData.put(DAYS_LEFT, daysLeft);
                        IdeLog.logError((Plugin)PortalPlugin.getDefault(), (String)("License Channel: Days Left:" + daysLeft));
                    }
                    IdeLog.logError((Plugin)PortalPlugin.getDefault(), (String)"License Channel: Key is valid but unable to get calendar from the key's expiration.", null);
                }
            } else {
                responseData.put(TYPE, NONE);
                IdeLog.logError((Plugin)PortalPlugin.getDefault(), (String)"License Channel: No Key found.");
            }
            return responseData;
        }
        IdeLog.logError((Plugin)PortalPlugin.getDefault(), (String)"License Channel: No channel available to specify the Studio Pro Key.");
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{LICENSE_CHANNEL};
    }

    protected String getID(String msgId) {
        return Long.toString(System.currentTimeMillis());
    }
}

