/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.logging.view.LogView;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.ILog;
import com.aptana.ide.server.core.ILogOpener;
import com.aptana.ide.server.core.INamedLog;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.impl.Configuration;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.actions.Messages;
import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenLogAction
extends Action {
    private ISelectionProvider provider;

    public OpenLogAction(ISelectionProvider provider) {
        this(provider, 4);
    }

    public OpenLogAction(ISelectionProvider provider, int style) {
        super("", style);
        this.setImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/windowlist.png"));
        this.setToolTipText(Messages.OpenLogAction_Title0);
        this.provider = provider;
        provider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OpenLogAction.this.selectionChanged(event);
            }
        });
        this.setMenuCreator(new IMenuCreator(){

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                MenuManager mn = new MenuManager();
                OpenLogAction.this.fillManager(mn);
                return mn.createContextMenu(parent);
            }

            public Menu getMenu(Menu parent) {
                MenuManager mn = new MenuManager();
                OpenLogAction.this.fillManager(mn);
                Menu menu = new Menu(parent);
                mn.fill(menu, 0);
                return menu;
            }
        });
    }

    private void fillManager(MenuManager mn) {
        ISelection selection = this.provider.getSelection();
        if (selection instanceof StructuredSelection && !selection.isEmpty()) {
            StructuredSelection ss = (StructuredSelection)selection;
            final IServer server = (IServer)ss.getFirstElement();
            ILog[] logs = server.getAllLogs();
            final Object logOpener = server.getAdapter(ILogOpener.class);
            if (logs != null) {
                ILog[] iLogArray = logs;
                int n = 0;
                int n2 = iLogArray.length;
                while (n < n2) {
                    final ILog log = iLogArray[n];
                    Action action = new Action(){

                        public void run() {
                            if (logOpener instanceof ILogOpener) {
                                ((ILogOpener)logOpener).openLog(log);
                            } else {
                                OpenLogAction.this.openLogView(log.getURI(), server.getName());
                            }
                        }
                    };
                    if (log instanceof INamedLog) {
                        action.setText(((INamedLog)log).getName());
                    } else {
                        action.setText(this.getLogName(log.getURI()));
                    }
                    mn.add((IAction)action);
                    ++n;
                }
            }
        }
    }

    private void openLogView(URI uri, String tabName) {
        try {
            LogView showView = (LogView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.aptana.ide.logging.LogView");
            showView.addTab(uri, StringUtils.format((String)Messages.OpenLogAction_LOG_NAME, (String)tabName), true);
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Part init exception while opening log view", (Throwable)e);
        }
    }

    private String getLogName(URI logURI) {
        int lastSlash;
        String name = "";
        if (logURI != null && (lastSlash = (name = logURI.getPath()).lastIndexOf(47)) + 1 < name.length() - 1) {
            name = name.substring(lastSlash + 1);
        }
        return name;
    }

    public void run() {
        ISelection selection = this.provider.getSelection();
        if (selection instanceof StructuredSelection && !selection.isEmpty()) {
            StructuredSelection ss = (StructuredSelection)selection;
            IServer oo = (IServer)ss.getFirstElement();
            Object logOpener = oo.getAdapter(ILogOpener.class);
            ILog log = oo.getLog();
            if (log == null) {
                FileDialog dlg = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dlg.setText(Messages.OpenLogAction_CHOOSE_LOG_TITLE);
                dlg.setFilterNames(new String[]{""});
                dlg.setFilterExtensions(new String[]{"*.log"});
                String sm = dlg.open();
                if (sm == null) {
                    return;
                }
                File fl = new File(sm);
                String string = fl.getAbsolutePath();
                Configuration config = new Configuration();
                oo.storeConfiguration((IAbstractConfiguration)config);
                config.setStringAttribute("logpath", string);
                try {
                    oo.reconfigure((IAbstractConfiguration)config);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Core exception while setting log location for server", (Throwable)e);
                }
                log = oo.getLog();
            }
            if (logOpener instanceof ILogOpener) {
                ((ILogOpener)logOpener).openLog(log);
            } else {
                this.openLogView(log.getURI(), oo.getName());
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection2 = event.getSelection();
        if (selection2 instanceof StructuredSelection && !selection2.isEmpty()) {
            StructuredSelection ss = (StructuredSelection)selection2;
            IServer ss1 = (IServer)ss.getFirstElement();
            this.setEnabled(ss1.getLog() != null);
            if (ss1.getLog() != null) {
                this.setToolTipText(Messages.OpenLogAction_Title0);
            } else {
                this.setToolTipText(Messages.OpenLogAction_NO_LOG);
            }
        } else {
            this.setToolTipText(Messages.OpenLogAction_NO_LOG);
            this.setEnabled(false);
        }
    }
}

