/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views.actions;

import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerManagerListener;
import com.aptana.ide.server.core.ServerManagerEvent;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.actions.ICanOpenConsole;
import com.aptana.ide.server.ui.views.actions.Messages;
import java.util.WeakHashMap;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.TextConsole;

public class OpenConsole
extends Action
implements ISelectionChangedListener {
    private static final String TITLE = Messages.OpenConsole_TITLE;
    private static WeakHashMap<IServer, IConsole> consoles = new WeakHashMap();
    protected IServer server;

    static {
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(new IConsoleListener(){

            public void consolesAdded(IConsole[] consoles) {
                IConsole[] iConsoleArray = consoles;
                int n = 0;
                int n2 = iConsoleArray.length;
                while (n < n2) {
                    TextConsole cm;
                    IProcess attribute;
                    IConsole c = iConsoleArray[n];
                    if (c instanceof TextConsole && (attribute = (IProcess)(cm = (TextConsole)c).getAttribute(IDebugUIConstants.ATTR_CONSOLE_PROCESS)) != null) {
                        IServer[] iServerArray = ServerCore.getServerManager().getServers();
                        int n3 = 0;
                        int n4 = iServerArray.length;
                        while (n3 < n4) {
                            IProcess[] processes;
                            IServer s = iServerArray[n3];
                            IProcess[] iProcessArray = processes = s.getProcesses();
                            int n5 = 0;
                            int n6 = iProcessArray.length;
                            while (n5 < n6) {
                                IProcess m = iProcessArray[n5];
                                if (m != null && m.equals(attribute)) {
                                    consoles.put(s, cm);
                                }
                                ++n5;
                            }
                            ++n3;
                        }
                    }
                    ++n;
                }
            }

            public void consolesRemoved(IConsole[] consoles) {
            }
        });
        ServerCore.getServerManager().addServerManagerListener(new IServerManagerListener(){

            public void serversChanged(ServerManagerEvent event) {
                IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
                int n = 0;
                int n2 = iConsoleArray.length;
                while (n < n2) {
                    IConsole m = iConsoleArray[n];
                    if (m instanceof TextConsole) {
                        TextConsole cs = (TextConsole)m;
                        IProcess attribute = (IProcess)cs.getAttribute(IDebugUIConstants.ATTR_CONSOLE_PROCESS);
                        IServer[] iServerArray = ServerCore.getServerManager().getServers();
                        int n3 = 0;
                        int n4 = iServerArray.length;
                        while (n3 < n4) {
                            IProcess[] processes;
                            IServer s = iServerArray[n3];
                            IProcess[] iProcessArray = processes = s.getProcesses();
                            int n5 = 0;
                            int n6 = iProcessArray.length;
                            while (n5 < n6) {
                                IProcess ma = iProcessArray[n5];
                                if (ma != null && ma.equals(attribute)) {
                                    consoles.put(s, cs);
                                }
                                ++n5;
                            }
                            ++n3;
                        }
                    }
                    ++n;
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object firstElement;
        StructuredSelection ss;
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.setEnabled(false);
        }
        if (selection instanceof StructuredSelection && (ss = (StructuredSelection)selection).size() == 1 && (firstElement = ss.getFirstElement()) instanceof IServer) {
            this.server = (IServer)firstElement;
            ICanOpenConsole adapter = (ICanOpenConsole)this.server.getAdapter(ICanOpenConsole.class);
            this.setEnabled(adapter != null || consoles.get(this.server) != null);
            return;
        }
        this.setEnabled(false);
    }

    public OpenConsole(ISelectionProvider provider) {
        super(TITLE);
        this.setToolTipText(TITLE);
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/server/console_view.gif"));
    }

    public void run() {
        if (this.server != null) {
            IConsole console2;
            ICanOpenConsole adapter = (ICanOpenConsole)this.server.getAdapter(ICanOpenConsole.class);
            if (adapter != null) {
                adapter.openConsole();
            }
            if ((console2 = consoles.get(this.server)) != null) {
                ConsolePlugin.getDefault().getConsoleManager().showConsoleView(console2);
            }
        }
        super.run();
    }
}

