/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.core.ui.widgets.ToolbarTooltip;
import com.aptana.ide.core.ui.widgets.TreeViewerSorter;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerManagerListener;
import com.aptana.ide.server.core.ServerManagerEvent;
import com.aptana.ide.server.core.impl.Configuration;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.ui.IConfigurationDialog;
import com.aptana.ide.server.ui.ServerDialogPageRegistry;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.Messages;
import com.aptana.ide.server.ui.views.ServerContentProvider;
import com.aptana.ide.server.ui.views.ServerLabelProvider;
import com.aptana.ide.server.ui.views.actions.GenericAddServerAction;
import com.aptana.ide.server.ui.views.actions.ICanEdit;
import com.aptana.ide.server.ui.views.actions.OpenConsole;
import com.aptana.ide.server.ui.views.actions.OpenLogAction;
import com.aptana.ide.server.ui.views.actions.OpenStatisticsAction;
import com.aptana.ide.server.ui.views.actions.RestartServerAction;
import com.aptana.ide.server.ui.views.actions.StartServerAction;
import com.aptana.ide.server.ui.views.actions.StopServerAction;
import com.aptana.ide.server.ui.views.actions.SuspendServerAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.part.ViewPart;

public class GenericServersView
extends ViewPart {
    private static final int MAX_SHOWN_SERVER_NAME = 15;
    public static final String ID = "com.aptana.ide.server.ui.serversView";
    private static final String ELLIPSIS = "...";
    private TreeViewer serverViewer;
    private Action startAction;
    private IContributionItem debugActionItem;
    private IContributionItem profileActionItem;
    private Action debugAction;
    private Action profileAction;
    private Action stopAction;
    private Action restartAction;
    private Action collapseAction;
    private Action expandAction;
    private IServerManagerListener externalServerRegistryListener;
    private SuspendServerAction pauseAction;
    private OpenLogAction openLog;
    private OpenStatisticsAction openStats;
    private static ActionFactory.IWorkbenchAction deleteAction;
    private OpenConsole openConsole;

    public void dispose() {
        ServerCore.getServerManager().removeServerManagerListener(this.externalServerRegistryListener);
        super.dispose();
    }

    public ISelection getSelection() {
        return this.serverViewer.getSelection();
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.createTableViewer(parent);
        this.createPopupMenu();
        this.createToolbar();
        ToolBarManager toolBarManager = (ToolBarManager)this.getViewSite().getActionBars().getToolBarManager();
        final Image smallGlobe = ServerUIPlugin.getImageDescriptor("icons/server/small_globe.png").createImage();
        final Image jaxerImage = ServerUIPlugin.getImageDescriptor("icons/server/jaxer_decorator.gif").createImage();
        ToolBar control = toolBarManager.getControl();
        final ToolbarTooltip toolbarTooltip = new ToolbarTooltip(control, "com.aptana.ide.server.ui.servers_context_view"){

            protected Composite createToolTipContentArea(Event event, Composite parent) {
                Composite sm = new Composite(parent, 0);
                sm.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(10, 10).create());
                FormText ts = new FormText(sm, 0);
                ts.setImage("jaxer", jaxerImage);
                ts.setImage("web", smallGlobe);
                ts.setText(Messages.GenericServersView_LEGEND, true, false);
                ts.setLayoutData((Object)new GridData(320, 75));
                return sm;
            }
        };
        this.serverViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                smallGlobe.dispose();
                jaxerImage.dispose();
                toolbarTooltip.deactivate();
            }
        });
        TreeViewerSorter.bind((TreeViewer)this.serverViewer);
    }

    private void createTableViewer(Composite parent) {
        this.serverViewer = new TreeViewer(parent, 65540);
        this.serverViewer.getTree().setLinesVisible(true);
        this.serverViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                Object server = event.getElement();
                if (server instanceof IServer) {
                    ServerUIPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.server.ui.preferences.COLLAPSE_SERVER." + ((IServer)server).getId(), false);
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                Object server = event.getElement();
                if (server instanceof IServer) {
                    ServerUIPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.server.ui.preferences.COLLAPSE_SERVER." + ((IServer)server).getId(), true);
                }
            }
        });
        PreferenceUtils.registerBackgroundColorPreference((Control)this.serverViewer.getControl(), (String)"com.aptana.ide.core.ui.background.color.serversView");
        PreferenceUtils.registerForegroundColorPreference((Control)this.serverViewer.getControl(), (String)"com.aptana.ide.core.ui.foreground.color.serversView");
        this.createTree();
    }

    private void updateStartActions() {
        IStatus status;
        int i;
        boolean canDebug = false;
        boolean canProfile = false;
        IServer[] servers = ServerManager.getInstance().getServers();
        if (this.debugActionItem != null) {
            i = 0;
            while (i < servers.length) {
                status = servers[i].canStart("debug");
                if (status != null && status.isOK()) {
                    canDebug = true;
                    break;
                }
                ++i;
            }
            this.debugActionItem.setVisible(canDebug);
        }
        if (this.profileActionItem != null) {
            i = 0;
            while (i < servers.length) {
                status = servers[i].canStart("profile");
                if (status != null && status.isOK()) {
                    canProfile = true;
                    break;
                }
                ++i;
            }
            this.profileActionItem.setVisible(canProfile);
        }
    }

    private void createToolbar() {
        final IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator());
        this.startAction = new StartServerAction((ISelectionProvider)this.serverViewer, "run");
        this.debugAction = new StartServerAction((ISelectionProvider)this.serverViewer, "debug");
        this.profileAction = new StartServerAction((ISelectionProvider)this.serverViewer, "profile");
        this.debugActionItem = new ActionContributionItem((IAction)this.debugAction);
        this.profileActionItem = new ActionContributionItem((IAction)this.profileAction);
        this.restartAction = new RestartServerAction((ISelectionProvider)this.serverViewer);
        this.pauseAction = new SuspendServerAction((ISelectionProvider)this.serverViewer);
        this.stopAction = new StopServerAction((ISelectionProvider)this.serverViewer);
        this.openLog = new OpenLogAction((ISelectionProvider)this.serverViewer);
        this.openStats = new OpenStatisticsAction((ISelectionProvider)this.serverViewer);
        this.collapseAction = new Action(){

            public void run() {
                GenericServersView.this.serverViewer.collapseAll();
            }
        };
        this.collapseAction.setImageDescriptor(CoreUIPlugin.getImageDescriptor((String)"icons/collapse.gif"));
        this.collapseAction.setToolTipText("Collapse All");
        this.expandAction = new Action(){

            public void run() {
                GenericServersView.this.serverViewer.expandAll();
            }
        };
        this.expandAction.setImageDescriptor(CoreUIPlugin.getImageDescriptor((String)"icons/expand.gif"));
        this.expandAction.setToolTipText("Expand All");
        toolBarManager.add((IAction)new GenericAddServerAction());
        toolBarManager.add((IAction)this.startAction);
        toolBarManager.add(this.debugActionItem);
        toolBarManager.add(this.profileActionItem);
        toolBarManager.add((IAction)this.restartAction);
        toolBarManager.add((IAction)this.pauseAction);
        toolBarManager.add((IAction)this.stopAction);
        this.serverViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GenericServersView.this.updateToolbar(toolBarManager);
            }
        });
        this.externalServerRegistryListener = new IServerManagerListener(){

            public void serversChanged(final ServerManagerEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (GenericServersView.this.serverViewer.getControl().isDisposed()) {
                            return;
                        }
                        if (event.getKind() == 2) {
                            GenericServersView.this.serverViewer.refresh((Object)event.getServer(), true);
                        } else {
                            GenericServersView.this.serverViewer.refresh(true);
                            if (event.getKind() == 0 && !ServerUIPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.server.ui.preferences.COLLAPSE_SERVER." + event.getServer().getId())) {
                                GenericServersView.this.serverViewer.expandToLevel((Object)event.getServer(), 2);
                            }
                        }
                        GenericServersView.this.updateToolbar(toolBarManager);
                    }
                });
            }
        };
        ServerCore.getServerManager().addServerManagerListener(this.externalServerRegistryListener);
        this.startAction.setEnabled(false);
        this.restartAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        toolBarManager.add((IContributionItem)new Separator());
        this.openConsole = new OpenConsole((ISelectionProvider)this.serverViewer);
        toolBarManager.add((IContributionItem)new Separator("helpEnd"));
        toolBarManager.add((IAction)this.openConsole);
        toolBarManager.add((IAction)this.openLog);
        toolBarManager.add((IAction)this.openStats);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.collapseAction);
        toolBarManager.add((IAction)this.expandAction);
        this.updateStartActions();
        this.updateToolbar(toolBarManager);
    }

    private void updateToolbar(IToolBarManager toolBarManager) {
        IStructuredSelection selection = (IStructuredSelection)this.serverViewer.getSelection();
        this.pauseAction.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.serverViewer, (ISelection)selection));
        this.openLog.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.serverViewer, (ISelection)selection));
        if (selection.isEmpty()) {
            this.startAction.setEnabled(false);
            this.debugAction.setEnabled(false);
            this.profileAction.setEnabled(false);
            this.restartAction.setEnabled(false);
            this.stopAction.setEnabled(false);
        } else {
            IServer server = (IServer)selection.getFirstElement();
            IStatus canStart0 = server.canStart("run");
            this.startAction.setEnabled(canStart0.isOK());
            if (!canStart0.isOK()) {
                this.startAction.setToolTipText(canStart0.getMessage());
            } else {
                this.startAction.setToolTipText(Messages.ServersView_START);
            }
            IStatus canStart = server.canStart("debug");
            this.debugAction.setEnabled(canStart.isOK());
            if (!canStart.isOK()) {
                this.debugAction.setToolTipText(canStart.getMessage());
            } else {
                this.debugAction.setToolTipText(Messages.ServersView_DEBUG);
            }
            IStatus canStart2 = server.canStart("profile");
            this.profileAction.setEnabled(canStart2.isOK());
            if (!canStart2.isOK()) {
                this.profileAction.setToolTipText(canStart2.getMessage());
            } else {
                this.profileAction.setToolTipText(Messages.ServersView_PROFILE);
            }
            this.restartAction.setEnabled(server.canRestart(server.getMode()).getSeverity() == 0);
            this.stopAction.setEnabled(server.canStop().getSeverity() == 0);
            this.openConsole.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.serverViewer, this.serverViewer.getSelection()));
        }
        this.updateStartActions();
        toolBarManager.update(true);
    }

    private void createTree() {
        Tree serverTable = this.serverViewer.getTree();
        serverTable.setHeaderVisible(true);
        serverTable.setLayoutData((Object)new GridData(1808));
        TreeColumn nameColumn = new TreeColumn(serverTable, 16384);
        nameColumn.setText(Messages.ServersView_NAME);
        nameColumn.setWidth(200);
        TreeColumn statusColumn = new TreeColumn(serverTable, 16384);
        statusColumn.setText(Messages.ServersView_STATUS);
        statusColumn.setWidth(100);
        TreeColumn projectColumn = new TreeColumn(serverTable, 16384);
        projectColumn.setText(Messages.ServersView_DESCRIPTION);
        projectColumn.setWidth(400);
        TreeColumn typeColumn = new TreeColumn(serverTable, 16384);
        typeColumn.setText(Messages.ServersView_TYPE);
        typeColumn.setWidth(100);
        TreeColumn hostColumn = new TreeColumn(serverTable, 16384);
        hostColumn.setText(Messages.GenericServersView_HOST);
        hostColumn.setWidth(100);
        TreeColumn portColumn = new TreeColumn(serverTable, 16384);
        portColumn.setText(Messages.GenericServersView_PORT);
        portColumn.setWidth(50);
        this.serverViewer.setLabelProvider((IBaseLabelProvider)new ServerLabelProvider());
        this.serverViewer.setContentProvider((IContentProvider)new ServerContentProvider());
        this.serverViewer.setInput((Object)ServerCore.getServerManager());
        this.serverViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)GenericServersView.this.serverViewer.getSelection();
                IServer server = (IServer)selection.getFirstElement();
                if (server != null) {
                    GenericServersView.this.doEdit(server);
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.serverViewer);
        ServerUIPlugin default1 = ServerUIPlugin.getDefault();
        IPreferenceStore preferenceStore = default1.getPreferenceStore();
        PreferenceUtils.persist((IPreferenceStore)preferenceStore, (Tree)serverTable, (String)"serversView");
    }

    public void setFocus() {
        this.serverViewer.getTree().setFocus();
    }

    private void createPopupMenu() {
        deleteAction = ActionFactory.DELETE.create(this.getViewSite().getWorkbenchWindow());
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new Action(){

            public void run() {
                GenericServersView.this.doDelete();
            }
        });
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object action;
                IContributionItem[] items = GenericServersView.this.getViewSite().getActionBars().getToolBarManager().getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i] instanceof ActionContributionItem) {
                        ActionContributionItem aci = (ActionContributionItem)items[i];
                        action = aci.getAction();
                        if (action == GenericServersView.this.openLog) {
                            boolean enabled = action.isEnabled();
                            action = new OpenLogAction((ISelectionProvider)GenericServersView.this.serverViewer, 1);
                            action.setEnabled(enabled);
                        }
                        if (action.isEnabled() && action.getStyle() != 4) {
                            if (action.getText() == null || action.getText().length() == 0) {
                                action.setText(action.getToolTipText());
                            }
                            manager.add(action);
                        }
                    } else if (items[i] instanceof Separator) {
                        manager.add((IContributionItem)new Separator());
                    }
                    ++i;
                }
                manager.add((IContributionItem)new Separator());
                IStructuredSelection selection = (IStructuredSelection)GenericServersView.this.serverViewer.getSelection();
                final IServer server = (IServer)selection.getFirstElement();
                if (server != null) {
                    deleteAction.setText(StringUtils.format((String)Messages.ServersView_DELETE, (String)this.getShortenName(server)));
                    action = new Action(){

                        public void run() {
                            GenericServersView.this.doEdit(server);
                        }
                    };
                    action.setText(StringUtils.format((String)Messages.ServersView_EDIT, (String)this.getShortenName(server)));
                    deleteAction.setEnabled(server.canDelete().isOK());
                    manager.add((IAction)deleteAction);
                    IStatus canModify = server.canModify();
                    action.setEnabled(server.getServerState() == 4 && (canModify == null || canModify.getCode() == 0));
                    manager.add(action);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }

            private String getShortenName(IServer server) {
                String name = server.getName();
                int length = name.length();
                if (length > 15) {
                    int delta = (length - 15) / 2;
                    int pivot = length / 2;
                    int start = pivot - delta;
                    int end = pivot + delta;
                    String s1 = name.substring(0, start);
                    String s2 = name.substring(end, length);
                    String s = String.valueOf(s1) + GenericServersView.ELLIPSIS + s2;
                    return s;
                }
                return name;
            }
        });
        Menu menu = menuMgr.createContextMenu(this.serverViewer.getControl());
        this.serverViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.serverViewer);
    }

    private void doDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.serverViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IServer server = (IServer)selection.getFirstElement();
        if (!server.canDelete().isOK()) {
            return;
        }
        boolean mayStop = server.getServerState() != 4 && server.getServerState() != 0;
        DeleteServerConfirmDialog dlg = new DeleteServerConfirmDialog(this.getViewSite().getShell(), Messages.ServersView_CONFIRM_DELETE, null, StringUtils.format((String)Messages.ServersView_CONFIRM_DELETE_TEXT, (String)server.getName()), 3, new String[]{Messages.GenericServersView_YES, Messages.GenericServersView_NO}, 0, mayStop);
        int openConfirm = dlg.open();
        if (openConfirm != 0) {
            return;
        }
        boolean doStop = dlg.shouldStop;
        if (doStop) {
            server.stop(true, null, null);
        }
        try {
            ServerCore.getServerManager().removeServer(server);
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)Messages.ServersView_CONFIRM_DELETE, (String)StringUtils.format((String)Messages.ServersView_CONFIRM_DELETE_TEXT, (String)server.getName()));
        }
    }

    private void doEdit(IServer server) {
        IStatus canModify = server.canModify();
        if (canModify != null && canModify.getCode() != 0) {
            MessageDialog.openInformation((Shell)this.serverViewer.getControl().getShell(), (String)Messages.GenericServersView_READONLY_TITLE, (String)Messages.GenericServersView_READONLY_DESCRIPTION);
            return;
        }
        ICanEdit adapter = (ICanEdit)server.getAdapter(ICanEdit.class);
        if (adapter != null) {
            adapter.doEdit();
            return;
        }
        IConfigurationDialog dialog = ServerDialogPageRegistry.getInstance().getDialog(server.getServerType().getId());
        Configuration cf = new Configuration();
        server.storeConfiguration((IAbstractConfiguration)cf);
        dialog.setConfiguration((IAbstractConfiguration)cf);
        dialog.setServer(server);
        dialog.setEdit(true);
        int open = dialog.getDialog().open();
        if (open == 0) {
            IAbstractConfiguration configuration = dialog.getConfiguration();
            configuration.setStringAttribute("type", server.getServerType().getId());
            try {
                server.reconfigure(configuration);
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.GenericServersView_ERROR_WHILE_EDITING_DESCRIPTION, (String)e.getMessage());
                IdeLog.log((Plugin)ServerUIPlugin.getDefault(), (int)4, (String)Messages.GenericServersView_ERROR_WHILE_EDITING_TITLE, (Throwable)e);
            }
        }
        IStructuredSelection selection = (IStructuredSelection)this.serverViewer.getSelection();
        this.pauseAction.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.serverViewer, (ISelection)selection));
    }

    public void select(IServer srv) {
        this.serverViewer.setSelection((ISelection)new StructuredSelection((Object)srv), true);
    }

    private final class DeleteServerConfirmDialog
    extends MessageDialog {
        private Button stopServer;
        private boolean shouldStop;
        private boolean mayStop;

        private DeleteServerConfirmDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, boolean mayStop) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.mayStop = mayStop;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            GridLayout ll = (GridLayout)parent.getLayout();
            ++ll.numColumns;
            ll.makeColumnsEqualWidth = false;
            GridData layoutData = (GridData)parent.getLayoutData();
            layoutData.grabExcessHorizontalSpace = true;
            layoutData.horizontalAlignment = 4;
            this.stopServer = new Button(parent, 32);
            this.stopServer.setText(Messages.GenericServersView_STOP_SERVER_BEFORE_DELETING);
            this.stopServer.setEnabled(this.mayStop);
            this.stopServer.setSelection(this.mayStop);
            this.stopServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteServerConfirmDialog.this.shouldStop = DeleteServerConfirmDialog.this.stopServer.getSelection();
                }
            });
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 16384;
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalIndent = 5;
            this.stopServer.setLayoutData((Object)gridData);
            super.createButtonsForButtonBar(parent);
        }
    }
}

