/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.configuration.ui;

import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.configuration.ui.BasicServerComposite;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.ui.IConfigurationDialog;
import com.aptana.ide.server.ui.views.ServerLabelProvider;
import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ServerDialog
extends TitleAreaDialog
implements IConfigurationDialog {
    private IServer eserver;
    private boolean edit;
    private String title;
    private String description;
    private BasicServerComposite basicServerComposite;
    private IAbstractConfiguration server;
    private BasicServerComposite.StatusUpdater statusUpdater = new BasicServerComposite.StatusUpdater(){
        boolean wasError;

        public void updateStatus(boolean isOk, String message) {
            Button button = ServerDialog.this.getButton(0);
            if (!isOk) {
                this.wasError = true;
                ServerDialog.this.setErrorMessage(message);
                button.setEnabled(false);
            } else {
                if (ServerDialog.this.eserver != null && ServerDialog.this.eserver.getServerState() != 4 && ServerDialog.this.eserver.getServerState() != 0) {
                    ServerDialog.this.setErrorMessage(ServerLabelProvider.SERVER_IS_RUNNING_NO_EDIT);
                    if (button != null) {
                        button.setEnabled(false);
                    }
                    return;
                }
                if (!this.wasError) {
                    return;
                }
                this.wasError = false;
                ServerDialog.this.setErrorMessage(null);
                button.setEnabled(true);
            }
        }
    };

    public IAbstractConfiguration getConfiguration() {
        return this.server;
    }

    public Dialog getDialog() {
        return this;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setConfiguration(IAbstractConfiguration configuration) {
        this.server = configuration;
    }

    public void setEdit(boolean isEdit) {
        this.edit = isEdit;
    }

    public String getServerPath() {
        return this.basicServerComposite.getServerPath();
    }

    public ServerDialog() {
        super(Display.getDefault().getActiveShell());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData cData = new GridData(1808);
        cData.widthHint = 500;
        composite.setLayoutData((Object)cData);
        composite.setFont(parent.getFont());
        this.basicServerComposite = this.createServerComposite(composite, this.statusUpdater);
        this.basicServerComposite.setLayoutData(new GridData(1808));
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        this.setTitle(this.title);
        this.setMessage(this.description);
        this.getShell().setText(this.title);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control createContents = super.createContents(parent);
        return createContents;
    }

    protected void updateServer() {
        this.setServerName(this.basicServerComposite.getServerName());
        this.setServerPath(this.basicServerComposite.getServerPath());
        this.setServerDescription(this.basicServerComposite.getServerDescription());
        String logPath = this.basicServerComposite.getLogPath();
        this.server.setStringAttribute("logpath", logPath);
    }

    private void setServerDescription(String serverDescription) {
        this.server.setStringAttribute("description", serverDescription);
    }

    protected void setServerPath(String serverPath) {
        this.server.setStringAttribute("path", serverPath);
    }

    private void setServerName(String serverName) {
        this.server.setStringAttribute("name", serverName);
    }

    protected BasicServerComposite createServerComposite(Composite composite, BasicServerComposite.StatusUpdater statusUpdater) {
        BasicServerComposite basicServerComposite = new BasicServerComposite(composite, 0, statusUpdater, false);
        return basicServerComposite;
    }

    protected void updateData() {
        this.basicServerComposite.setServerPath(this.server.getStringAttribute("path"));
        this.basicServerComposite.setServerName(this.server.getStringAttribute("name"));
        this.basicServerComposite.setServerDescription(this.server.getStringAttribute("description"));
        this.basicServerComposite.setLogPath(this.server.getStringAttribute("logpath"));
        IServer[] servers = ServerCore.getServerManager().getServers();
        HashSet<String> str = new HashSet<String>();
        IServer[] iServerArray = servers;
        int n = 0;
        int n2 = iServerArray.length;
        while (n < n2) {
            IServer s = iServerArray[n];
            if (!s.getId().equals(this.server.getStringAttribute("id"))) {
                str.add(s.getName());
            }
            ++n;
        }
        this.basicServerComposite.setServerNames(str);
        this.basicServerComposite.validate();
    }

    public void create() {
        super.create();
        this.updateData();
    }

    protected void okPressed() {
        this.updateServer();
        super.okPressed();
    }

    public void setTitle(String title) {
        this.title = title;
        super.setTitle(title);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setServer(IServer server) {
        this.eserver = server;
    }
}

