/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.configuration.ui;

import com.aptana.ide.server.configuration.ui.ApacheServerComposite;
import com.aptana.ide.server.core.IAbstractConfiguration;

public class ApacheServerCompositeUpdater {
    private IAbstractConfiguration configuration;
    private ApacheServerComposite apacheServerComposite;

    public ApacheServerCompositeUpdater(IAbstractConfiguration configuration, ApacheServerComposite apacheServerComposite) {
        this.configuration = configuration;
        this.apacheServerComposite = apacheServerComposite;
    }

    public void updateServer() {
        this.setServerName(this.apacheServerComposite.getServerName());
        this.setServerPath(this.apacheServerComposite.getServerPath());
        this.setServerDescription(this.apacheServerComposite.getServerDescription());
        this.setStopApache(this.apacheServerComposite.getApacheStop());
        this.setStartApache(this.apacheServerComposite.getApacheStart());
        this.setRestartApache(this.apacheServerComposite.getApacheRestart());
        this.setHttpdConf(this.apacheServerComposite.getHttpdConfPath());
        this.setEtcHosts(this.apacheServerComposite.getEtcHostsPath());
        this.getConfiguration().setStringAttribute("HOSTNAME", this.apacheServerComposite.getApacheHost());
    }

    public void updateData() {
        this.apacheServerComposite.setServerPath(this.getConfiguration().getStringAttribute("path"));
        this.apacheServerComposite.setServerName(this.getConfiguration().getStringAttribute("name"));
        this.apacheServerComposite.setServerDescription(this.getConfiguration().getStringAttribute("description"));
        this.apacheServerComposite.setApacheStart(this.getStartApache());
        this.apacheServerComposite.setApacheRestart(this.getRestartApache());
        this.apacheServerComposite.setApacheStop(this.getStopApache());
        this.apacheServerComposite.setHttpConfPath(this.getHttpdConf());
        this.apacheServerComposite.setEtcHostsPath(this.getEtcHosts());
        this.apacheServerComposite.setApacheHost(this.getConfiguration().getStringAttribute("HOSTNAME"));
    }

    public IAbstractConfiguration getConfiguration() {
        return this.configuration;
    }

    private void setEtcHosts(String etcHostsPath) {
        this.getConfiguration().setStringAttribute("ETCHOSTS", etcHostsPath);
    }

    private void setHttpdConf(String httpdConfPath) {
        this.getConfiguration().setStringAttribute("HTTPDCONF", httpdConfPath);
    }

    private void setRestartApache(String apacheRestart) {
        this.getConfiguration().setStringAttribute("restart", apacheRestart);
    }

    private void setStartApache(String apacheStart) {
        this.getConfiguration().setStringAttribute("start", apacheStart);
    }

    private void setStopApache(String apacheStop) {
        this.getConfiguration().setStringAttribute("shutdown", apacheStop);
    }

    private void setServerDescription(String serverDescription) {
        this.getConfiguration().setStringAttribute("description", serverDescription);
    }

    private void setServerPath(String serverPath) {
        this.getConfiguration().setStringAttribute("path", serverPath);
    }

    private void setServerName(String serverName) {
        this.getConfiguration().setStringAttribute("name", serverName);
    }

    private String getEtcHosts() {
        return this.getConfiguration().getStringAttribute("ETCHOSTS");
    }

    private String getHttpdConf() {
        return this.getConfiguration().getStringAttribute("HTTPDCONF");
    }

    private String getStopApache() {
        return this.getConfiguration().getStringAttribute("shutdown");
    }

    private String getRestartApache() {
        return this.getConfiguration().getStringAttribute("restart");
    }

    private String getStartApache() {
        return this.getConfiguration().getStringAttribute("start");
    }
}

