/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preview;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.EclipseUIUtils;
import com.aptana.ide.editor.html.BrowserExtensionLoader;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.preferences.Messages;
import com.aptana.ide.editor.html.preview.PreviewTypeSelectionBlock;
import com.aptana.ide.server.core.IServer;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;

public class HTMLPreviewPropertyPage
extends PropertyPage {
    public static final String CONTEXT_ROOT = "com.aptana.ide.editor.html.preview.CONTEXT_ROOT";
    public static final String HTML_PREVIEW_OVERRIDE = "com.aptana.ide.editor.html.preview.HTML_PREVIEW_OVERRIDE";
    public static final String HTML_PREVIEW_BROWSERS = "com.aptana.ide.editor.html.BROWSER_PREVIEW_PREFERENCE";
    public static final String HTML_PREVIEW_CONFIG = "com.aptana.ide.editor.html.HTMLEDITOR_RUNCONFIG_PREVIEW_PREFERENCE";
    public static final String HTML_PREVIEW_ADDON_BROWSERS = "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_BROWSERS";
    public static final String HTML_PREVIEW_ADDON_NAMES = "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_NAMES";
    public static final String HTML_PREVIEW_ADDON_URLS = "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_URLS";
    public static final String HTML_PREVIEW_ADDON_TYPE = "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_TYPE";
    public static final String HTML_PREVIEW_VALUE = "com.aptana.ide.editor.html.preview.HTML_PREVIEW_VALUE";
    public static final String SERVER_BASED_TYPE = "com.aptana.ide.editor.html.preview.SERVER_BASED_TYPE";
    public static final String APPENDED_SERVER_BASED_TYPE = "com.aptana.ide.editor.html.preview.APPENDED_SERVER_BASED_TYPE";
    public static final String APPENDED_ABSOLUTE_BASED_TYPE = "com.aptana.ide.editor.html.preview.APPENDED_ABSOLUTE_BASED_TYPE";
    public static final String CONFIG_BASED_TYPE = "com.aptana.ide.editor.html.preview.CONFIG_BASED_TYPE";
    public static final String ABSOLUTE_BASED_TYPE = "com.aptana.ide.editor.html.preview.ABSOLUTE_BASED_TYPE";
    public static final String FILE_BASED_TYPE = "com.aptana.ide.editor.html.preview.FILE_BASED_TYPE";
    public static final String HTML_PREVIEW_ADDON_SERVER_ID = "com.aptana.ide.editor.html.preview.HTML_PREVIEW_SERVER_ID";
    public static final String HTML_PREVIEW_ADDON_CONFIG_ID = "com.aptana.ide.editor.html.preview.HTML_PREVIEW_CONFIG_ID";
    public static final String INVALID = "com.aptana.ide.editor.html.preview.INVALID";
    public static final String HTML_PREVIEW_ADDON_USE_INTERNAL_SERVER = "com.aptana.ide.editor.html.preview.HTML_PREVIEW_ADDON_USE_INTERNAL_SERVER";
    public static final String HTML_PREVIEW_LAST_START_URLS = "com.aptana.ide.editor.html.preview.HTML_PREVIEW_LAST_START_URLS";
    public static final String PREFERENCE_DELIMITER = "___PREFERENCE___";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private Button override;
    private CheckboxTableViewer previewViewer;
    private Label description;
    private Composite displayArea;
    private PreviewTypeSelectionBlock block;
    private Group browsers;
    private IResource resource;
    private Label contextRootLabel;
    private Text contextRootText;
    private Button browseContextRoot;

    public HTMLPreviewPropertyPage() {
        this.setDescription("Set the default HTML preview settings for this project");
    }

    protected Control createContents(Composite parent) {
        Composite contextRootComp;
        boolean ov;
        block12: {
            String shouldOverride;
            this.setPreferenceStore(HTMLPlugin.getDefault().getPreferenceStore());
            this.displayArea = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.makeColumnsEqualWidth = false;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 0;
            this.displayArea.setLayout((Layout)layout);
            this.resource = (IResource)this.getElement();
            Composite top = new Composite(this.displayArea, 0);
            GridLayout topLayout = new GridLayout(2, false);
            topLayout.marginHeight = 0;
            topLayout.marginWidth = 0;
            top.setLayout((Layout)topLayout);
            top.setLayoutData((Object)new GridData(4, 4, true, false));
            this.override = new Button(top, 32);
            this.override.setLayoutData((Object)new GridData(4, 4, true, false));
            this.override.setSelection(false);
            this.override.setText("Override workspace settings");
            this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean ov = HTMLPreviewPropertyPage.this.override.getSelection();
                    HTMLPreviewPropertyPage.this.previewViewer.getTable().setEnabled(ov);
                    HTMLPreviewPropertyPage.this.previewViewer.refresh();
                    HTMLPreviewPropertyPage.this.contextRootText.setEnabled(ov);
                    HTMLPreviewPropertyPage.this.browseContextRoot.setEnabled(ov);
                    HTMLPreviewPropertyPage.this.block.setEnabled(ov);
                    HTMLPreviewPropertyPage.this.block.updateControls();
                }
            });
            ov = false;
            try {
                shouldOverride = this.resource.getPersistentProperty(new QualifiedName("", HTML_PREVIEW_OVERRIDE));
            }
            catch (CoreException coreException) {
                shouldOverride = FALSE;
            }
            if (TRUE.equals(shouldOverride)) {
                this.override.setSelection(true);
                ov = true;
            }
            Link goToParent = new Link(top, 0);
            goToParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (HTMLPreviewPropertyPage.this.resource != null && HTMLPreviewPropertyPage.this.resource instanceof IProject) {
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.editor.html.preferences.PreviewPreferencePage", (String[])new String[]{"com.aptana.ide.editor.html.preferences.PreviewPreferencePage"}, null);
                        dialog.open();
                    }
                }
            });
            goToParent.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
            goToParent.setText("<a>Edit workspace settings...</a>");
            this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
            contextRootComp = new Composite(this.displayArea, 0);
            GridLayout crcLayout = new GridLayout(3, false);
            crcLayout.marginHeight = 0;
            crcLayout.marginWidth = 0;
            contextRootComp.setLayout((Layout)crcLayout);
            contextRootComp.setLayoutData((Object)new GridData(4, 4, true, false));
            this.contextRootLabel = new Label(contextRootComp, 0);
            this.contextRootLabel.setText("Project Document Root:");
            this.contextRootText = new Text(contextRootComp, 2052);
            this.contextRootText.setLayoutData((Object)new GridData(4, 4, true, false));
            if (ov) {
                try {
                    String root = this.resource.getPersistentProperty(new QualifiedName("", CONTEXT_ROOT));
                    if (root != null) {
                        this.contextRootText.setText(root);
                        break block12;
                    }
                    this.contextRootText.setText("/");
                }
                catch (CoreException coreException) {}
            } else {
                this.contextRootText.setText("/");
            }
        }
        this.contextRootText.setEditable(false);
        this.browseContextRoot = new Button(contextRootComp, 8);
        this.browseContextRoot.setText("Browse...");
        this.browseContextRoot.setEnabled(ov);
        this.browseContextRoot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object result;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(HTMLPreviewPropertyPage.this.browseContextRoot.getShell(), EclipseUIUtils.createWorkbenchLabelProvider(), HTMLPreviewPropertyPage.this.createContentProvider());
                dialog.setInput((Object)HTMLPreviewPropertyPage.this);
                dialog.setAllowMultiple(false);
                dialog.setMessage("Select the context root for this project:");
                int rc = dialog.open();
                if (rc == 0 && (result = dialog.getFirstResult()) instanceof IContainer) {
                    String root = "/";
                    root = String.valueOf(root) + ((IContainer)result).getProjectRelativePath().toString();
                    HTMLPreviewPropertyPage.this.contextRootText.setText(root);
                }
            }
        });
        String type = FILE_BASED_TYPE;
        String value = null;
        if (ov) {
            try {
                type = this.resource.getPersistentProperty(new QualifiedName("", HTML_PREVIEW_ADDON_TYPE));
                value = this.resource.getPersistentProperty(new QualifiedName("", HTML_PREVIEW_VALUE));
            }
            catch (CoreException coreException) {
                type = FILE_BASED_TYPE;
                value = null;
            }
        } else {
            type = HTMLPlugin.getDefault().getPreferenceStore().getString(HTML_PREVIEW_ADDON_TYPE);
            value = HTMLPlugin.getDefault().getPreferenceStore().getString(HTML_PREVIEW_VALUE);
        }
        this.block = new PreviewTypeSelectionBlock();
        this.block.setSampleProjectName(this.resource.getName());
        this.block.useSampleURL();
        this.block.createStartActionSection(this.displayArea, type, value);
        this.block.setCurrentURLLabel("Sample URL:");
        this.block.setEnabled(ov);
        this.block.updateControls();
        this.block.updateCurrentURL();
        this.description = new Label(this.displayArea, 64);
        this.description.setText(Messages.PreviewPreferencePage_PreviewBrowserDescription);
        this.browsers = new Group(this.displayArea, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.browsers.setLayout((Layout)gridLayout);
        this.browsers.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browsers.setText(Messages.PreviewPreferencePage_PreviewBrowsers);
        Table table = new Table((Composite)this.browsers, 2084);
        table.setFont(parent.getFont());
        this.previewViewer = new CheckboxTableViewer(table);
        table.setEnabled(ov);
        this.previewViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.previewViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                return BrowserExtensionLoader.getBrowserImage(element.toString());
            }

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.previewViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (Platform.getOS().equals("macosx") && HTMLPreviewPropertyPage.this.previewViewer.getChecked((Object)"Firefox") && !HTMLPreviewPropertyPage.this.previewViewer.getChecked((Object)"Safari")) {
                    MessageDialog.openInformation((Shell)HTMLPreviewPropertyPage.this.getShell(), (String)Messages.PreviewPreferencePage_FirefoxPreviewIssueTitle, (String)Messages.PreviewPreferencePage_FirefoxPreviewIssueMessage);
                    HTMLPreviewPropertyPage.this.previewViewer.setChecked((Object)"Firefox", false);
                }
            }
        });
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addPreviewBrowsers();
        this.addCheckedBrowsers();
        return this.displayArea;
    }

    private ITreeContentProvider createContentProvider() {
        ITreeContentProvider provider = new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == HTMLPreviewPropertyPage.this) {
                    return new Object[]{HTMLPreviewPropertyPage.this.resource};
                }
                return this.getChildren(inputElement);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean hasChildren(Object element) {
                if (!(element instanceof IContainer)) return false;
                try {
                    IResource[] resources = ((IContainer)element).members();
                    int i = 0;
                    while (true) {
                        if (i >= resources.length) {
                            return false;
                        }
                        if (resources[i] instanceof IContainer) {
                            return true;
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {
                    return false;
                }
            }

            public Object getParent(Object element) {
                if (element instanceof IProject) {
                    return null;
                }
                if (element instanceof IContainer) {
                    return ((IContainer)element).getParent();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IContainer) {
                    try {
                        IResource[] resources = ((IContainer)parentElement).members();
                        ArrayList<IContainer> folders = new ArrayList<IContainer>();
                        int i = 0;
                        while (i < resources.length) {
                            if (resources[i] instanceof IContainer) {
                                folders.add((IContainer)resources[i]);
                            }
                            ++i;
                        }
                        return folders.toArray();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                }
                return new Object[0];
            }
        };
        return provider;
    }

    private void addPreviewBrowsers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
        IExtension[] extensions = ep.getExtensions();
        ArrayList<String> browserPreviews = new ArrayList<String>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                String browserClass = ce[j].getAttribute("class");
                String name = BrowserExtensionLoader.getBrowserLabel(ce[j]);
                if (browserClass != null && name != null) {
                    browserPreviews.add(name);
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(browserPreviews);
        this.previewViewer.setInput((Object)browserPreviews.toArray());
    }

    private void addCheckedBrowsers() {
        try {
            String all_browsers;
            if (this.override.getSelection()) {
                all_browsers = this.resource.getPersistentProperty(new QualifiedName("", HTML_PREVIEW_BROWSERS));
                if (all_browsers == null) {
                    all_browsers = "";
                }
            } else {
                all_browsers = HTMLPlugin.getDefault().getPreferenceStore().getString(HTML_PREVIEW_BROWSERS);
            }
            String[] browsers = all_browsers.split(",");
            int i = 0;
            while (i < browsers.length) {
                this.previewViewer.setChecked((Object)browsers[i], true);
                ++i;
            }
        }
        catch (CoreException e) {
            IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)"Error loading HTML previews", (Throwable)e);
        }
    }

    public boolean performOk() {
        try {
            boolean ov = this.override.getSelection();
            if (ov) {
                String type = "";
                type = this.block.getServerButton().getSelection() ? (this.block.getServerAppendButton().getSelection() ? APPENDED_SERVER_BASED_TYPE : SERVER_BASED_TYPE) : (this.block.getConfigurationButton().getSelection() ? CONFIG_BASED_TYPE : (this.block.getStartURLButton().getSelection() ? (this.block.getStartURLAppendButton().getSelection() ? APPENDED_ABSOLUTE_BASED_TYPE : ABSOLUTE_BASED_TYPE) : FILE_BASED_TYPE));
                String value = "";
                if (this.block.getServerButton().getSelection()) {
                    Object obj = this.block.getServerText().getData();
                    value = obj != null && obj instanceof IServer ? ((IServer)obj).getId() : this.block.getServerText().getText();
                } else if (this.block.getConfigurationButton().getSelection()) {
                    value = this.block.getConfigurationText().getText();
                } else if (this.block.getStartURLButton().getSelection()) {
                    value = this.block.getStartURLText().getText().trim();
                    this.block.saveURLs();
                }
                this.resource.setPersistentProperty(new QualifiedName("", HTML_PREVIEW_ADDON_TYPE), type);
                this.resource.setPersistentProperty(new QualifiedName("", HTML_PREVIEW_VALUE), value);
                this.resource.setPersistentProperty(new QualifiedName("", HTML_PREVIEW_OVERRIDE), TRUE);
                this.resource.setPersistentProperty(new QualifiedName("", CONTEXT_ROOT), this.contextRootText.getText());
                ArrayList<String> al = new ArrayList<String>();
                Object[] elements = this.previewViewer.getCheckedElements();
                int i = 0;
                while (i < elements.length) {
                    al.add(elements[i].toString());
                    ++i;
                }
                this.resource.setPersistentProperty(new QualifiedName("", HTML_PREVIEW_BROWSERS), StringUtils.join((String)",", (String[])al.toArray(new String[0])));
            } else {
                this.resource.setPersistentProperty(new QualifiedName("", HTML_PREVIEW_OVERRIDE), FALSE);
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        String prefs = this.getPreferenceStore().getString(HTML_PREVIEW_BROWSERS);
        this.previewViewer.setCheckedElements((Object[])prefs.split(","));
        String type = HTMLPlugin.getDefault().getPreferenceStore().getString(HTML_PREVIEW_ADDON_TYPE);
        String value = HTMLPlugin.getDefault().getPreferenceStore().getString(HTML_PREVIEW_VALUE);
        this.block.setType(type);
        this.block.setValue(value);
        this.override.setSelection(false);
        this.previewViewer.getTable().setEnabled(false);
        this.contextRootText.setEnabled(false);
        this.browseContextRoot.setEnabled(false);
        this.block.updateControls();
    }
}

