/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.parsing.HTMLUtils;
import com.aptana.ide.editors.unified.AbstractPairFinder;
import com.aptana.ide.editors.unified.IPairFinder;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;

public class HTMLPairFinder
extends AbstractPairFinder
implements IPairFinder {
    private Lexeme findLexeme(LexemeList lexemeList, int startIndex, int type, int direction) {
        Lexeme result = null;
        while (startIndex >= 0 && startIndex < lexemeList.size()) {
            Lexeme candidate = lexemeList.get(startIndex);
            if (candidate.typeIndex == type && candidate.getLanguage().equals("text/html")) {
                result = candidate;
                break;
            }
            startIndex += direction;
        }
        return result;
    }

    public PairMatch findPairMatch(int offset, IParseState parseState, Lexeme cursorLexeme, int loopCount) {
        LexemeList lexemeList = parseState.getLexemeList();
        PairMatch result = null;
        while (loopCount > 0 && cursorLexeme != null && cursorLexeme.getLanguage().equals("text/html")) {
            int index = lexemeList.getLexemeIndex(cursorLexeme);
            Lexeme matchingLexeme = null;
            switch (cursorLexeme.typeIndex) {
                case 24: {
                    Lexeme candidate = this.findLexeme(lexemeList, index + 1, 23, 1);
                    if (candidate == null) break;
                    matchingLexeme = candidate;
                    break;
                }
                case 23: {
                    Lexeme candidate = this.findLexeme(lexemeList, index - 1, 24, -1);
                    if (candidate == null) break;
                    matchingLexeme = candidate;
                    break;
                }
                case 25: {
                    Lexeme candidate = this.findLexeme(lexemeList, index + 1, 30, 1);
                    if (candidate == null) break;
                    matchingLexeme = candidate;
                    break;
                }
                case 42: {
                    Lexeme candidate = this.findLexeme(lexemeList, index + 1, 37, 1);
                    if (candidate == null) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset();
                    result.beginEnd = cursorLexeme.getEndingOffset();
                    result.endStart = candidate.getStartingOffset();
                    result.endEnd = candidate.getEndingOffset();
                    loopCount = 0;
                    break;
                }
                case 37: {
                    Lexeme candidate = this.findLexeme(lexemeList, index - 1, 42, -1);
                    if (candidate == null) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset();
                    result.beginEnd = result.beginStart + 2;
                    result.endStart = candidate.getStartingOffset();
                    result.endEnd = candidate.getEndingOffset();
                    loopCount = 0;
                    break;
                }
                case 52: {
                    int encodingLength = "encoding=".length();
                    if (offset - cursorLexeme.getStartingOffset() < encodingLength) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset() + encodingLength;
                    result.beginEnd = result.beginStart + 1;
                    result.endStart = cursorLexeme.getEndingOffset() - 1;
                    result.endEnd = result.endStart + 1;
                    loopCount = 0;
                    break;
                }
                case 54: {
                    int versionLength = "version=".length();
                    if (offset - cursorLexeme.getStartingOffset() < versionLength) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset() + versionLength;
                    result.beginEnd = result.beginStart + 1;
                    result.endStart = cursorLexeme.getEndingOffset() - 1;
                    result.endEnd = result.endStart + 1;
                    loopCount = 0;
                    break;
                }
                case 2: {
                    int openCommentLength = "<!--".length();
                    int closeCommentLength = "-->".length();
                    int start = cursorLexeme.getStartingOffset();
                    int end = cursorLexeme.getEndingOffset();
                    if (offset - start > openCommentLength && end - offset > closeCommentLength) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset();
                    result.beginEnd = result.beginStart + 4;
                    result.endStart = cursorLexeme.getEndingOffset() - 3;
                    result.endEnd = result.endStart + 3;
                    loopCount = 0;
                    break;
                }
                case 41: {
                    result = this.processStartTag(offset, parseState, cursorLexeme, lexemeList, result);
                    break;
                }
                case 27: {
                    result = this.processEndTag(offset, parseState, cursorLexeme, lexemeList, result, index);
                    break;
                }
                case 30: {
                    Lexeme candidate = this.findFirstLexeme(lexemeList, index - 1, 41, 27, 25, -1);
                    if (candidate == null || candidate.typeIndex != 25) break;
                    matchingLexeme = candidate;
                    break;
                }
                case 44: {
                    String text;
                    if (cursorLexeme.getCategoryIndex() != 0 && cursorLexeme.getCategoryIndex() != 0 && (offset - 1 == cursorLexeme.getStartingOffset() || offset == cursorLexeme.getStartingOffset() || offset == cursorLexeme.getEndingOffset() || offset == cursorLexeme.getEndingOffset() - 1) && (text = cursorLexeme.getText()) != null && text.length() > 1) {
                        char first = text.charAt(0);
                        char last = text.charAt(text.length() - 1);
                        if ((first == '\"' || first == '\'') && first == last) {
                            result = new PairMatch();
                            result.beginStart = cursorLexeme.getStartingOffset();
                            result.beginEnd = result.beginStart + 1;
                            result.endStart = cursorLexeme.getEndingOffset() - 1;
                            result.endEnd = result.endStart + 1;
                        }
                    }
                    loopCount = 0;
                    break;
                }
                case 56: {
                    if (index + 1 < lexemeList.size() && lexemeList.get(index + 1).getToken().getLanguage().equals("text/css")) {
                        result = this.findEndingQuote(index, parseState, cursorLexeme, lexemeList);
                        break;
                    }
                    if (index - 1 <= 0 || !lexemeList.get(index - 1).getToken().getLanguage().equals("text/css")) break;
                    result = this.findStartingQuote(index, parseState, cursorLexeme, lexemeList);
                    break;
                }
            }
            if (matchingLexeme != null) {
                result = new PairMatch();
                result.beginStart = cursorLexeme.getStartingOffset();
                result.beginEnd = cursorLexeme.getEndingOffset();
                result.endStart = matchingLexeme.getStartingOffset();
                result.endEnd = matchingLexeme.getEndingOffset();
                loopCount = 0;
                continue;
            }
            if (--loopCount > 0 && offset > 0) {
                cursorLexeme = lexemeList.getLexemeFromOffset(offset - 1);
                continue;
            }
            loopCount = 0;
        }
        return result;
    }

    private PairMatch processStartTag(int offset, IParseState parseState, Lexeme cursorLexeme, LexemeList lexemeList, PairMatch result) {
        Lexeme closeLexeme;
        int closeIndex;
        IParseNode root = parseState.getParseResults();
        IParseNode node = root.getNodeAtOffset(offset);
        if (node != null && (closeIndex = lexemeList.getLexemeIndex(closeLexeme = node.getEndingLexeme())) > 0) {
            Lexeme candidate = lexemeList.get(closeIndex - 1);
            if (candidate.typeIndex == 27 && HTMLUtils.stripTagEndings(candidate.getText()).equalsIgnoreCase(HTMLUtils.stripTagEndings(cursorLexeme.getText()))) {
                result = new PairMatch();
                result.beginStart = cursorLexeme.getStartingOffset();
                result.beginEnd = cursorLexeme.getEndingOffset();
                result.endStart = candidate.getStartingOffset();
                result.endEnd = closeLexeme.getEndingOffset();
            }
        }
        return result;
    }

    private PairMatch processEndTag(int offset, IParseState parseState, Lexeme cursorLexeme, LexemeList lexemeList, PairMatch result, int index) {
        Lexeme openLexeme;
        int openIndex;
        IParseNode root = parseState.getParseResults();
        IParseNode node = root.getNodeAtOffset(offset);
        if (node != null && (openIndex = lexemeList.getLexemeIndex(openLexeme = node.getStartingLexeme())) >= 0) {
            Lexeme candidate = lexemeList.get(openIndex);
            if (candidate.typeIndex == 41 && HTMLUtils.stripTagEndings(candidate.getText()).equalsIgnoreCase(HTMLUtils.stripTagEndings(cursorLexeme.getText()))) {
                result = new PairMatch();
                result.beginStart = candidate.getStartingOffset();
                result.beginEnd = candidate.getEndingOffset();
                result.endStart = cursorLexeme.getStartingOffset();
                if (index + 1 < lexemeList.size()) {
                    Lexeme bracket = lexemeList.get(index + 1);
                    result.endEnd = bracket.typeIndex == 30 ? bracket.getEndingOffset() : cursorLexeme.getEndingOffset();
                } else {
                    result.endEnd = cursorLexeme.getEndingOffset();
                }
            }
        }
        return result;
    }

    private Lexeme findFirstLexeme(LexemeList lexemeList, int startIndex, int type1, int type2, int type3, int direction) {
        Lexeme result = null;
        while (startIndex >= 0 && startIndex < lexemeList.size()) {
            Lexeme candidate = lexemeList.get(startIndex);
            if ((candidate.typeIndex == type1 || candidate.typeIndex == type2 || candidate.typeIndex == type3) && candidate.getLanguage().equals("text/html")) {
                result = candidate;
                break;
            }
            startIndex += direction;
        }
        return result;
    }

    public Color getPairFinderColor() {
        return UnifiedColorManager.getInstance().getColor(PreferenceConverter.getColor((IPreferenceStore)HTMLPlugin.getDefault().getPreferenceStore(), (String)"com.aptana.ide.editors.PAIR_MATCHING_COLOR"));
    }

    private String getDisplayPreference() {
        return HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editors.SHOW_PAIR_MATCHES");
    }

    public boolean displayOnlyMatch() {
        return this.getDisplayPreference().equals("MATCHING");
    }

    public boolean doNotDisplay() {
        return this.getDisplayPreference().equals("NONE");
    }

    private PairMatch findEndingQuote(int index, IParseState parseState, Lexeme cursorLexeme, LexemeList lexemeList) {
        Lexeme endingLexeme = null;
        int i = index + 1;
        while (i < lexemeList.size()) {
            Lexeme currentLexeme = lexemeList.get(i);
            if (!currentLexeme.getToken().getLanguage().equals("text/css")) {
                if (currentLexeme.typeIndex != 56) break;
                endingLexeme = currentLexeme;
                break;
            }
            ++i;
        }
        if (endingLexeme == null) {
            return null;
        }
        PairMatch match = new PairMatch();
        match.beginStart = cursorLexeme.getStartingOffset();
        match.beginEnd = cursorLexeme.getEndingOffset();
        match.endStart = endingLexeme.getStartingOffset();
        match.endEnd = endingLexeme.getEndingOffset();
        return match;
    }

    private PairMatch findStartingQuote(int index, IParseState parseState, Lexeme cursorLexeme, LexemeList lexemeList) {
        Lexeme endingLexeme = null;
        int i = index - 1;
        while (i >= 0) {
            Lexeme currentLexeme = lexemeList.get(i);
            if (!currentLexeme.getToken().getLanguage().equals("text/css")) {
                if (currentLexeme.typeIndex != 56) break;
                endingLexeme = currentLexeme;
                break;
            }
            --i;
        }
        if (endingLexeme == null) {
            return null;
        }
        PairMatch match = new PairMatch();
        match.beginStart = cursorLexeme.getStartingOffset();
        match.beginEnd = cursorLexeme.getEndingOffset();
        match.endStart = endingLexeme.getStartingOffset();
        match.endEnd = endingLexeme.getEndingOffset();
        return match;
    }
}

