/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.editors.ISaveAsEvent;
import com.aptana.ide.core.ui.editors.ISaveEvent;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.HTMLSourceEditor;
import com.aptana.ide.editor.html.IHTMLEditorPart;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editor.html.MultiPageHTMLEditor;
import com.aptana.ide.editor.html.SplitPageHTMLEditor;
import com.aptana.ide.editors.toolbar.ToolbarWidget;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileServiceChangeListener;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.editors.unified.context.IContextAwareness;
import com.aptana.ide.ui.editors.EditorMessages;
import com.aptana.ide.views.outline.UnifiedOutlinePage;
import com.aptana.ide.views.outline.UnifiedQuickOutlinePage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiEditor;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.TextEditorAction;

public class HTMLEditor
extends EditorPart
implements ITextEditor,
ITextEditorExtension,
IUnifiedEditor {
    public static final String ID = "com.aptana.ide.editors.HTMLEditor";
    private Composite displayArea;
    private ToolbarWidget toolbar;
    protected EditorPart editor;
    protected HTMLSourceEditor sourceEditor;
    private HTMLSourceEditor ctorSourceEditor;
    protected File prevTempFile = null;
    private IPropertyListener _propertyListener;
    private IMenuListener _menuListener;
    private boolean isDisposing = false;
    private ISaveAsEvent _saveAsListener;
    public static final String TAB_MODE = "tab";
    public static final String HORIZONTAL_MODE = "horizontal";
    public static final String VERTICAL_MODE = "vertical";
    public static final String SOURCE_MODE = "source";

    public HTMLEditor() {
        IPreferenceStore store = this.getPreferenceStore();
        String editorMode = store.getString("com.aptana.ide.editor.html.HTML_EDITOR_VIEW_CHOICE");
        if (editorMode.equals(HORIZONTAL_MODE)) {
            this.ctorSourceEditor = this.createSourceEditor();
            this.editor = new SplitPageHTMLEditor(this, true, this.ctorSourceEditor);
        } else if (editorMode.equals(VERTICAL_MODE)) {
            this.ctorSourceEditor = this.createSourceEditor();
            this.editor = new SplitPageHTMLEditor(this, false, this.ctorSourceEditor);
        } else if (editorMode.equals(TAB_MODE)) {
            this.ctorSourceEditor = this.createSourceEditor();
            this.editor = new MultiPageHTMLEditor(this, this.ctorSourceEditor);
        } else {
            this.editor = this.createSourceEditor();
            this._propertyListener = new IPropertyListener(){

                public void propertyChanged(Object source, int propertyId) {
                    HTMLEditor.this.firePropertyChange(propertyId);
                }
            };
            this.editor.addPropertyListener(this._propertyListener);
        }
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        if (this.sourceEditor == null) {
            return;
        }
        this._menuListener = listener;
        this.sourceEditor.addRulerContextMenuListener(listener);
    }

    public void close(boolean save) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.close(save);
    }

    protected HTMLSourceEditor createSourceEditor() {
        this.sourceEditor = new HTMLSourceEditor(){

            protected void createActions() {
                super.createActions();
                final IAction previousCut = HTMLEditor.this.sourceEditor.getAction(ITextEditorActionConstants.CUT);
                TextEditorAction cut = new TextEditorAction(EditorMessages.getBundleForConstructedKeys(), "Editor.Cut.", (ITextEditor)this, 3){

                    public void run() {
                        if ((this).HTMLEditor.this.editor instanceof MultiPageHTMLEditor) {
                            MultiPageHTMLEditor multi = (MultiPageHTMLEditor)(this).HTMLEditor.this.editor;
                            if (!multi.run(this.getActionDefinitionId()) && previousCut != null) {
                                previousCut.run();
                            }
                        } else if (previousCut != null) {
                            previousCut.run();
                        }
                    }
                };
                cut.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
                cut.setActionDefinitionId("org.eclipse.ui.edit.cut");
                this.setAction(ITextEditorActionConstants.CUT, (IAction)cut);
                final IAction previousCopy = HTMLEditor.this.sourceEditor.getAction(ITextEditorActionConstants.COPY);
                TextEditorAction copy = new TextEditorAction(EditorMessages.getBundleForConstructedKeys(), "Editor.Copy.", (ITextEditor)this, 4){

                    public void run() {
                        if ((this).HTMLEditor.this.editor instanceof MultiPageHTMLEditor) {
                            MultiPageHTMLEditor multi = (MultiPageHTMLEditor)(this).HTMLEditor.this.editor;
                            if (!multi.run(this.getActionDefinitionId()) && previousCopy != null) {
                                previousCopy.run();
                            }
                        } else if (previousCopy != null) {
                            previousCopy.run();
                        }
                    }
                };
                copy.setHelpContextId(IAbstractTextEditorHelpContextIds.COPY_ACTION);
                copy.setActionDefinitionId("org.eclipse.ui.edit.copy");
                this.setAction(ITextEditorActionConstants.COPY, (IAction)copy);
                final IAction previousPaste = HTMLEditor.this.sourceEditor.getAction(ITextEditorActionConstants.PASTE);
                TextEditorAction paste = new TextEditorAction(EditorMessages.getBundleForConstructedKeys(), "Editor.Paste.", (ITextEditor)this, 5){

                    public void run() {
                        if ((this).HTMLEditor.this.editor instanceof MultiPageHTMLEditor) {
                            MultiPageHTMLEditor multi = (MultiPageHTMLEditor)(this).HTMLEditor.this.editor;
                            if (!multi.run(this.getActionDefinitionId()) && previousPaste != null) {
                                previousPaste.run();
                            }
                        } else if (previousPaste != null) {
                            previousPaste.run();
                        }
                    }
                };
                paste.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
                paste.setActionDefinitionId("org.eclipse.ui.edit.paste");
                this.setAction(ITextEditorActionConstants.PASTE, (IAction)paste);
            }
        };
        return this.sourceEditor;
    }

    public void setToolbarVisible(boolean visible) {
        if (this.toolbar != null && visible != this.toolbar.isVisible()) {
            this.toolbar.setVisible(visible);
            this.displayArea.setRedraw(false);
            this.displayArea.layout(true, true);
            this.displayArea.setRedraw(true);
        }
    }

    public void createPartControl(Composite parent) {
        this.getSite().setSelectionProvider(this.sourceEditor.getSelectionProvider());
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        IPreferenceStore store = this.getPreferenceStore();
        boolean show = store.getBoolean("com.aptana.ide.editor.html.SHOW_HTML_TOOLBAR");
        if (show) {
            String[] languages = new String[]{"text/html", "text/javascript", "text/css"};
            String[] labels = new String[]{" html ", "  js  ", " css  "};
            this.toolbar = new ToolbarWidget(languages, labels, this.getPreferenceStore(), "com.aptana.ide.editor.html.LINK_CURSOR_WITH_HTML_TOOLBAR_TAB", (IUnifiedEditor)this.sourceEditor);
            this.toolbar.createControl(this.displayArea);
        }
        Composite editorArea = new Composite(this.displayArea, 0);
        editorArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout eaLayout = new GridLayout(1, true);
        eaLayout.marginHeight = 0;
        eaLayout.marginWidth = 0;
        editorArea.setLayout((Layout)new FillLayout());
        this.editor.createPartControl(editorArea);
        if (this.toolbar != null) {
            this.toolbar.hookCursorListener();
        }
    }

    public void dispose() {
        if (this.isDisposing) {
            return;
        }
        this.isDisposing = true;
        IAction undo = this.getAction(ITextEditorActionConstants.UNDO);
        IAction redo = this.getAction(ITextEditorActionConstants.REDO);
        if (this._propertyListener != null) {
            this.editor.removePropertyListener(this._propertyListener);
            this._propertyListener = null;
        }
        if (this._menuListener != null) {
            this.sourceEditor.removeRulerContextMenuListener(this._menuListener);
            this._menuListener = null;
        }
        if (this._saveAsListener != null) {
            this.sourceEditor.removeSaveAsListener(this._saveAsListener);
            this._saveAsListener = null;
        }
        this.setPartName(null);
        super.dispose();
        if (this.ctorSourceEditor != null) {
            this.ctorSourceEditor.dispose();
        }
        if (this.editor != null) {
            this.editor.dispose();
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.dispose();
        }
        if (this.toolbar != null) {
            this.toolbar.dispose();
        }
        if (undo instanceof OperationHistoryActionHandler) {
            ((OperationHistoryActionHandler)undo).dispose();
        }
        if (redo instanceof OperationHistoryActionHandler) {
            ((OperationHistoryActionHandler)redo).dispose();
        }
    }

    public void doRevertToSaved() {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.doRevertToSaved();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.editor == null) {
            return;
        }
        this.editor.doSave(monitor);
    }

    public void doSaveAs() {
        if (this.editor == null) {
            return;
        }
        this.editor.doSaveAs();
    }

    protected void drawGradient(IEditorPart innerEditor, MultiEditor.Gradient g) {
    }

    public void firePropertyChange2(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    public IAction getAction(String actionId) {
        if (this.sourceEditor == null) {
            return null;
        }
        return this.sourceEditor.getAction(actionId);
    }

    public Object getAdapter(Class adapter) {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getAdapter(adapter);
    }

    public String getContentDescription() {
        if (this.editor == null) {
            return "";
        }
        return this.editor.getContentDescription();
    }

    public IDocumentProvider getDocumentProvider() {
        if (this.sourceEditor == null) {
            return null;
        }
        return this.sourceEditor.getDocumentProvider();
    }

    public IEditorInput getEditorInput() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getEditorInput();
    }

    public IEditorSite getEditorSite() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getEditorSite();
    }

    public IRegion getHighlightRange() {
        if (this.sourceEditor == null) {
            return null;
        }
        return this.sourceEditor.getHighlightRange();
    }

    public HTMLSourceEditor getSourceEditor() {
        if (this.editor == null) {
            return null;
        }
        if (this.editor instanceof HTMLSourceEditor) {
            return (HTMLSourceEditor)this.editor;
        }
        return ((IHTMLEditorPart)this.editor).getSourceEditor();
    }

    public String getPartName() {
        if (this.editor == null) {
            return "";
        }
        return this.editor.getPartName();
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.sourceEditor == null) {
            return null;
        }
        return this.sourceEditor.getSelectionProvider();
    }

    public IWorkbenchPartSite getSite() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getSite();
    }

    public String getTitle() {
        if (this.editor == null) {
            return "";
        }
        return this.editor.getTitle();
    }

    public Image getTitleImage() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getTitleImage();
    }

    public String getTitleToolTip() {
        if (this.editor == null) {
            return "";
        }
        return this.editor.getTitleToolTip();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.editor == null) {
            return;
        }
        this.editor.init(site, input);
    }

    public boolean isDirty() {
        if (this.editor == null) {
            return false;
        }
        return this.editor.isDirty();
    }

    public boolean isEditable() {
        if (this.sourceEditor == null) {
            return false;
        }
        return this.sourceEditor.isEditable();
    }

    public boolean isEditorInputReadOnly() {
        if (this.sourceEditor == null) {
            return false;
        }
        return this.sourceEditor.isEditorInputReadOnly();
    }

    public boolean isSaveAsAllowed() {
        if (this.editor == null) {
            return false;
        }
        return this.editor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        if (this.editor == null) {
            return false;
        }
        return this.editor.isSaveOnCloseNeeded();
    }

    public void removeActionActivationCode(String actionId) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.removeActionActivationCode(actionId);
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.removeRulerContextMenuListener(listener);
    }

    public void resetHighlightRange() {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.resetHighlightRange();
    }

    public void selectAndReveal(int offset, int length) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.selectAndReveal(offset, length);
    }

    public void setAction(String actionID, IAction action) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.setAction(actionID, action);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
    }

    public void setFocus() {
        if (this.editor == null) {
            return;
        }
        this.editor.setFocus();
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.setHighlightRange(offset, length, moveCursor);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if (this.editor == null) {
            return;
        }
        this.editor.setInitializationData(config, propertyName, data);
    }

    public void setOffset(int offset) {
        if (this.editor == null) {
            return;
        }
        if (this.editor instanceof SplitPageHTMLEditor) {
            ((SplitPageHTMLEditor)this.editor).setOffset(offset);
        } else if (this.editor instanceof MultiPageHTMLEditor) {
            ((MultiPageHTMLEditor)this.editor).setOffset(offset);
        } else if (this.editor instanceof HTMLSourceEditor) {
            ((HTMLSourceEditor)this.editor).selectAndReveal(offset, 0);
        }
    }

    public void setStatusField(IStatusField field, String category) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.setStatusField(field, category);
    }

    public void showBusy(boolean busy) {
        if (this.editor == null) {
            return;
        }
        this.editor.showBusy(busy);
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.showHighlightRangeOnly(showHighlightRangeOnly);
    }

    public boolean showsHighlightRangeOnly() {
        if (this.sourceEditor == null) {
            return false;
        }
        return this.sourceEditor.showsHighlightRangeOnly();
    }

    public void updateSource() {
    }

    public void updateEdit() {
        if (this.editor == null) {
            return;
        }
        if (!(this.editor instanceof IHTMLEditorPart)) {
            return;
        }
        if (!((IHTMLEditorPart)this.editor).isFileEditorInput()) {
            return;
        }
        IHTMLEditorPart editor = (IHTMLEditorPart)this.editor;
        IEditorInput input = this.editor.getEditorInput();
        String html = editor.getSourceEditor().getDocumentProvider().getDocument((Object)input).get();
        String js = "fill(\"" + html.replaceAll("\r", "&return;").replaceAll("\n", "&newline;").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&#39;") + "\");";
        editor.getBrowser2().execute(js);
    }

    public void updatePreview() {
        if (this.editor == null) {
            return;
        }
        if (!(this.editor instanceof IHTMLEditorPart)) {
            return;
        }
        try {
            if (!((IHTMLEditorPart)this.editor).isFileEditorInput()) {
                return;
            }
            IHTMLEditorPart editor = (IHTMLEditorPart)this.editor;
            IEditorInput input = this.editor.getEditorInput();
            String urlPrefix = null;
            if (input instanceof FileEditorInput) {
                urlPrefix = this.getExternalPreviewUrl(input);
            }
            if (urlPrefix != null && !"".equals(urlPrefix)) {
                FileEditorInput fei = (FileEditorInput)input;
                IFile file = fei.getFile();
                String tmpUrl = CoreUIUtils.joinURI((String)urlPrefix, (String)file.getProjectRelativePath().toPortableString());
                editor.setBrowserURL(tmpUrl);
            } else if (HTMLPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editor.html.USE_TEMP_FILES_FOR_PREVIEW")) {
                IDocumentProvider docProvider = editor.getSourceEditor().getDocumentProvider();
                String html = docProvider.getDocument((Object)input).get();
                String charset = null;
                if (input instanceof IFileEditorInput) {
                    charset = ((IFileEditorInput)input).getFile().getCharset();
                } else if (docProvider instanceof TextFileDocumentProvider && (charset = ((TextFileDocumentProvider)docProvider).getEncoding((Object)input)) == null) {
                    charset = ((TextFileDocumentProvider)docProvider).getDefaultEncoding();
                }
                File tmpFile = this.writeTemporaryPreviewFile(editor, input, html, charset);
                String tmpUrl = CoreUIUtils.getURI((File)tmpFile, (boolean)false);
                if (this.prevTempFile != null && this.prevTempFile.equals(tmpFile)) {
                    editor.setBrowserURL(tmpUrl);
                } else {
                    if (this.prevTempFile != null) {
                        this.prevTempFile.delete();
                    }
                    this.prevTempFile = tmpFile;
                    editor.setBrowserURL(tmpUrl);
                }
            } else if (input instanceof IFileEditorInput) {
                IFileEditorInput fei = (IFileEditorInput)input;
                IFile file = fei.getFile();
                editor.setBrowserURL(CoreUIUtils.getURI((File)file.getLocation().toFile(), (boolean)false));
            } else if (input instanceof IPathEditorInput) {
                IPathEditorInput fei = (IPathEditorInput)input;
                File file = fei.getPath().toFile();
                editor.setBrowserURL(CoreUIUtils.getURI((File)file, (boolean)false));
            } else {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.HTMLEditor_UnableToUpdatePreview);
            }
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.HTMLEditor_UnableToUpdatePreview, (Throwable)ex);
        }
    }

    private File writeTemporaryPreviewFile(IHTMLEditorPart editor, IEditorInput input, String html, String charset) throws CoreException, FileNotFoundException, UnsupportedEncodingException {
        File tmpFile = editor.getSourceEditor().getTempFile();
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        FileOutputStream out = new FileOutputStream(tmpFile);
        PrintWriter pw = null;
        pw = charset != null ? new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, charset), true) : new PrintWriter((Writer)new OutputStreamWriter(out), true);
        pw.write(html);
        pw.close();
        try {
            out.close();
        }
        catch (IOException iOException) {}
        tmpFile.deleteOnExit();
        FileUtils.setHidden((File)tmpFile);
        return tmpFile;
    }

    private String getExternalPreviewUrl(IEditorInput input) throws CoreException {
        String urlPrefix = null;
        FileEditorInput fei = (FileEditorInput)input;
        IFile file = fei.getFile();
        IProject project = file.getProject();
        urlPrefix = project.getPersistentProperty(new QualifiedName("", "PREVIEW_PREFIX"));
        return urlPrefix;
    }

    public EditorFileContext getFileContext() {
        if (this.sourceEditor == null) {
            return null;
        }
        return this.sourceEditor.getFileContext();
    }

    public ISourceViewer getViewer() {
        if (this.sourceEditor == null) {
            return null;
        }
        return this.sourceEditor.getViewer();
    }

    public SourceViewerConfiguration getConfiguration() {
        if (this.getSourceEditor() == null) {
            return null;
        }
        return this.getSourceEditor().getConfiguration();
    }

    public IContextAwareness getContextAwareness() {
        if (this.sourceEditor == null) {
            return null;
        }
        return this.sourceEditor.getContextAwareness();
    }

    public int getCaretOffset() {
        ISourceViewer sv = this.getViewer();
        if (sv != null) {
            return sv.getTextWidget().getCaretOffset();
        }
        return -1;
    }

    public IEditorPart getEditor() {
        return this.sourceEditor;
    }

    public void showWhitespace(boolean state) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.showWhitespace(state);
    }

    public void addSaveAsListener(ISaveAsEvent listener) {
        if (this.sourceEditor == null) {
            return;
        }
        this._saveAsListener = listener;
        this.sourceEditor.addSaveAsListener(listener);
    }

    public void removeSaveAsListener(ISaveAsEvent listener) {
        if (this.sourceEditor == null) {
            return;
        }
        this.sourceEditor.removeSaveAsListener(listener);
    }

    public UnifiedOutlinePage getOutlinePage() {
        return this.sourceEditor.getOutlinePage();
    }

    public UnifiedQuickOutlinePage createQuickOutlinePage() {
        return this.sourceEditor.createQuickOutlinePage();
    }

    public PairMatch getPairMatch(int offset) {
        return this.sourceEditor.getPairMatch(offset);
    }

    public String getParentDirectoryHint() {
        return this.sourceEditor.getParentDirectoryHint();
    }

    public void setParentDirectoryHint(String hint) {
        this.sourceEditor.setParentDirectoryHint(hint);
    }

    public void addSaveListener(ISaveEvent listener) {
        this.sourceEditor.addSaveListener(listener);
    }

    public void removeSaveListener(ISaveEvent listener) {
        this.sourceEditor.removeSaveListener(listener);
    }

    public IUnifiedEditorContributor getBaseContributor() {
        return this.sourceEditor.getBaseContributor();
    }

    public String getDefaultFileExtension() {
        return this.sourceEditor.getDefaultFileExtension();
    }

    public void addFileServiceChangeListener(IFileServiceChangeListener listener) {
        this.sourceEditor.addFileServiceChangeListener(listener);
    }

    public void removeFileServiceChangeListener(IFileServiceChangeListener listener) {
        this.sourceEditor.removeFileServiceChangeListener(listener);
    }

    public IPreferenceStore getPreferenceStore() {
        return HTMLPlugin.getDefault().getPreferenceStore();
    }

    public void showPianoKeys(boolean state) {
        if (this.sourceEditor != null) {
            this.sourceEditor.showPianoKeys(state);
        }
    }

    public EditorPart getInnerEditor() {
        return this.editor;
    }
}

