/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.snippets;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.snippets.Messages;
import com.aptana.ide.snippets.ResourceChangeListener;
import com.aptana.ide.snippets.Snippet;
import com.aptana.ide.snippets.SnippetsInfo;
import com.aptana.ide.snippets.SnippetsManager;
import com.aptana.ide.snippets.SnippetsPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class SnippetsStartup {
    private static SnippetsStartup instance;

    private SnippetsStartup() {
    }

    public static SnippetsStartup getInstance() {
        if (instance == null) {
            instance = new SnippetsStartup();
            instance.loadBuiltins();
            instance.loadFromWorkspace();
            instance.loadFromExtensionPoints();
        }
        return instance;
    }

    public static void init() {
        SnippetsStartup.getInstance();
    }

    private void loadBuiltins() {
        URL unresolved;
        SnippetsManager snippets = SnippetsManager.getInstance();
        Bundle snippetsBundle = Platform.getBundle((String)"com.aptana.ide.snippets");
        if (snippetsBundle != null && (unresolved = FileLocator.find((Bundle)snippetsBundle, (IPath)new Path("/snippets"), null)) != null) {
            try {
                URL resolved = FileLocator.toFileURL((URL)unresolved);
                File snippetsDir = new File(resolved.getFile());
                snippets.loadSnippetDirectory(snippetsDir);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)SnippetsPlugin.getDefault(), (String)Messages.SnippetsStartup_ErrorExtractingBundledSnippets, (Throwable)e);
            }
        }
        String tempDir = snippets.getSnippetTempDirectory();
        File snippetsTempDir = new File(tempDir);
        snippets.loadSnippetDirectory(snippetsTempDir);
    }

    private void loadFromWorkspace() {
        SnippetsManager snippets = SnippetsManager.getInstance();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ResourceChangeListener listener = new ResourceChangeListener();
        workspace.addResourceChangeListener((IResourceChangeListener)listener, 1);
        int i = 0;
        while (i < workspace.getRoot().getProjects().length) {
            IProject project = workspace.getRoot().getProjects()[i];
            IFolder folder = project.getFolder("snippets");
            if (folder != null) {
                try {
                    int j = 0;
                    while (j < folder.members().length) {
                        File file;
                        Snippet snippet;
                        IResource resource = folder.members()[j];
                        if (resource instanceof IFile && (snippet = Snippet.fromFile(file = resource.getLocation().toFile())) != null) {
                            snippets.addSnippet(snippet);
                        }
                        ++j;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }

    private void loadFromExtensionPoints() {
        SnippetsManager snippets = SnippetsManager.getInstance();
        SnippetsInfo[] snippetsInfo = SnippetsStartup.findSnippetsInfoExtensions();
        int i = 0;
        while (i < snippetsInfo.length) {
            String snippetsDir = snippetsInfo[i].directory;
            try {
                snippets.loadSnippetDirectory(new File(snippetsDir));
            }
            catch (Exception exception) {
                IdeLog.logError((Plugin)SnippetsPlugin.getDefault(), (String)("loadSnippetDirectory:" + snippetsDir));
            }
            ++i;
        }
    }

    public static SnippetsInfo[] findSnippetsInfoExtensions() {
        ArrayList<SnippetsInfo> list = new ArrayList<SnippetsInfo>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.aptana.ide.snippets.snippetspath");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configurations = extension.getConfigurationElements();
                int j = 0;
                while (j < configurations.length) {
                    IConfigurationElement element = configurations[j];
                    try {
                        IExtension declaring = element.getDeclaringExtension();
                        String declaringPluginID = declaring.getNamespaceIdentifier();
                        Bundle bunble = Platform.getBundle((String)declaringPluginID);
                        SnippetsInfo snippetsInfo = new SnippetsInfo();
                        String directory = element.getAttribute("directory");
                        String resolvedPath = SnippetsStartup.getResolvedFilename(bunble, directory);
                        if (resolvedPath != null) {
                            snippetsInfo.directory = resolvedPath;
                            String iconFile = element.getAttribute("iconFile");
                            if (iconFile != null && iconFile.length() > 0) {
                                snippetsInfo.iconFile = resolvedPath = SnippetsStartup.getResolvedFilename(bunble, iconFile);
                            }
                            list.add(snippetsInfo);
                        }
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
                    ++j;
                }
                ++i;
            }
        }
        return list.toArray(new SnippetsInfo[list.size()]);
    }

    private static String getResolvedFilename(Bundle b, String fullPath) {
        URL url = SnippetsStartup.getResolvedURL(b, fullPath);
        if (url != null) {
            return url.getFile();
        }
        return null;
    }

    private static URL getResolvedURL(Bundle b, String fullPath) {
        URL url = FileLocator.find((Bundle)b, (IPath)new Path(fullPath), null);
        if (url != null) {
            try {
                URL localUrl = FileLocator.toFileURL((URL)url);
                if (localUrl != null) {
                    return localUrl;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

