/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.update.handler;

import com.aptana.ide.core.ui.AbstractPerspectiveFactory;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.update.handler.IFeatureUpdateHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.core.IFeature;

public class FeatureUpdateLoader {
    private static FeatureUpdateLoader instance;
    private Map ids = new HashMap();

    private FeatureUpdateLoader() {
        this.loadExtensionPoints();
    }

    private void loadExtensionPoints() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.update.feature");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                String id = ce[j].getAttribute("id");
                String handler = ce[j].getAttribute("handler");
                if (id != null) {
                    Object handlerObject = null;
                    if (handler != null) {
                        try {
                            Object createdHandler = ce[j].createExecutableExtension("handler");
                            if (createdHandler instanceof IFeatureUpdateHandler) {
                                handlerObject = createdHandler;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    this.ids.put(id, handlerObject);
                }
                ++j;
            }
            ++i;
        }
    }

    public Collection getFeatureIds() {
        return this.ids.keySet();
    }

    public IFeatureUpdateHandler getHandler(String featureId) {
        return (IFeatureUpdateHandler)this.ids.get(featureId);
    }

    public static FeatureUpdateLoader getInstance() {
        if (instance == null) {
            instance = new FeatureUpdateLoader();
        }
        return instance;
    }

    public static IFeature[] getFeaturesToUpdate() {
        IFeature[] features = AbstractPerspectiveFactory.getFeature((String)"com.aptana.ide.feature.rcp", (boolean)false);
        if (features.length == 0) {
            features = AbstractPerspectiveFactory.getFeature((String)"com.aptana.ide.feature", (boolean)false);
        }
        try {
            features = FeatureUpdateLoader.addFeatureToUpdate(features, "com.aptana.ide.framework.iphone");
            features = FeatureUpdateLoader.addFeatureToUpdate(features, "com.aptana.ide.feature.framework.air");
            features = FeatureUpdateLoader.addFeatureToUpdate(features, "com.aptana.ide.feature.editor.php");
            features = FeatureUpdateLoader.addFeatureToUpdate(features, "com.aptana.ide.feature.professional");
            features = FeatureUpdateLoader.addFeatureToUpdate(features, "org.radrails.rails_feature");
            Collection others = FeatureUpdateLoader.getInstance().getFeatureIds();
            for (String featureId : others) {
                IFeatureUpdateHandler handler = FeatureUpdateLoader.getInstance().getHandler(featureId);
                boolean add = true;
                if (handler != null) {
                    add = handler.shouldUpdate();
                }
                if (!add) continue;
                features = FeatureUpdateLoader.addFeatureToUpdate(features, featureId);
            }
        }
        catch (Exception ex) {
            CoreUIPlugin.logException((Throwable)ex, (boolean)false);
            features = new IFeature[]{};
        }
        return features;
    }

    private static IFeature[] addFeatureToUpdate(IFeature[] features, String featureId) {
        IFeature[] ifeature = AbstractPerspectiveFactory.getFeature((String)featureId, (boolean)false);
        if (ifeature.length > 0) {
            HashSet<IFeature> v = new HashSet<IFeature>();
            int i = 0;
            while (i < features.length) {
                v.add(features[i]);
                ++i;
            }
            int j = 0;
            while (j < ifeature.length) {
                v.add(ifeature[j]);
                ++j;
            }
            features = v.toArray(new IFeature[v.size()]);
        }
        return features;
    }
}

