/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.update;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.AbstractPerspectiveFactory;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.update.AutomaticUpdateJob;
import com.aptana.ide.core.ui.update.SchedulerStartup;
import com.aptana.ide.core.ui.update.UpdateMessageDialog;
import com.aptana.ide.core.ui.update.UpdateSchedulerMessages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.ui.wizards.InstallWizard;
import org.eclipse.update.internal.ui.wizards.InstallWizard2;
import org.eclipse.update.internal.ui.wizards.ResizableInstallWizardDialog;
import org.eclipse.update.operations.IInstallFeatureOperation;

class UpdateJobChangeAdapter
extends JobChangeAdapter {
    private SchedulerStartup startup;
    private static boolean showingDialog = false;

    public UpdateJobChangeAdapter(SchedulerStartup startup) {
        this.startup = startup;
    }

    public void done(IJobChangeEvent event) {
        if (event.getJob() == this.startup.getJob()) {
            final IInstallFeatureOperation[] features = ((AutomaticUpdateJob)this.startup.getJob()).getUpdates();
            if (features.length > 0 && !InstallWizard.isRunning()) {
                if (CoreUIPlugin.getDefault().getPluginPreferences().getBoolean("download")) {
                    UIJob job = new UIJob("Showing update dialog"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (CoreUIUtils.onMacOSX && (this.getDisplay() == null || this.getDisplay().getActiveShell() == null)) {
                                this.schedule(3000L);
                                return Status.OK_STATUS;
                            }
                            if (showingDialog || InstallWizard.isRunning()) {
                                return Status.OK_STATUS;
                            }
                            UpdateJobChangeAdapter.this.asyncNotifyDownloadUser(features);
                            UpdateJobChangeAdapter.this.startup.scheduleUpdateJob();
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                } else {
                    UIJob job = new UIJob("Showing update dialog"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (CoreUIUtils.onMacOSX && (this.getDisplay() == null || this.getDisplay().getActiveShell() == null)) {
                                this.schedule(3000L);
                                return Status.OK_STATUS;
                            }
                            if (showingDialog || InstallWizard.isRunning()) {
                                return Status.OK_STATUS;
                            }
                            UpdateJobChangeAdapter.this.asyncNotifyUser(features);
                            UpdateJobChangeAdapter.this.startup.scheduleUpdateJob();
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            } else {
                Job job = event.getJob();
                boolean showPrompt = false;
                if (job instanceof AutomaticUpdateJob) {
                    AutomaticUpdateJob auj = (AutomaticUpdateJob)job;
                    showPrompt = auj.showPrompt;
                }
                if (showPrompt) {
                    UIJob showJob = new UIJob("Showing update dialog"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (CoreUIUtils.onMacOSX && (this.getDisplay() == null || this.getDisplay().getActiveShell() == null)) {
                                this.schedule(3000L);
                                return Status.OK_STATUS;
                            }
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)UpdateSchedulerMessages.AutomaticUpdatesJob_EclipseUpdates1, (String)UpdateSchedulerMessages.UpdateJobChangeAdapter_NoUpdatresAvailableTryAgainLater);
                            return Status.OK_STATUS;
                        }
                    };
                    showJob.schedule();
                }
            }
        }
    }

    private void asyncNotifyUser(IInstallFeatureOperation[] features) {
        showingDialog = true;
        Display.getDefault().beep();
        ArrayList<String> notesPage = new ArrayList<String>();
        ArrayList<IFeature> featuresList = new ArrayList<IFeature>();
        int i = 0;
        while (i < features.length) {
            IInstallFeatureOperation operation = features[i];
            IFeature feature = operation.getFeature();
            try {
                String url = AbstractPerspectiveFactory.findReleaseNotesURL((IFeature)feature);
                notesPage.add(url);
                featuresList.add(feature);
                IdeLog.logInfo((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)UpdateSchedulerMessages.UpdateJobChangeAdapter_UpdateURLReleaseNotes, (String)url));
            }
            catch (Exception exception) {
                IdeLog.logInfo((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)"Unable to get update url for feature {0}", (String)feature.getLabel()));
            }
            ++i;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        UpdateMessageDialog md = new UpdateMessageDialog(shell, UpdateSchedulerMessages.AutomaticUpdatesJob_EclipseUpdates1, null, UpdateSchedulerMessages.AutomaticUpdatesJob_UpdatesAvailable, 2, new String[]{CoreStrings.INSTALL, CoreStrings.CANCEL}, 1, notesPage.toArray(new String[0]), featuresList.toArray(new IFeature[0]));
        if (md.open() == 0) {
            showingDialog = false;
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    UpdateJobChangeAdapter.this.openInstallWizard2();
                }
            });
        } else {
            showingDialog = false;
        }
    }

    private void asyncNotifyDownloadUser(IInstallFeatureOperation[] features) {
        showingDialog = true;
        Display.getDefault().beep();
        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)UpdateSchedulerMessages.AutomaticUpdatesJob_EclipseUpdates2, (String)UpdateSchedulerMessages.AutomaticUpdatesJob_UpdatesDownloaded)) {
            showingDialog = false;
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    UpdateJobChangeAdapter.this.openInstallWizard2();
                }
            });
        } else {
            showingDialog = false;
        }
    }

    private void openInstallWizard2() {
        if (InstallWizard.isRunning()) {
            return;
        }
        AutomaticUpdateJob ujob = (AutomaticUpdateJob)this.startup.getJob();
        InstallWizard2 wizard = new InstallWizard2(ujob.getSearchRequest(), ujob.getUpdates(), true);
        ResizableInstallWizardDialog dialog = new ResizableInstallWizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard, UpdateSchedulerMessages.AutomaticUpdatesJob_Updates);
        dialog.create();
        dialog.open();
    }
}

