/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.update;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.Base64;
import com.aptana.ide.core.DateUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.MutexJobRule;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.db.EventInfo;
import com.aptana.ide.core.db.EventLogger;
import com.aptana.ide.core.ui.AbstractPerspectiveFactory;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.core.ui.preferences.ApplicationPreferences;
import com.aptana.ide.core.ui.update.AutomaticUpdateJob;
import com.aptana.ide.core.ui.update.Messages;
import com.aptana.ide.update.Activator;
import com.aptana.ide.update.handler.FeatureUpdateLoader;
import com.eaio.uuid.MACAddress;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IStartup;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerStartup
implements IStartup {
    private static final String INSTALL_URL = "http://check.aptana.com/install.php";
    private static final String UPDATE_URL = "https://check.aptana.com/update2.php";
    private static final Set<String> FEATURES;
    private static final Pattern TRAILING_DOTTED_NUMBERS;
    private static final int READ_TIMEOUT = 900000;
    private static final long SLEEP_DELAY = 86400000L;
    private Job job;
    static final Object automaticJobFamily;
    private IJobChangeListener jobListener;

    static {
        TRAILING_DOTTED_NUMBERS = Pattern.compile("(?:\\.[0-9]+)+$");
        automaticJobFamily = new Object();
        FEATURES = new HashSet<String>();
        FEATURES.add("com.aptana.ide.feature");
        FEATURES.add("com.aptana.ide.feature.professional");
        FEATURES.add("com.aptana.ide.feature.editor.php");
        FEATURES.add("org.rubypeople.rdt");
        FEATURES.add("org.radrails.rails_feature");
        FEATURES.add("com.aptana.radrails.feature.professional");
        FEATURES.add("org.python.pydev.feature");
        FEATURES.add("com.python.pydev.extensions");
        FEATURES.add("com.aptana.ide.feature.framework.air");
        FEATURES.add("com.aptana.air.feature.professional");
        FEATURES.add("com.aptana.ide.framework.iphone");
        FEATURES.add("com.aptana.ide.feature.framework.jaxer");
        FEATURES.add("com.aptana.ide.feature.server.cloud");
        FEATURES.add("com.nokia.wrt.feature");
        FEATURES.add("com.adobe.spry");
        FEATURES.add("org.aflax");
        FEATURES.add("org.dojotoolkit.dojo");
        FEATURES.add("com.extjs.ext");
        FEATURES.add("com.facebook.jscl");
        FEATURES.add("com.jquery");
        FEATURES.add("com.mochikit");
        FEATURES.add("net.mootools");
        FEATURES.add("com.ms.ajax");
        FEATURES.add("org.openrico.rico");
        FEATURES.add("org.prototypejs.prototype");
        FEATURES.add("org.scriptaculous");
        FEATURES.add("com.yahoo.yui");
    }

    public SchedulerStartup() {
        Activator.setScheduler(this);
    }

    public void earlyStartup() {
        this.scheduleUpdateJob();
    }

    public void scheduleUpdateJob() {
        CoreUIPlugin plugin = CoreUIPlugin.getDefault();
        Preferences pref = plugin.getPluginPreferences();
        if (!pref.getBoolean("enabled")) {
            return;
        }
        String schedule = pref.getString("schedule");
        long delay = -1L;
        if (schedule.equals("on-startup")) {
            delay = this.job == null ? 30000L : -1L;
        }
        if (delay == -1L) {
            return;
        }
        this.startSearch(delay, false);
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(86400000L);
                        SchedulerStartup.this.startSearch(0L, false);
                    }
                }
                catch (InterruptedException e) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.SchedulerStartup_Interrupting24HourThread, (Throwable)e);
                    return;
                }
            }
        }, "Aptana: 24-hour update check");
        t.setDaemon(true);
        t.start();
    }

    public void startSearch(long delay, boolean showPrompt) {
        if (this.job != null) {
            if (this.jobListener != null) {
                Platform.getJobManager().removeJobChangeListener(this.jobListener);
            }
            Platform.getJobManager().cancel((Object)this.job);
        }
        if (this.jobListener == null) {
            this.jobListener = this.createJobChangeAdapter();
            if (this.jobListener == null) {
                return;
            }
        }
        Platform.getJobManager().addJobChangeListener(this.jobListener);
        String jobName = Messages.SchedulerStartup_SearchingForUpdates;
        boolean download = CoreUIPlugin.getDefault().getPluginPreferences().getBoolean("download");
        this.job = this.createUpdateJob(jobName, download, showPrompt);
        if (this.job != null) {
            SchedulerStartup.updateAnonymousId();
            this.job.setRule((ISchedulingRule)MutexJobRule.getInstance());
            this.job.schedule(delay);
        }
    }

    static void updateAnonymousId() {
        URL url = null;
        boolean needId = false;
        boolean success = false;
        ApplicationPreferences preferences = ApplicationPreferences.getInstance();
        preferences.loadPreferences();
        boolean hasRun = preferences.getBoolean("ide-has-run");
        String applicationId = preferences.getString("ide-id");
        Preferences p = CoreUIPlugin.getDefault().getPluginPreferences();
        String workspaceId = p.getString("ide-id");
        if (applicationId == null || applicationId.length() == 0) {
            if (workspaceId == null || workspaceId.length() == 0) {
                applicationId = "none";
                needId = true;
            } else {
                applicationId = workspaceId;
                preferences.setString("ide-id", applicationId);
                preferences.savePreferences();
            }
        } else if (workspaceId != null && workspaceId.length() > 0 && !workspaceId.equals(applicationId)) {
            applicationId = workspaceId;
        }
        String queryString = null;
        try {
            String line;
            EventInfo[] events;
            ArrayList<String> keyValues = new ArrayList<String>();
            SchedulerStartup.addKeyPair(keyValues, "id", applicationId);
            SchedulerStartup.addKeyPair(keyValues, "v", PluginUtils.getPluginVersion((Plugin)AptanaCorePlugin.getDefault()));
            SchedulerStartup.addKeyPair(keyValues, "p", System.getProperty("eclipse.product"));
            SchedulerStartup.addKeyPair(keyValues, "ev", System.getProperty("osgi.framework.version"));
            SchedulerStartup.addKeyPair(keyValues, "osa", System.getProperty("os.arch"));
            SchedulerStartup.addKeyPair(keyValues, "osn", System.getProperty("os.name"));
            SchedulerStartup.addKeyPair(keyValues, "osv", System.getProperty("os.version"));
            SchedulerStartup.addKeyPair(keyValues, "pre", SchedulerStartup.getPreviewString());
            SchedulerStartup.addKeyPair(keyValues, "pro", CoreUIUtils.getEncryptedProValue());
            EventLogger.getInstance().logEvent("DATE_TIME");
            EventLogger.getInstance().logEvent("STUDIO_KEY", MACAddress.getMACAddress());
            SchedulerStartup.addFeatureList();
            EventInfo[] eventInfoArray = events = EventLogger.getInstance().getEvents();
            int n = 0;
            int n2 = eventInfoArray.length;
            while (n < n2) {
                EventInfo event = eventInfoArray[n];
                if (!event.getEventType().equals("PREVIEW")) {
                    String key = String.valueOf(event.getEventType()) + "[]";
                    String value = String.valueOf(Long.toString(event.getDateTime())) + ":" + event.getMessage();
                    SchedulerStartup.addKeyPair(keyValues, key, value);
                }
                ++n;
            }
            queryString = StringUtils.join((String)"&", (String[])keyValues.toArray(new String[keyValues.size()]));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            gos.write(queryString.getBytes());
            gos.flush();
            gos.finish();
            gos.close();
            baos.close();
            byte[] gzippedData = baos.toByteArray();
            url = new URL(UPDATE_URL);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Encoding", "gzip");
            connection.setRequestProperty("Content-Length", String.valueOf(gzippedData.length));
            connection.setRequestProperty("User-Agent", SchedulerStartup.getUserAgent());
            connection.setReadTimeout(900000);
            DataOutputStream output = new DataOutputStream(connection.getOutputStream());
            output.write(gzippedData);
            output.flush();
            BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer sb = new StringBuffer();
            while ((line = input.readLine()) != null) {
                sb.append(line);
            }
            output.close();
            input.close();
            String newId = sb.toString();
            if (needId && newId.matches("^[0-9]+$")) {
                preferences.setString("ide-id", newId);
                preferences.setBoolean("ide-has-run", true);
                preferences.savePreferences();
            }
            success = true;
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.SchedulerStartup_UrlIsMalformed, url), (Throwable)e);
        }
        catch (IOException iOException) {
            if (needId && !hasRun) {
                WorkbenchHelper.launchBrowser((String)("http://check.aptana.com/install.php?" + queryString));
                preferences.setBoolean("ide-has-run", true);
                preferences.savePreferences();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.SchedulerStartup_UnableToContactUpdateServer, (Throwable)e);
        }
        if (success) {
            EventLogger.getInstance().clearEvents();
        } else {
            long fourWeeksAgo = DateUtils.addDayInterval((long)System.currentTimeMillis(), (int)-28);
            EventLogger.getInstance().clearEvents(fourWeeksAgo);
        }
    }

    private static void addKeyPair(List<String> keyValues, String key, String value) {
        if (value == null) {
            value = "";
        }
        keyValues.add(StringUtils.urlEncodeKeyValuePair((String)key, (String)value));
    }

    private static void addFeatureList() {
        HashSet<String> plugins = new HashSet<String>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] iConfiguredSiteArray = config.getConfiguredSites();
            int n = 0;
            int n2 = iConfiguredSiteArray.length;
            while (n < n2) {
                IConfiguredSite site = iConfiguredSiteArray[n];
                IFeatureReference[] iFeatureReferenceArray = site.getFeatureReferences();
                int n3 = 0;
                int n4 = iFeatureReferenceArray.length;
                while (n3 < n4) {
                    VersionedIdentifier ident;
                    IFeatureReference ref = iFeatureReferenceArray[n3];
                    IFeature feature = ref.getFeature(null);
                    if (feature != null && (ident = feature.getVersionedIdentifier()) != null) {
                        String name = ident.getIdentifier();
                        PluginVersionIdentifier versionID = ident.getVersion();
                        if (name != null && name.length() > 0 && versionID != null) {
                            Matcher m = TRAILING_DOTTED_NUMBERS.matcher(name);
                            if (m.find()) {
                                name = name.substring(0, m.start());
                            }
                            if (FEATURES.contains(name)) {
                                String enabled = Boolean.toString(SchedulerStartup.isEnabled(ref));
                                String version = versionID.toString();
                                plugins.add(String.valueOf(name) + ":" + version + ":" + enabled);
                            }
                        }
                    }
                    ++n3;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        for (String versionID : plugins) {
            EventLogger.getInstance().logEvent("FEATURE", versionID);
        }
    }

    private static boolean isEnabled(IFeatureReference ref) {
        boolean result = true;
        try {
            IFeature feature = ref.getFeature();
            IConfiguredSite site = ref.getSite().getCurrentConfiguredSite();
            if (site != null) {
                result = site.isConfigured(feature);
            }
        }
        catch (CoreException coreException) {}
        return result;
    }

    static String getPreviewString() {
        EventInfo[] events = EventLogger.getInstance().getEvents("PREVIEW");
        String result = "-";
        if (events.length > 0) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteStream);
            int minuteInterval = 10;
            long stopTime = DateUtils.roundDownToMinuteInterval((long)System.currentTimeMillis(), (int)minuteInterval);
            stopTime = DateUtils.addMinuteInterval((long)stopTime, (int)minuteInterval);
            long nextTime = events[0].getDateTime();
            nextTime = DateUtils.roundDownToMinuteInterval((long)nextTime, (int)minuteInterval);
            int currentByte = 0;
            int shiftCount = 0;
            int eventIndex = 0;
            try {
                output.writeLong(nextTime);
                output.writeInt(minuteInterval);
                nextTime = DateUtils.addMinuteInterval((long)nextTime, (int)minuteInterval);
                do {
                    boolean match = false;
                    while (eventIndex < events.length) {
                        if (events[eventIndex].getDateTime() >= nextTime) break;
                        match = true;
                        ++eventIndex;
                    }
                    currentByte = match ? currentByte << 1 | 1 : (currentByte <<= 1);
                    if (++shiftCount != 8) continue;
                    output.writeByte(currentByte);
                    currentByte = 0;
                    shiftCount = 0;
                } while ((nextTime = DateUtils.addMinuteInterval((long)nextTime, (int)minuteInterval)) <= stopTime);
                if (shiftCount > 0) {
                    output.writeByte(currentByte <<= 8 - shiftCount);
                }
                output.close();
                byte[] data = byteStream.toByteArray();
                result = Base64.encodeBytes((byte[])data, (int)8);
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private static String getUserAgent() {
        return "Aptana/1.2";
    }

    private Job createUpdateJob(String name, boolean download, boolean showPrompt) {
        try {
            IFeature[] features = FeatureUpdateLoader.getFeaturesToUpdate();
            return new AutomaticUpdateJob(name, true, download, features, showPrompt);
        }
        catch (Exception e) {
            CoreUIPlugin.logException((Throwable)e, (boolean)false);
            return null;
        }
    }

    private IFeature[] addFeatureToUpdate(IFeature[] features, String featureId) {
        IFeature[] airFeature = AbstractPerspectiveFactory.getFeature((String)featureId, (boolean)false);
        if (airFeature.length > 0) {
            Vector<IFeature> v = new Vector<IFeature>();
            int i = 0;
            while (i < features.length) {
                v.add(features[i]);
                ++i;
            }
            int j = 0;
            while (j < airFeature.length) {
                v.add(airFeature[j]);
                ++j;
            }
            features = v.toArray(new IFeature[v.size()]);
        }
        return features;
    }

    private IJobChangeListener createJobChangeAdapter() {
        try {
            Class<?> theClass = Class.forName("com.aptana.ide.core.ui.update.UpdateJobChangeAdapter");
            Constructor<?> constructor = theClass.getConstructor(SchedulerStartup.class);
            return (IJobChangeListener)constructor.newInstance(this);
        }
        catch (Exception e) {
            CoreUIPlugin.logException((Throwable)e, (boolean)false);
            return null;
        }
    }

    Job getJob() {
        return this.job;
    }
}

