/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.preferences;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.colorizer.IErrorHandler;
import com.aptana.ide.logging.LoggingPreferences;
import com.aptana.ide.logging.preferences.LoggingPreferenceWidget;
import com.aptana.ide.logging.preferences.LoggingStructureProvider;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TailViewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IErrorHandler {
    private LoggingPreferenceWidget mainWidget;
    private LoggingStructureProvider provider;

    public TailViewPreferencePage() {
        this.setPreferenceStore(UnifiedEditorsPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.mainWidget = new LoggingPreferenceWidget();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 700;
        parent.setData((Object)gridData);
        this.mainWidget.createControl(parent, gridData);
        LoggingPreferences.createLanguageColorizer();
        this.provider = new LoggingStructureProvider();
        this.mainWidget.setProvider(this.provider);
        this.provider.refreshTokens();
        this.mainWidget.setErrorHandler(this);
        return this.mainWidget.getControl();
    }

    public void dispose() {
        this.mainWidget.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        this.mainWidget.saveStyles();
        super.performApply();
    }

    protected void performDefaults() {
        this.mainWidget.resetToDefaults();
    }

    public boolean performOk() {
        this.mainWidget.saveStyles();
        this.provider.applyChanges();
        this.mainWidget.getProvider().buildLanguageColorizer(LanguageRegistry.getLanguageColorizer((String)"text/log"), "com.aptana.ide.logging.coloring.colorizer");
        return super.performOk();
    }

    public void applyData(Object data) {
        if (data != null && data instanceof Integer) {
            int tabNumber = (Integer)data;
            if (this.mainWidget != null) {
                this.mainWidget.activateTab(tabNumber);
            }
        }
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
        this.setValid(message == null);
    }
}

