/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.preferences;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.colorizer.CategoryColorizer;
import com.aptana.ide.editors.unified.colorizer.ColorizationStyle;
import com.aptana.ide.editors.unified.colorizer.ColorizerReader;
import com.aptana.ide.editors.unified.colorizer.ColorizerWriter;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.colorizer.Region;
import com.aptana.ide.editors.unified.colorizer.TokenColorizer;
import com.aptana.ide.lexer.IEnumerationMap;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.LoggingPreferences;
import com.aptana.ide.logging.coloring.TokenCategories;
import com.aptana.ide.logging.coloring.TokenTypes;
import com.aptana.ide.logging.preferences.LoggingColorizerReader;
import com.aptana.ide.logging.preferences.LoggingColorizerWriter;
import com.aptana.ide.logging.preferences.TokensReader;
import com.aptana.sax.AttributeSniffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingStructureProvider
implements ITreeContentProvider,
ITableLabelProvider {
    public static final String COLORIZATION_SAVED = "Colorization saved";
    private Map<String, Category> categories;
    private Map<IToken, HashMap> regions;
    private Map imageMap;
    private Color backgroundColor = null;
    private Color lineHighlightColor = null;
    private Color caretColor = null;
    private Color selectionForegroundColor = null;
    private Color selectionBackgroundColor = null;
    private Color foldingBackgroundColor;
    private Color foldingForegroundColor;
    private RGB black;
    private FontData[] font;
    private Boolean autobolding = null;
    private Boolean wrapping = null;
    private RGB cursorLineColor = null;
    private RGB textForegroundColor = null;
    private Integer backlogLines;
    private List<LoggingPreferences.Rule> tempRules = new ArrayList<LoggingPreferences.Rule>();
    private boolean initialWrapping;
    private Integer readTimeout;
    private Integer readBuffer;
    private String defaultEncoding;

    private String hashToken(IToken token) {
        return String.valueOf(token.getLanguage()) + "::" + token.getCategory() + "::" + token.getType();
    }

    public LoggingStructureProvider() {
        this.categories = new HashMap<String, Category>();
        this.imageMap = new HashMap();
        this.regions = new HashMap<IToken, HashMap>();
        this.black = new RGB(0, 0, 0);
        this.loadProvider();
        List<LoggingPreferences.Rule> rules = LoggingPlugin.getDefault().getLoggingPreferences().getRules();
        this.tempRules.addAll(rules);
    }

    public void loadProvider() {
        this.loadProvider(null, null);
    }

    public void loadProvider(List<IToken> initialTokens, LanguageColorizer colorizer) {
        LanguageColorizer lc;
        List<IToken> tokens;
        if (initialTokens == null) {
            ITokenList tl = TokenTypes.getTokenList();
            tokens = new ArrayList<IToken>();
            if (tl != null) {
                int i = 0;
                while (i < tl.size()) {
                    IToken curr = tl.get(i);
                    this.addToken(curr);
                    tokens.add(curr);
                    ++i;
                }
            }
        } else {
            tokens = initialTokens;
            for (IToken curr : tokens) {
                this.addToken(curr);
            }
        }
        if ((lc = colorizer) == null) {
            lc = LanguageRegistry.getLanguageColorizer((String)"text/log", (ColorizerReader)new ColorizerReader());
        }
        if (lc != null) {
            this.initializeColoring(lc);
            this.checkDefaultStyles(tokens);
            this.createInitialWrapping();
        }
    }

    private void initializeColoring(LanguageColorizer lc) {
        for (TokenColorizer curr : lc.getTokenColorizers()) {
            ColorizationStyle currStyle = curr.getBaseColorization();
            ColorizationStyle clone = new ColorizationStyle(currStyle);
            this.addStyle(curr.getToken(), clone);
            Iterator regions = curr.getRegions().iterator();
            HashMap<String, Region> regionMap = new HashMap<String, Region>();
            while (regions.hasNext()) {
                Region region = (Region)regions.next();
                Region cloneRegion = new Region(region);
                ColorizationStyle regionStyle = region.getStyle();
                ColorizationStyle regionCloneStyle = new ColorizationStyle(regionStyle);
                cloneRegion.setStyle(regionCloneStyle);
                cloneRegion.setName(region.getName());
                regionMap.put(cloneRegion.getName(), cloneRegion);
                this.addRegion(curr.getToken(), cloneRegion);
            }
        }
        for (TokenColorizer curr : lc.getCategoryColorizers()) {
            ColorizationStyle clone = new ColorizationStyle(curr.getStyle());
            Category category = this.getCategory(curr.getName());
            category.setStyle(clone);
        }
        this.setBackgroundColor(lc.getBackground());
        this.setCaretColor(lc.getCaretColor());
        this.setLineHighlightColor(lc.getLineHighlightColor());
        this.setSelectionForegroundColor(lc.getSelectionForeground());
        this.setSelectionBackgroundColor(lc.getSelectionBackground());
        this.setFoldingBackgroundColor(lc.getFoldingBg());
        this.setFoldingForegroundColor(lc.getFoldingFg());
    }

    public void clear() {
        this.clearStyles();
        for (Category cat : this.categories.values()) {
            cat.clear();
        }
    }

    public void clearStyles() {
        for (Category cat : this.categories.values()) {
            cat.setStyle(null);
            cat.getStyles().clear();
        }
        for (Map map : this.regions.values()) {
            map.clear();
        }
    }

    public void addStyle(IToken token, ColorizationStyle style) {
        Category cat = this.getCategory(token.getCategory());
        cat.addTokenStyle(token, style);
    }

    public void removeStyle(IToken token) {
        Category cat = this.getCategory(token.getCategory());
        cat.removeTokenStyle(token);
        Map regionMap = this.regions.get(token);
        regionMap.clear();
    }

    public void removeRegion(IToken token, String name) {
        Map regionMap = this.regions.get(token);
        regionMap.remove(name);
    }

    public void addRegion(IToken token, Region region) {
        Map regionMap = this.regions.get(token);
        regionMap.put(region.getName(), region);
    }

    public Map getRegions(IToken token) {
        return this.regions.get(token);
    }

    public Map getTokenStyles() {
        HashMap all = new HashMap();
        for (Category cat : this.categories.values()) {
            all.putAll(cat.getStyles());
        }
        return all;
    }

    public Collection<IToken> getTokens() {
        ArrayList<IToken> all = new ArrayList<IToken>();
        for (Category cat : this.categories.values()) {
            all.addAll(cat.getTokens());
        }
        return all;
    }

    public Map getCategoryStyles() {
        HashMap<Category, ColorizationStyle> all = new HashMap<Category, ColorizationStyle>();
        for (Category cat : this.categories.values()) {
            all.put(cat, cat.getStyle());
        }
        return all;
    }

    public ColorizationStyle getStyle(IToken token) {
        Category cat = this.getCategory(token.getCategory());
        return cat.getTokenStyle(token);
    }

    public Category getCategory(String category) {
        Category cat = null;
        if (this.categories.containsKey(category)) {
            cat = this.categories.get(category);
        }
        return cat;
    }

    public void addToken(IToken token) {
        Category category = null;
        if (!this.categories.containsKey(token.getCategory())) {
            category = new Category(token.getCategory());
            ColorizationStyle style = new ColorizationStyle();
            style.setForegroundColor(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
            style.setName(category.getName());
            category.setStyle(style);
            this.categories.put(token.getCategory(), category);
        } else {
            category = this.categories.get(token.getCategory());
        }
        if (category.getToken(this.hashToken(token)) == null) {
            category.addToken(token);
        }
        if (this.regions.get(token) == null) {
            this.regions.put(token, new HashMap());
        }
    }

    public void addToken(IToken token, int pos) {
        Category category = null;
        if (!this.categories.containsKey(token.getCategory())) {
            category = new Category(token.getCategory());
            ColorizationStyle style = new ColorizationStyle();
            style.setForegroundColor(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
            style.setName(category.getName());
            category.setStyle(style);
            this.categories.put(token.getCategory(), category);
        } else {
            category = this.categories.get(token.getCategory());
        }
        if (category.getToken(this.hashToken(token)) == null) {
            category.addToken(token, pos);
        }
        if (this.regions.get(token) == null) {
            this.regions.put(token, new HashMap());
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Category) {
            return ((Category)parentElement).getTokens().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IToken) {
            IToken token = (IToken)element;
            return this.getCategory(token.getCategory());
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof Category;
    }

    public Object[] getElements(Object inputElement) {
        for (Category category : this.categories.values()) {
            if (!category.getName().equals(TokenTypes.DEFAULT_CATEGORY)) continue;
            return this.getChildren(category);
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void disposeImages() {
        Iterator iter = this.imageMap.values().iterator();
        while (iter.hasNext()) {
            ((Image)iter.next()).dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ColorizationStyle style = null;
        if (element instanceof IToken) {
            style = this.getStyle((IToken)element);
        } else if (element instanceof Category) {
            style = ((Category)element).getStyle();
        }
        if (style != null) {
            if (columnIndex == 0 && element instanceof IToken) {
                return UnifiedEditorsPlugin.getImage((String)"icons/checked.gif");
            }
            if (columnIndex == 2 && element instanceof IToken) {
                if (!this.getRegions((IToken)element).isEmpty()) {
                    return UnifiedEditorsPlugin.getImage((String)"icons/region.gif");
                }
            } else if (columnIndex == 3) {
                if (style != null) {
                    Color fg = style.getForegroundColor();
                    Image img = null;
                    if (!this.imageMap.containsKey(fg.getRGB())) {
                        img = new Image((Device)Display.getCurrent(), 16, 16);
                        GC gc = new GC((Drawable)img);
                        gc.setBackground(fg);
                        gc.fillRectangle(1, 1, 13, 13);
                        gc.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
                        gc.drawRectangle(1, 1, 13, 13);
                        gc.dispose();
                        this.imageMap.put(fg.getRGB(), img);
                    } else {
                        img = (Image)this.imageMap.get(fg.getRGB());
                    }
                    return img;
                }
            } else {
                if (columnIndex == 4) {
                    if (style != null && style.isBold()) {
                        return UnifiedEditorsPlugin.getImage((String)"icons/bold_on.gif");
                    }
                    return UnifiedEditorsPlugin.getImage((String)"icons/bold_off.gif");
                }
                if (columnIndex == 5) {
                    if (style != null && style.isItalic()) {
                        return UnifiedEditorsPlugin.getImage((String)"icons/italic_on.gif");
                    }
                    return UnifiedEditorsPlugin.getImage((String)"icons/italic_off.gif");
                }
                if (columnIndex == 6) {
                    if (style != null && style.isUnderline()) {
                        return UnifiedEditorsPlugin.getImage((String)"icons/underline_on.gif");
                    }
                    return UnifiedEditorsPlugin.getImage((String)"icons/underline_off.gif");
                }
            }
        } else if (columnIndex == 0 && element instanceof IToken) {
            return UnifiedEditorsPlugin.getImage((String)"icons/unchecked.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 1 && element instanceof IToken) {
            return ((IToken)element).getType();
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeAll() {
        this.categories.clear();
        this.imageMap.clear();
        this.regions.clear();
        this.backgroundColor = null;
        this.lineHighlightColor = null;
        this.textForegroundColor = null;
        this.caretColor = null;
        this.selectionForegroundColor = null;
        this.selectionBackgroundColor = null;
    }

    public void buildLanguageColorizer(LanguageColorizer lc, String prefId) {
        this.buildLanguageColorizer(lc);
        try {
            ColorizerWriter writer = new ColorizerWriter();
            writer.buildColorizationPreference(lc, lc.getLanguage(), prefId);
            UnifiedEditorsPlugin.getDefault().getPreferenceStore().firePropertyChangeEvent(COLORIZATION_SAVED, (Object)COLORIZATION_SAVED, (Object)COLORIZATION_SAVED);
        }
        catch (LexerException e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage());
        }
    }

    public void buildLanguageColorizer(LanguageColorizer lc) {
        this.filterRegionsByTokens();
        Map tokenStyles = this.getTokenStyles();
        for (IToken curr : this.getTokens()) {
            ColorizationStyle cloneStyle = (ColorizationStyle)tokenStyles.get(this.hashToken(curr));
            if (cloneStyle == null) continue;
            ColorizationStyle newStyle = new ColorizationStyle(cloneStyle);
            TokenColorizer colorizer = lc.getTokenColorizer(curr);
            if (colorizer == null) {
                colorizer = new TokenColorizer();
                colorizer.setToken(curr);
                lc.addTokenColorizer(colorizer);
            }
            colorizer.setBaseColorization(newStyle);
            Map regionMap = this.getRegions(curr);
            for (Region region : regionMap.values()) {
                Region cloneRegion = new Region(region);
                cloneRegion.setName(region.getName());
                ColorizationStyle newRegionStyle = new ColorizationStyle(region.getStyle());
                newRegionStyle.setName(String.valueOf(curr.getCategory()) + "_" + curr.getType() + "_" + region.getName());
                cloneRegion.setStyle(newRegionStyle);
                colorizer.addColorization(cloneRegion);
            }
            Iterator existingRegions = colorizer.getRegions().iterator();
            while (existingRegions.hasNext()) {
                Region currRegion = (Region)existingRegions.next();
                if (regionMap.containsKey(currRegion.getName())) continue;
                existingRegions.remove();
            }
        }
        Iterator colorizers = lc.getTokenColorizers().iterator();
        while (colorizers.hasNext()) {
            TokenColorizer curr = (TokenColorizer)colorizers.next();
            if (tokenStyles.containsKey(this.hashToken(curr.getToken()))) continue;
            colorizers.remove();
        }
        Map categoryStyles = this.getCategoryStyles();
        for (Category category : categoryStyles.keySet()) {
            ColorizationStyle curr = (ColorizationStyle)categoryStyles.get(category);
            ColorizationStyle newStyle = new ColorizationStyle(curr);
            CategoryColorizer colorizer = lc.getCategoryColorizer(category.getName());
            if (colorizer == null) {
                colorizer = new CategoryColorizer();
                colorizer.setName(category.getName());
                lc.addCategoryColorizer(colorizer);
            }
            colorizer.setStyle(newStyle);
        }
        colorizers = lc.getCategoryColorizers().iterator();
        while (colorizers.hasNext()) {
            CategoryColorizer curr = (CategoryColorizer)colorizers.next();
            Category cat = this.getCategory(curr.getName());
            if (categoryStyles.containsKey(cat)) continue;
            colorizers.remove();
        }
        lc.setBackground(this.getBackgroundColor());
        lc.setCaretColor(this.getCaretColor());
        lc.setLineHighlightColor(this.getLineHighlightColor());
        lc.setSelectionBackground(this.getSelectionBackgroundColor());
        lc.setSelectionForeground(this.getSelectionForegroundColor());
        lc.setFoldingBg(this.getFoldingBackgroundColor());
        lc.setFoldingFg(this.getFoldingForegroundColor());
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color caretColor) {
        this.caretColor = caretColor;
    }

    public Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public void setLineHighlightColor(Color lineHighlightColor) {
        this.lineHighlightColor = lineHighlightColor;
    }

    public RGB getTextForegroundColor() {
        if (this.textForegroundColor == null) {
            this.textForegroundColor = LoggingPlugin.getDefault().getLoggingPreferences().getTextColorRGB();
        }
        return this.textForegroundColor;
    }

    public void setTextForegroundColor(RGB color) {
        this.textForegroundColor = color;
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        this.selectionBackgroundColor = selectionBackgroundColor;
    }

    public Color getSelectionForegroundColor() {
        return this.selectionForegroundColor;
    }

    public void setSelectionForegroundColor(Color selectionForegroundColor) {
        this.selectionForegroundColor = selectionForegroundColor;
    }

    public String getLanguage() {
        return "text/log";
    }

    public void setLanguage(String language) {
    }

    public void buildColorizationFile(File file) throws LexerException {
        LanguageColorizer colorizer = new LanguageColorizer("text/log");
        this.buildLanguageColorizer(colorizer);
        LoggingColorizerWriter writer = new LoggingColorizerWriter(this.tempRules);
        writer.buildColorizationFile(colorizer, this.getLanguage(), file);
    }

    public void importColorization(File file) {
        block8: {
            AttributeSniffer sniffer = new AttributeSniffer("colorizer", "language");
            try {
                sniffer.read((InputStream)new FileInputStream(file));
                if (this.getLanguage() != null && this.getLanguage().equals(sniffer.getMatchedValue())) {
                    TokensReader tokensReader = new TokensReader(this.tempRules);
                    FileInputStream stream = new FileInputStream(file);
                    try {
                        tokensReader.read(stream);
                    }
                    finally {
                        ((InputStream)stream).close();
                    }
                    ArrayList<IToken> newTokens = new ArrayList<IToken>();
                    ITokenList tl = TokenTypes.getTokenList();
                    for (LoggingPreferences.Rule rule : this.tempRules) {
                        IToken token = tl.createToken();
                        token.setCategory(TokenTypes.DEFAULT_CATEGORY);
                        token.setType(rule.getName());
                        newTokens.add(token);
                    }
                    TokenList newTokenList = this.tokenListByTokens(newTokens);
                    LoggingColorizerReader reader = new LoggingColorizerReader((ITokenList)newTokenList, false);
                    LanguageColorizer colorizer = reader.importColorization(file);
                    this.clear();
                    this.loadProvider(newTokens, colorizer);
                    break block8;
                }
                IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)"Unable loading serialized color data");
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)"Unable loading serialized color data", (Throwable)e);
            }
        }
    }

    public void resetToLanguageDefaults() {
        if (this.getLanguage() != null) {
            this.createInitialWrapping();
            LoggingPreferences preferences = LoggingPlugin.getDefault().getLoggingPreferences();
            this.font = preferences.getDefaultFont();
            this.autobolding = preferences.getDefaultAutoBolding();
            this.wrapping = preferences.getDefaultWrapping();
            this.cursorLineColor = preferences.getDefaultCursorLineColor();
            this.textForegroundColor = preferences.getDefaultTextColor();
            this.backlogLines = preferences.getDefaultBacklogLines();
            this.tempRules.clear();
            this.readTimeout = preferences.getDefaultReadTimeout();
            this.readBuffer = preferences.getDefaultReadBuffer();
            this.defaultEncoding = preferences.getDefaultDefaultEncoding();
            this.clearStyles();
            this.clear();
            preferences.fillDefaultRules(this);
        }
    }

    public void restoreGeneralDefaults() {
        if (this.getLanguage() != null) {
            this.createInitialWrapping();
            LoggingPreferences preferences = LoggingPlugin.getDefault().getLoggingPreferences();
            this.font = preferences.getDefaultFont();
            this.autobolding = preferences.getDefaultAutoBolding();
            this.wrapping = preferences.getDefaultWrapping();
            this.cursorLineColor = preferences.getDefaultCursorLineColor();
            this.textForegroundColor = preferences.getDefaultTextColor();
            this.backlogLines = preferences.getDefaultBacklogLines();
            this.readTimeout = preferences.getDefaultReadTimeout();
            this.readBuffer = preferences.getDefaultReadBuffer();
            this.defaultEncoding = preferences.getDefaultDefaultEncoding();
        }
    }

    public void restoreColorizationDefautls() {
        if (this.getLanguage() != null) {
            LoggingPreferences preferences = LoggingPlugin.getDefault().getLoggingPreferences();
            this.tempRules.clear();
            this.clearStyles();
            this.clear();
            preferences.fillDefaultRules(this);
        }
    }

    public void refreshTokens() {
        ITokenList tl = TokenTypes.getTokenList();
        ArrayList<String> original = new ArrayList<String>();
        if (tl != null) {
            int i = 0;
            while (i < tl.size()) {
                IToken curr = tl.get(i);
                original.add(curr.getType());
                Category category = this.getCategory(curr.getCategory());
                if (category == null || category.getToken(curr.getType()) == null) {
                    this.addToken(curr);
                }
                ++i;
            }
            ArrayList<IToken> toRemove = new ArrayList<IToken>();
            for (IToken token : this.getTokens()) {
                if (original.contains(token.getType())) continue;
                toRemove.add(token);
            }
            for (IToken token : toRemove) {
                this.removeToken(token);
            }
        }
        this.checkDefaultStyles(tl);
    }

    public Color getFoldingBackgroundColor() {
        return this.foldingBackgroundColor;
    }

    public void setFoldingBackgroundColor(Color foldingBackgroundColor) {
        this.foldingBackgroundColor = foldingBackgroundColor;
    }

    public Color getFoldingForegroundColor() {
        return this.foldingForegroundColor;
    }

    public void setFoldingForegroundColor(Color foldingForegroundColor) {
        this.foldingForegroundColor = foldingForegroundColor;
    }

    public void removeRule(IToken ruletoken) {
        LoggingPreferences.Rule rule = new LoggingPreferences.Rule(ruletoken.getType(), null, true, true);
        IToken toRemove = null;
        for (IToken token : this.getTokens()) {
            if (!token.getType().equals(rule.getName())) continue;
            toRemove = token;
            break;
        }
        if (toRemove != null) {
            this.removeStyle(toRemove);
            this.removeToken(toRemove);
        }
        this.getCurrentRules().remove(rule);
    }

    public void addRule(String name, String content, boolean isRegexp, boolean isCaseSensitive) {
        LoggingPreferences.Rule rule = new LoggingPreferences.Rule(name, content, isRegexp, isCaseSensitive);
        this.addRule(rule, null);
    }

    public void addRuleToBeginning(String name, String content, boolean isRegexp, boolean isCaseSensitive) {
        LoggingPreferences.Rule rule = new LoggingPreferences.Rule(name, content, isRegexp, isCaseSensitive);
        this.addRule(rule, 0, null);
    }

    public void addRule(String name, String content, boolean isRegexp, boolean isCaseSensitive, RGB color, boolean bold, boolean italic, boolean underline) {
        LoggingPreferences.Rule rule = new LoggingPreferences.Rule(name, content, isRegexp, isCaseSensitive);
        ColorizationStyle style = this.createStyle(name, color, bold, italic, underline);
        this.addRule(rule, style);
    }

    public void addRule(LoggingPreferences.Rule rule, int pos) {
        this.addRule(rule, pos, null);
    }

    public void addRule(LoggingPreferences.Rule rule, int pos, ColorizationStyle style) {
        IToken token = TokenTypes.getTokenList().createToken();
        token.setCategory(TokenTypes.DEFAULT_CATEGORY);
        token.setType(rule.getName());
        this.addToken(token, pos);
        this.checkDefaultStyle(token);
        this.getCurrentRules().add(pos, rule);
        if (style != null) {
            this.addStyle(token, style);
        }
    }

    public void addRule(LoggingPreferences.Rule rule, ColorizationStyle style) {
        IToken token = TokenTypes.getTokenList().createToken();
        token.setCategory(TokenTypes.DEFAULT_CATEGORY);
        token.setType(rule.getName());
        this.addToken(token);
        this.checkDefaultStyle(token);
        this.getCurrentRules().add(rule);
        if (style != null) {
            this.addStyle(token, style);
        }
    }

    public List<LoggingPreferences.Rule> getCurrentRules() {
        return this.tempRules;
    }

    public void updateRule(IToken ruletoken, String newContent, boolean isRegexp, boolean isCaseSensitive) {
        LoggingPreferences.Rule rule = new LoggingPreferences.Rule(ruletoken.getType(), newContent, isRegexp, isCaseSensitive);
        IToken toRemove = null;
        for (IToken token : this.getTokens()) {
            if (!token.getType().equals(rule.getName())) continue;
            toRemove = token;
            break;
        }
        if (toRemove != null) {
            ColorizationStyle style = this.getStyle(toRemove);
            int removedIndex = this.removeToken(toRemove);
            this.getCurrentRules().remove(rule);
            IToken token = TokenTypes.getTokenList().createToken();
            token.setCategory(TokenTypes.DEFAULT_CATEGORY);
            token.setType(rule.getName());
            this.addToken(token, removedIndex);
            this.addStyle(token, style);
            this.checkDefaultStyle(token);
            this.getCurrentRules().add(removedIndex, rule);
        }
    }

    public void moveRuleDown(IToken token) {
        int pos = this.rulePositionByToken(token);
        ColorizationStyle style = this.getStyleByToken(token);
        if (pos == -1 || pos == this.tempRules.size() - 1) {
            return;
        }
        LoggingPreferences.Rule rule = this.getCurrentRules().get(pos);
        this.removeRule(token);
        this.addRule(rule, pos + 1, style);
    }

    public void moveRuleUp(IToken token) {
        int pos = this.rulePositionByToken(token);
        ColorizationStyle style = this.getStyleByToken(token);
        if (pos == -1 || pos == 0) {
            return;
        }
        LoggingPreferences.Rule rule = this.getCurrentRules().get(pos);
        this.removeRule(token);
        this.addRule(rule, pos - 1, style);
    }

    public void applyChanges() {
        this.applyRuleChanges();
        this.applyAutoBolding();
        this.applyCursorLineColor();
        this.applyTextForegroundColor();
        this.applyFont();
        this.applyReadTimeout();
        this.applyReadBuffer();
        this.applyDefaultEncoding();
        this.applyBacklogLines();
        this.applyWrapping();
    }

    public boolean getAutoBolding() {
        if (this.autobolding == null) {
            this.autobolding = LoggingPlugin.getDefault().getLoggingPreferences().getAutoBolding();
        }
        return this.autobolding;
    }

    public void setFont(FontData[] font) {
        this.font = font;
    }

    public FontData[] getFont() {
        if (this.font == null) {
            this.font = LoggingPlugin.getDefault().getLoggingPreferences().getFontData();
        }
        return this.font;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getReadTimeot() {
        if (this.readTimeout == null) {
            this.readTimeout = LoggingPlugin.getDefault().getLoggingPreferences().getReadTimeout();
        }
        return this.readTimeout;
    }

    public void setReadBuffer(int buffer) {
        this.readBuffer = buffer;
    }

    public int getReadBuffer() {
        if (this.readBuffer == null) {
            this.readBuffer = LoggingPlugin.getDefault().getLoggingPreferences().getReadBuffer();
        }
        return this.readBuffer;
    }

    public void setAutoBolding(boolean autobolding) {
        this.autobolding = autobolding;
    }

    public boolean getWrapping() {
        if (this.wrapping == null) {
            this.wrapping = LoggingPlugin.getDefault().getLoggingPreferences().getWrapping();
        }
        return this.wrapping;
    }

    public void setWrapping(boolean wrapping) {
        this.wrapping = wrapping;
    }

    public int getBacklogLines() {
        if (this.backlogLines == null) {
            this.backlogLines = LoggingPlugin.getDefault().getLoggingPreferences().getBacklogLines();
        }
        return this.backlogLines;
    }

    public void setBacklogLines(int lines) {
        this.backlogLines = lines;
    }

    public RGB getCursorLineColor() {
        if (this.cursorLineColor == null) {
            this.cursorLineColor = LoggingPlugin.getDefault().getLoggingPreferences().getCursorLineColor();
        }
        return this.cursorLineColor;
    }

    public void setCursorLineColor(RGB color) {
        this.cursorLineColor = color;
    }

    public boolean tokensEqual(IToken token1, IToken token2) {
        return token1 == null ? token2 == null : this.hashToken(token1).equals(this.hashToken(token2));
    }

    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public String getDefaultEncoding() {
        if (this.defaultEncoding == null) {
            this.defaultEncoding = LoggingPlugin.getDefault().getLoggingPreferences().getDefaultEncoding();
        }
        return this.defaultEncoding;
    }

    private void checkDefaultStyles(ITokenList tokens) {
        int i = 0;
        while (i < tokens.size()) {
            IToken token = tokens.get(i);
            this.checkDefaultStyle(token);
            ++i;
        }
    }

    private void checkDefaultStyles(List<IToken> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            IToken token = tokens.get(i);
            this.checkDefaultStyle(token);
            ++i;
        }
    }

    private void checkDefaultStyle(IToken token) {
        if (this.getStyle(token) == null) {
            ColorizationStyle style = new ColorizationStyle();
            style.setForegroundColor(UnifiedColorManager.getInstance().getColor(this.black));
            style.setName(String.valueOf(token.getCategory()) + "_" + token.getType());
            this.addStyle(token, style);
        }
    }

    private int removeToken(IToken token) {
        Category cat = this.getCategory(token.getCategory());
        int index = cat.removeToken(token);
        Map regionMap = this.regions.get(token);
        regionMap.clear();
        this.regions.remove(token);
        return index;
    }

    private void applyAutoBolding() {
        if (this.autobolding != null) {
            LoggingPlugin.getDefault().getLoggingPreferences().setAutoBolding(this.autobolding);
        }
    }

    private void applyFont() {
        if (this.font != null) {
            LoggingPlugin.getDefault().getLoggingPreferences().setFontData(this.font);
        }
    }

    private void applyWrapping() {
        if (this.wrapping != null && !this.wrapping.equals(this.initialWrapping)) {
            LoggingPlugin.getDefault().getLoggingPreferences().setWrapping(this.wrapping);
        }
    }

    private void applyBacklogLines() {
        if (this.backlogLines != null) {
            LoggingPlugin.getDefault().getLoggingPreferences().setBacklogLines(this.backlogLines);
        }
    }

    private void applyReadTimeout() {
        if (this.readTimeout != null) {
            LoggingPlugin.getDefault().getLoggingPreferences().setReadTimeout(this.readTimeout);
        }
    }

    private void applyReadBuffer() {
        if (this.readBuffer != null) {
            LoggingPlugin.getDefault().getLoggingPreferences().setReadBuffer(this.readBuffer);
        }
    }

    private void applyDefaultEncoding() {
        if (this.defaultEncoding != null) {
            LoggingPlugin.getDefault().getLoggingPreferences().setDefaultEncoding(this.defaultEncoding);
        }
    }

    private void applyCursorLineColor() {
        if (this.cursorLineColor != null) {
            LoggingPlugin.getDefault().getLoggingPreferences().setCursorLineColor(this.cursorLineColor);
        }
    }

    private void applyTextForegroundColor() {
        if (this.textForegroundColor != null) {
            LoggingPlugin.getDefault().getLoggingPreferences().setTextColor(this.textForegroundColor);
        }
    }

    void applyRuleChanges() {
        List<LoggingPreferences.Rule> rules = LoggingPlugin.getDefault().getLoggingPreferences().getRules();
        rules.clear();
        rules.addAll(this.tempRules);
    }

    void filterRegionsByTokens() {
        Collection<IToken> tokens = this.getTokens();
        HashMap<IToken, HashMap> filteredRegions = new HashMap<IToken, HashMap>();
        for (IToken token : tokens) {
            if (!this.regions.containsKey(token)) continue;
            filteredRegions.put(token, this.regions.get(token));
        }
        this.regions.clear();
        this.regions.putAll(filteredRegions);
    }

    private void createInitialWrapping() {
        this.initialWrapping = LoggingPlugin.getDefault().getLoggingPreferences().getWrapping();
    }

    private TokenList tokenListByTokens(final List<IToken> tokens) {
        TokenList newTokenList = new TokenList();
        newTokenList.setCategoryMap(new IEnumerationMap(){

            public int getIntValue(String name) {
                return TokenCategories.getIntValue(name);
            }

            public String getName(int index) {
                return TokenCategories.getName(index);
            }

            public String[] getNames() {
                return TokenCategories.getNames();
            }
        });
        newTokenList.setTypeMap(new IEnumerationMap(){

            public int getIntValue(String name) {
                int i = 0;
                while (i < tokens.size()) {
                    IToken token = (IToken)tokens.get(i);
                    if (token.getType().equals(name)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            public String getName(int index) {
                return ((IToken)tokens.get(index)).getType();
            }

            public String[] getNames() {
                String[] names = new String[tokens.size()];
                tokens.toArray(names);
                return names;
            }
        });
        for (IToken token : tokens) {
            newTokenList.add(token);
        }
        return newTokenList;
    }

    private LoggingPreferences.Rule ruleByToken(IToken token) {
        int pos = this.rulePositionByToken(token);
        if (pos != -1) {
            return this.tempRules.get(pos);
        }
        return null;
    }

    private IToken tokenByRule(LoggingPreferences.Rule rule) {
        for (IToken token : this.getTokens()) {
            if (!token.getType().equals(rule.getName())) continue;
            return token;
        }
        return null;
    }

    private int rulePositionByToken(IToken token) {
        int i = 0;
        while (i < this.tempRules.size()) {
            LoggingPreferences.Rule rule = this.tempRules.get(i);
            if (rule.getName().equals(token.getType())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ColorizationStyle createStyle(String tokenName, RGB color, boolean bold, boolean italic, boolean underline) {
        ColorizationStyle style = new ColorizationStyle();
        style.setForegroundColor(UnifiedColorManager.getInstance().getColor(color));
        style.setName(String.valueOf(TokenTypes.DEFAULT_CATEGORY) + "_" + tokenName);
        style.setBold(bold);
        style.setItalic(italic);
        style.setUnderline(underline);
        return style;
    }

    private ColorizationStyle getStyleByToken(IToken token) {
        Category cat = this.getCategory(token.getCategory());
        if (cat == null) {
            return null;
        }
        return cat.getTokenStyle(token);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Category {
        private List<IToken> tokens;
        private Map<String, ColorizationStyle> styles;
        private String name;
        private ColorizationStyle style;

        public Category(String name) {
            this.name = name;
            this.tokens = new LinkedList<IToken>();
            this.styles = new HashMap<String, ColorizationStyle>();
            this.style = null;
        }

        public void setStyle(ColorizationStyle style) {
            this.style = style;
        }

        public ColorizationStyle getStyle() {
            return this.style;
        }

        public void addTokenStyle(IToken token, ColorizationStyle style) {
            if (token != null) {
                this.styles.put(LoggingStructureProvider.this.hashToken(token), style);
            }
        }

        public void removeTokenStyle(IToken token) {
            if (token != null) {
                this.styles.remove(LoggingStructureProvider.this.hashToken(token));
            }
        }

        public ColorizationStyle getTokenStyle(IToken token) {
            ColorizationStyle style = null;
            if (token != null) {
                style = this.styles.get(LoggingStructureProvider.this.hashToken(token));
            }
            return style;
        }

        public void addToken(IToken token) {
            if (!this.containsToken(token)) {
                this.tokens.add(token);
            }
        }

        public void addToken(IToken token, int pos) {
            if (!this.containsToken(token)) {
                this.tokens.add(pos, token);
            }
        }

        public int removeToken(IToken token) {
            Iterator<IToken> it = this.tokens.iterator();
            int i = 0;
            while (it.hasNext()) {
                if (LoggingStructureProvider.this.tokensEqual(it.next(), token)) {
                    it.remove();
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public IToken getToken(String hash) {
            for (IToken currentToken : this.tokens) {
                if (!LoggingStructureProvider.this.hashToken(currentToken).equals(hash)) continue;
                return currentToken;
            }
            return null;
        }

        public List<IToken> getTokens() {
            return this.tokens;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            String display = this.name.toLowerCase();
            display = String.valueOf(display.substring(0, 1).toUpperCase()) + display.substring(1, display.length());
            return display;
        }

        public Map getStyles() {
            return this.styles;
        }

        public void clear() {
            this.tokens.clear();
            this.styles.clear();
        }

        private boolean containsToken(IToken token) {
            for (IToken currentToken : this.tokens) {
                if (!LoggingStructureProvider.this.tokensEqual(currentToken, token)) continue;
                return true;
            }
            return false;
        }
    }
}

