/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.impl;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.logging.DefaultLogInfo;
import com.aptana.ide.logging.IDefaultLogProvider;
import com.aptana.ide.logging.LoggingPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLogsFactory {
    public static final String DEFAULT_LOG_POINT_ID = "com.aptana.ide.logging.defaultlog";
    public static final String LOG_ELEMENT = "log";
    public static final String PROVIDER_ATTRIBUTE = "provider";

    public static List<DefaultLogInfo> getLogURIs() {
        ArrayList<DefaultLogInfo> result = new ArrayList<DefaultLogInfo>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(DEFAULT_LOG_POINT_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (elementName.equals(LOG_ELEMENT)) {
                        try {
                            IDefaultLogProvider provider = (IDefaultLogProvider)element.createExecutableExtension(PROVIDER_ATTRIBUTE);
                            if (provider != null) {
                                result.addAll(provider.getLogs());
                            }
                        }
                        catch (Throwable e) {
                            IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)"Unable to load provider", (Throwable)e);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    private DefaultLogsFactory() {
    }
}

