/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.colorizer.ColorizerReader;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.coloring.TokenTypes;
import com.aptana.ide.logging.preferences.ILoggingPreferenceListener;
import com.aptana.ide.logging.preferences.LoggingStructureProvider;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingPreferences {
    public static final String COLORIZER_ID = "com.aptana.ide.logging.coloring.colorizer";
    private static final String BASE_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences";
    public static final String DEFAULT_RULES_POINT_ID = "com.aptana.ide.logging.defaultRules";
    private static final String LENGTH_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences_length";
    private static final String NAME_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences_name";
    private static final String CONTENT_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences_content";
    private static final String REGEXP_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences_isregexp";
    private static final String CASEINSENSITIVE_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences_iscasesensitive";
    private static final String AUTOBOLDING_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences_autobolding";
    private static final String WRAPPING_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences_wrapping";
    public static final String MAIN_TEXT_FONT_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences.maintextfont";
    public static final String CURSORLINE_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences.cursorline";
    public static final String CURSORLINE_COLOR_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences.cursorlinecolor";
    public static final String TEXT_COLOR_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences.textcolor";
    public static final String READ_TIMEOUT_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences.readtimeout";
    public static final String READ_BUFFER_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences.readbuffer";
    public static final String DEFAULT_ENCODING_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences.defaultencoding";
    private static final String BACKLOG_LINES_KEY = "com.aptana.ide.logging.preferences.LoggingPreferences.backloglines";
    private static final int WINDOWS_DEFAULT_FONT_SIZE = 9;
    private static final int MAC_OS_DEFAULT_FONT_SIZE = 10;
    private static final int LINUX_DEFAULT_FONT_SIZE = 10;
    private static final String DEFAULT_FONT_FAMILY = "Courier";
    private static final Object RULE_ELEMENT = "rule";
    private static final String NAME_ATTRIBVUTE = "name";
    private static final String CONTENT_ATTRIBUTE = "content";
    private static final String ISREGEXP_ATTRIBUTE = "regexp";
    private static final String ISCASEINSENSITIVE_ATTRIBUTE = "caseInsensitive";
    private static final String BOLD_ATTRIBUTE = "bold";
    private static final String ITALIC_ATTRIBUTE = "italic";
    private static final String UNDERLINE_ATTRIBUTE = "underline";
    private static final String COLOR_ATTRIBUTE = "color";
    private RulesList rules;
    private List<ILoggingPreferenceListener> listeners = new ArrayList<ILoggingPreferenceListener>();
    private List<ILoggingPreferenceListener> pendingToAddListeners = new ArrayList<ILoggingPreferenceListener>();
    private List<ILoggingPreferenceListener> pendingToRemoveListeners = new ArrayList<ILoggingPreferenceListener>();
    private Boolean autoBolding;
    private Boolean wrapping;
    private FontRegistry fontRegistry = new FontRegistry(Display.getCurrent());
    private boolean mainFontLoaded = false;
    private ColorRegistry colorRegistry = new ColorRegistry(Display.getCurrent());
    private Integer readTimeout;
    private Integer readBuffer;
    private String defaultEncoding;
    private Integer backLogLines;

    public List<Rule> getRules() {
        if (this.rules == null) {
            List<Rule> base = this.loadRules();
            this.rules = new RulesList(base);
        }
        return this.rules;
    }

    public void initializePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault(WRAPPING_KEY, false);
        store.setDefault(AUTOBOLDING_KEY, true);
        store.setDefault(CURSORLINE_KEY, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)CURSORLINE_COLOR_KEY, (RGB)new RGB(233, 233, 235));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)TEXT_COLOR_KEY, (RGB)new RGB(128, 128, 128));
        store.setDefault(READ_TIMEOUT_KEY, 100);
        store.setDefault(READ_BUFFER_KEY, 32768);
        store.setDefault(DEFAULT_ENCODING_KEY, "UTF-8");
        store.setDefault(BACKLOG_LINES_KEY, 750);
        this.initializeDefaultFont();
        if (store.getString(LENGTH_KEY).length() == 0) {
            this.initializeDefaultRules();
        }
    }

    public boolean getAutoBolding() {
        if (this.autoBolding == null) {
            this.loadAutoBolding();
        }
        return this.autoBolding;
    }

    public void setAutoBolding(boolean autobolding) {
        this.autoBolding = autobolding;
        this.saveAutoBolding();
    }

    public int getReadTimeout() {
        if (this.readTimeout == null) {
            this.loadReadTimeout();
        }
        return this.readTimeout;
    }

    public void setReadTimeout(int readtimeout) {
        this.readTimeout = readtimeout;
        this.saveReadTimeout();
    }

    public int getReadBuffer() {
        if (this.readBuffer == null) {
            this.loadReadBuffer();
        }
        return this.readBuffer;
    }

    public void setReadBuffer(int readbuffer) {
        this.readBuffer = readbuffer;
        this.saveReadBuffer();
    }

    public boolean getWrapping() {
        if (this.wrapping == null) {
            this.loadWrapping();
        }
        return this.wrapping;
    }

    public void setWrapping(boolean wrapping) {
        this.wrapping = wrapping;
        this.saveWrapping();
        this.notifyWrappingChanged(wrapping);
    }

    public int getBacklogLines() {
        if (this.backLogLines == null) {
            this.loadBacklogLines();
        }
        return this.backLogLines;
    }

    public void setBacklogLines(int lines) {
        this.backLogLines = lines;
        this.saveBacklogLines();
    }

    public void setCursorLineColor(RGB rgb) {
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)CURSORLINE_COLOR_KEY, (RGB)rgb);
    }

    public RGB getCursorLineColor() {
        return PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)CURSORLINE_COLOR_KEY);
    }

    public RGB getTextColorRGB() {
        RGB color = this.colorRegistry.getRGB(TEXT_COLOR_KEY);
        if (color == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)TEXT_COLOR_KEY);
            this.colorRegistry.put(TEXT_COLOR_KEY, rgb);
            color = this.colorRegistry.getRGB(TEXT_COLOR_KEY);
        }
        return color;
    }

    public Color getTextColor() {
        Color color = this.colorRegistry.get(TEXT_COLOR_KEY);
        if (color == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)TEXT_COLOR_KEY);
            this.colorRegistry.put(TEXT_COLOR_KEY, rgb);
            color = this.colorRegistry.get(TEXT_COLOR_KEY);
        }
        return color;
    }

    public void setTextColor(RGB rgb) {
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)TEXT_COLOR_KEY, (RGB)rgb);
        this.colorRegistry.put(TEXT_COLOR_KEY, rgb);
        this.notifyForegroundColorChanged(this.colorRegistry.get(TEXT_COLOR_KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontData[] getFontData() {
        FontRegistry fontRegistry = this.fontRegistry;
        synchronized (fontRegistry) {
            this.loadMainFont();
            return this.fontRegistry.getFontData(MAIN_TEXT_FONT_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont() {
        FontRegistry fontRegistry = this.fontRegistry;
        synchronized (fontRegistry) {
            this.loadMainFont();
            return this.fontRegistry.get(MAIN_TEXT_FONT_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFontData(FontData[] data) {
        FontRegistry fontRegistry = this.fontRegistry;
        synchronized (fontRegistry) {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)MAIN_TEXT_FONT_KEY, (FontData[])data);
            this.fontRegistry.put(MAIN_TEXT_FONT_KEY, data);
            this.notifyFontChanged(this.fontRegistry.get(MAIN_TEXT_FONT_KEY));
            this.mainFontLoaded = true;
        }
    }

    public boolean getDefaultAutoBolding() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getDefaultBoolean(AUTOBOLDING_KEY);
    }

    public int getDefaultBacklogLines() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getDefaultInt(BACKLOG_LINES_KEY);
    }

    public int getDefaultReadTimeout() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getDefaultInt(READ_TIMEOUT_KEY);
    }

    public int getDefaultReadBuffer() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getDefaultInt(READ_BUFFER_KEY);
    }

    public boolean getDefaultWrapping() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getDefaultBoolean(WRAPPING_KEY);
    }

    public RGB getDefaultCursorLineColor() {
        return PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)CURSORLINE_COLOR_KEY);
    }

    public RGB getDefaultTextColor() {
        return PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)TEXT_COLOR_KEY);
    }

    public FontData[] getDefaultFont() {
        return PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)MAIN_TEXT_FONT_KEY);
    }

    public String getDefaultDefaultEncoding() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getDefaultString(DEFAULT_ENCODING_KEY);
    }

    public void addPreferenceListener(ILoggingPreferenceListener listener) {
        this.pendingToAddListeners.add(listener);
    }

    public void removePreferenceListener(ILoggingPreferenceListener listener) {
        this.pendingToRemoveListeners.add(listener);
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        this.saveDefaultEncoding();
    }

    public String getDefaultEncoding() {
        if (this.defaultEncoding == null) {
            this.loadDefaultEncoding();
        }
        return this.defaultEncoding;
    }

    public static void createLanguageColorizer() {
        ColorizerReader reader = new ColorizerReader(TokenTypes.getTokenList());
        LanguageColorizer lc = reader.loadColorization(COLORIZER_ID, true);
        if (lc != null) {
            LanguageRegistry.registerLanguageColorizer((String)"text/log", (LanguageColorizer)lc);
        }
        if (lc == null) {
            lc = new LanguageColorizer("text/log");
            LanguageRegistry.registerLanguageColorizer((String)"text/log", (LanguageColorizer)lc);
            LanguageRegistry.setPreferenceId((String)"text/log", (String)COLORIZER_ID);
        }
    }

    public int getRegexpMaxLines() {
        return 1;
    }

    public void initializeDefaultRules() {
        LoggingPreferences.createLanguageColorizer();
        LoggingStructureProvider provider = new LoggingStructureProvider();
        this.fillDefaultRules(provider);
        provider.buildLanguageColorizer(LanguageRegistry.getLanguageColorizer((String)"text/log"), COLORIZER_ID);
        provider.applyChanges();
    }

    private List<Rule> loadRules() {
        IPreferenceStore store = this.getPreferenceStore();
        int length = store.getInt(LENGTH_KEY);
        ArrayList<Rule> result = new ArrayList<Rule>();
        int i = 0;
        while (i < length) {
            String ruleName = store.getString(NAME_KEY + i);
            String ruleContent = store.getString(CONTENT_KEY + i);
            Boolean ruleIsRegexp = store.getBoolean(REGEXP_KEY + i);
            Boolean isCaseInsensitive = store.getBoolean(CASEINSENSITIVE_KEY + i);
            Rule rule = new Rule(ruleName, ruleContent, ruleIsRegexp, isCaseInsensitive);
            result.add(rule);
            ++i;
        }
        return result;
    }

    private void saveRules(List<Rule> rules) {
        this.clearList();
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(LENGTH_KEY, rules.size());
        int i = 0;
        while (i < rules.size()) {
            Rule rule = rules.get(i);
            store.setValue(NAME_KEY + i, rule.getName());
            store.setValue(CONTENT_KEY + i, rule.getRule());
            store.setValue(REGEXP_KEY + i, rule.isRegexp());
            store.setValue(CASEINSENSITIVE_KEY + i, rule.isCaseInsensitive());
            ++i;
        }
    }

    private void clearList() {
        IPreferenceStore store = this.getPreferenceStore();
        int length = store.getDefaultInt(LENGTH_KEY);
        int i = 0;
        while (i < length) {
            store.setValue(NAME_KEY + i, "");
            store.setValue(CONTENT_KEY + i, "");
            store.setValue(REGEXP_KEY + i, false);
            store.setValue(CASEINSENSITIVE_KEY + i, false);
            ++i;
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return LoggingPlugin.getDefault().getPreferenceStore();
    }

    private void notifyRulesChanged() {
        for (ILoggingPreferenceListener listener : this.getListeners()) {
            listener.rulesChanged();
        }
    }

    private void notifyWrappingChanged(boolean wrapping) {
        for (ILoggingPreferenceListener listener : this.getListeners()) {
            listener.wrappingChanged(wrapping);
        }
    }

    private void notifyFontChanged(Font font) {
        for (ILoggingPreferenceListener listener : this.getListeners()) {
            listener.fontChanged(font);
        }
    }

    private void notifyForegroundColorChanged(Color color) {
        for (ILoggingPreferenceListener listener : this.getListeners()) {
            listener.textForegroundColorChanged(color);
        }
    }

    private List<ILoggingPreferenceListener> getListeners() {
        this.listeners.addAll(this.pendingToAddListeners);
        this.listeners.removeAll(this.pendingToRemoveListeners);
        this.pendingToAddListeners.clear();
        this.pendingToRemoveListeners.clear();
        return this.listeners;
    }

    private void saveAutoBolding() {
        if (this.autoBolding != null) {
            IPreferenceStore store = this.getPreferenceStore();
            store.setValue(AUTOBOLDING_KEY, this.autoBolding.booleanValue());
        }
    }

    private void loadAutoBolding() {
        IPreferenceStore store = this.getPreferenceStore();
        this.autoBolding = store.getBoolean(AUTOBOLDING_KEY);
    }

    private void saveReadTimeout() {
        if (this.readTimeout != null) {
            IPreferenceStore store = this.getPreferenceStore();
            store.setValue(READ_TIMEOUT_KEY, this.readTimeout.intValue());
        }
    }

    private void loadReadTimeout() {
        IPreferenceStore store = this.getPreferenceStore();
        this.readTimeout = store.getInt(READ_TIMEOUT_KEY);
    }

    private void saveReadBuffer() {
        if (this.readBuffer != null) {
            IPreferenceStore store = this.getPreferenceStore();
            store.setValue(READ_BUFFER_KEY, this.readBuffer.intValue());
        }
    }

    private void loadReadBuffer() {
        IPreferenceStore store = this.getPreferenceStore();
        this.readBuffer = store.getInt(READ_BUFFER_KEY);
    }

    private void saveWrapping() {
        if (this.wrapping != null) {
            IPreferenceStore store = this.getPreferenceStore();
            store.setValue(WRAPPING_KEY, this.wrapping.booleanValue());
        }
    }

    private void loadWrapping() {
        IPreferenceStore store = this.getPreferenceStore();
        this.wrapping = store.getBoolean(WRAPPING_KEY);
    }

    private void saveDefaultEncoding() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(DEFAULT_ENCODING_KEY, this.defaultEncoding);
    }

    private void loadDefaultEncoding() {
        IPreferenceStore store = this.getPreferenceStore();
        this.defaultEncoding = store.getString(DEFAULT_ENCODING_KEY);
    }

    private void saveBacklogLines() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(BACKLOG_LINES_KEY, this.backLogLines.intValue());
    }

    private void loadBacklogLines() {
        IPreferenceStore store = this.getPreferenceStore();
        this.backLogLines = store.getInt(BACKLOG_LINES_KEY);
    }

    public void fillDefaultRules(LoggingStructureProvider provider) {
        this.loadRulesFromExtensions(provider);
    }

    private void loadRulesFromExtensions(LoggingStructureProvider provider) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(DEFAULT_RULES_POINT_ID);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (elementName.equals(RULE_ELEMENT)) {
                        String name = element.getAttribute(NAME_ATTRIBVUTE);
                        String content = element.getAttribute(CONTENT_ATTRIBUTE);
                        boolean isRegexp = this.getBooleanAttribute(element, ISREGEXP_ATTRIBUTE, true);
                        boolean isCaseSensitive = this.getBooleanAttribute(element, ISCASEINSENSITIVE_ATTRIBUTE, false);
                        boolean isBold = this.getBooleanAttribute(element, BOLD_ATTRIBUTE, false);
                        boolean isItalic = this.getBooleanAttribute(element, ITALIC_ATTRIBUTE, false);
                        boolean isUnderline = this.getBooleanAttribute(element, UNDERLINE_ATTRIBUTE, false);
                        String colorString = element.getAttribute(COLOR_ATTRIBUTE);
                        RGB color = new RGB(0, 0, 0);
                        try {
                            color = this.getRGB(colorString);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)("Wrong default rule color format: " + colorString));
                        }
                        provider.addRule(name, content, isRegexp, isCaseSensitive, color, isBold, isItalic, isUnderline);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private RGB getRGB(String colorString) throws IllegalArgumentException {
        if (colorString == null) {
            throw new IllegalArgumentException("Null is not a valid RGB");
        }
        StringTokenizer tokenizer = new StringTokenizer(colorString, ",");
        try {
            String red = tokenizer.nextToken().trim();
            String green = tokenizer.nextToken().trim();
            String blue = tokenizer.nextToken().trim();
            int rval = 0;
            int gval = 0;
            int bval = 0;
            rval = Integer.parseInt(red);
            gval = Integer.parseInt(green);
            bval = Integer.parseInt(blue);
            return new RGB(rval, gval, bval);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void initializeDefaultFont() {
        Font defaultFont = JFaceResources.getDefaultFont();
        FontData[] data = defaultFont.getFontData();
        String osName = System.getProperty("os.name", "Windows");
        int height = data[0].getHeight();
        if (data != null && data.length > 0) {
            if (osName.startsWith("Windows")) {
                height = 9;
            } else if (osName.startsWith("Linux")) {
                height = 10;
            } else if (osName.startsWith("Mac OS")) {
                height = 10;
            }
        }
        data[0].setHeight(height);
        if (this.supports(DEFAULT_FONT_FAMILY, height)) {
            data[0].setName(DEFAULT_FONT_FAMILY);
        }
        PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)MAIN_TEXT_FONT_KEY, (FontData[])data);
    }

    private boolean supports(String name, int height) {
        try {
            Font font = new Font((Device)Display.getCurrent(), name, height, 0);
            font.dispose();
            return true;
        }
        catch (SWTError sWTError) {
            return false;
        }
    }

    private boolean getBooleanAttribute(IConfigurationElement element, String name, boolean defaultValue) {
        String attributeString = element.getAttribute(name);
        if (attributeString == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(attributeString);
    }

    private void loadMainFont() {
        if (!this.mainFontLoaded) {
            FontData[] data = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)MAIN_TEXT_FONT_KEY);
            this.fontRegistry.put(MAIN_TEXT_FONT_KEY, data);
            this.mainFontLoaded = true;
        }
    }

    LoggingPreferences() {
    }

    public static class Rule {
        private String name;
        private String rule;
        private boolean isRegexp;
        private boolean isCaseInsensitive;

        public Rule(String name, String rule, boolean isRegexp, boolean isCaseInsensitive) {
            this.name = name;
            this.rule = rule;
            this.isRegexp = isRegexp;
            this.isCaseInsensitive = isCaseInsensitive;
        }

        public String getName() {
            return this.name;
        }

        public String getRule() {
            return this.rule;
        }

        public boolean isRegexp() {
            return this.isRegexp;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }

        public boolean isCaseInsensitive() {
            return this.isCaseInsensitive;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Rule other = (Rule)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RulesList
    extends AbstractList<Rule> {
        private List<Rule> base;

        public RulesList(List<Rule> base) {
            this.base = base;
        }

        @Override
        public Rule get(int index) {
            return this.base.get(index);
        }

        @Override
        public int size() {
            return this.base.size();
        }

        @Override
        public void add(int index, Rule element) {
            if (this.base.contains(element)) {
                return;
            }
            this.base.add(index, element);
            LoggingPreferences.this.saveRules(this.base);
            LoggingPreferences.this.notifyRulesChanged();
        }

        @Override
        public Rule remove(int index) {
            Rule toReturn = this.base.remove(index);
            LoggingPreferences.this.saveRules(this.base);
            LoggingPreferences.this.notifyRulesChanged();
            return toReturn;
        }

        @Override
        public void clear() {
            this.base.clear();
            LoggingPreferences.this.saveRules(this.base);
            LoggingPreferences.this.notifyRulesChanged();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Rule> c) {
            boolean added = this.base.addAll(index, c);
            LoggingPreferences.this.saveRules(this.base);
            return added;
        }
    }
}

