/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.javacloud.util;

import com.aptana.ide.server.javacloud.util.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class WarHelper {
    private static final String FORWRADSLASH = "/";
    private static final String BACKSLASH = "\\";
    private String webContentPath;
    private String classesPath;
    private String contextName;

    public WarHelper(String webContentPath, String classesPath, String contextName) {
        this.webContentPath = webContentPath;
        this.classesPath = classesPath;
        this.contextName = contextName;
    }

    public void create(File archiveFile, File projectRoot) throws IOException, SAXException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        FileOutputStream stream = new FileOutputStream(archiveFile);
        JarOutputStream out = new JarOutputStream(stream);
        File webContentFiles = new File(projectRoot + FORWRADSLASH + this.webContentPath);
        String stripPath = webContentFiles.getCanonicalPath();
        if (stripPath.contains(BACKSLASH)) {
            stripPath = stripPath.replaceAll(Pattern.quote(BACKSLASH), FORWRADSLASH);
        }
        this.addJarEntry(out, "", stripPath, webContentFiles, this.contextName);
        File classFiles = new File(projectRoot + FORWRADSLASH + this.classesPath);
        stripPath = classFiles.getCanonicalPath();
        if (stripPath.contains(BACKSLASH)) {
            stripPath = stripPath.replaceAll(Pattern.quote(BACKSLASH), FORWRADSLASH);
        }
        this.addJarEntry(out, "WEB-INF/classes/", stripPath, classFiles, this.contextName);
        out.close();
        stream.close();
    }

    private void addJarEntry(JarOutputStream out, String entryRootPath, String stripPath, File file, String contextName) throws IOException, SAXException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        String entryPath;
        if (file.getName().equals(".DS_Store")) {
            return;
        }
        String path = file.getAbsolutePath();
        if (path.contains(BACKSLASH)) {
            path = path.replaceAll(Pattern.quote(BACKSLASH), FORWRADSLASH);
        }
        if (path.contains("WEB-INF/web.xml")) {
            Document doc = this.parseXmlFile(file, contextName);
            file = File.createTempFile("xyz", "xml");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, result);
        }
        String subPath = path.replaceFirst(stripPath, "");
        System.out.println(subPath);
        if (subPath.startsWith(FORWRADSLASH)) {
            subPath = subPath.substring(1);
        }
        if (!(entryPath = String.valueOf(entryRootPath) + subPath).trim().equals("")) {
            if (file.isDirectory()) {
                entryPath = String.valueOf(entryPath) + FORWRADSLASH;
            }
            JarEntry jarAdd = new JarEntry(entryPath);
            jarAdd.setTime(file.lastModified());
            out.putNextEntry(jarAdd);
        }
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File child = fileArray[n];
                this.addJarEntry(out, entryRootPath, stripPath, child, contextName);
                ++n;
            }
        } else if (!entryPath.trim().equals("")) {
            this.writeToArchive(out, file);
        }
    }

    public Document parseXmlFile(File file, String contextName) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().parse(file);
        NodeList displayNameNodes = doc.getDocumentElement().getElementsByTagName(Messages.getString("WarHelper.12"));
        int i = 0;
        while (i < displayNameNodes.getLength()) {
            Node child;
            Node node = displayNameNodes.item(i);
            if (node.getParentNode().getNodeName().equals("web-app") && node.hasChildNodes() && (child = node.getFirstChild()).getNodeType() == 3) {
                node.removeChild(child);
                Text newChild = doc.createTextNode(contextName);
                node.appendChild(newChild);
            }
            ++i;
        }
        return doc;
    }

    private void writeToArchive(JarOutputStream out, File file) throws IOException {
        int nRead;
        int BUFFER_SIZE = 10240;
        byte[] buffer = new byte[BUFFER_SIZE];
        FileInputStream in = new FileInputStream(file);
        while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, nRead);
        }
        out.flush();
        in.close();
    }

    public static void main(String[] args) {
        String webContentPath = "WebContent";
        String classesPath = "build/classes";
        File archiveFile = new File("/users/winston/carstore1.war");
        File projectRoot = new File("/Users/winston/Eclipse Workspaces/runtime-IDE 1.2.2/carstore");
        WarHelper warCreator = new WarHelper(webContentPath, classesPath, "public");
        try {
            warCreator.create(archiveFile, projectRoot);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

