/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.ui.filesystem;

import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.search.Messages;
import com.aptana.ide.search.epl.Activator;
import com.aptana.ide.search.epl.AptanaFileSystemMatch;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemReplaceAction2;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemSearchPage;
import com.aptana.ide.search.ui.filesystem.AptanaExtraDecorator;
import com.aptana.ide.search.ui.filesystem.MatchesContentProvider;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.util.PixelConverter;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.search2.internal.ui.basic.views.SetLayoutAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.IPageSite;

public class AptanaFileSystemSearchPage
extends FileSystemSearchPage {
    static final Object[] NO_ELEMENTS = new Object[0];
    static final Match[] NO_MATCH = new Match[0];
    private static final int LAYOUT_MATCHES = 4;
    ITreeContentProvider provider;
    boolean turnOff;
    public static final int SHOW_LABEL = 1;
    public static final int SHOW_LABEL_PATH = 2;
    public static final int SHOW_PATH_LABEL = 3;
    private int fOrder = 2;
    private SetLayoutAction fFlatAction = new SetLayoutAction((AbstractTextSearchViewPage)this, Messages.AptanaFileSearchPage_ShowMatches, Messages.AptanaFileSearchPage_ShowMatchesTooltip, 4);
    int layout;
    private static final String KEY_LAYOUT = "org.eclipse.search.resultpage.layout";
    private static final String KEY_SORTING = "org.eclipse.search.resultpage.sorting";
    private MatchesContentProvider structuredContentProvider;
    private Listener listener;
    private Listener listener1;
    PixelConverter metrics;
    private LabelProvider baseLabelProvider;

    protected void fillContextMenu(IMenuManager mgr) {
        FileSystemReplaceAction2 replaceAll;
        super.fillContextMenu(mgr);
        FileSystemReplaceAction2 replaceAction = new FileSystemReplaceAction2((FileSystemSearchPage)this, (IStructuredSelection)this.getViewer().getSelection());
        if (replaceAction.isEnabled()) {
            mgr.appendToGroup("group.reorganize", (IAction)replaceAction);
        }
        if ((replaceAll = new FileSystemReplaceAction2((FileSystemSearchPage)this)).isEnabled()) {
            mgr.appendToGroup("group.reorganize", (IAction)replaceAll);
        }
        if (this.layout == 4) {
            Separator find = (Separator)mgr.find("group.viewerSetup");
            IContributionItem[] items = find.getParent().getItems();
            int indexOf = Arrays.asList(items).indexOf(find);
            MenuManager contributionItem = (MenuManager)items[indexOf + 1];
            IContributionItem[] items2 = contributionItem.getItems();
            ActionContributionItem it0 = (ActionContributionItem)items2[0];
            ActionContributionItem it1 = (ActionContributionItem)items2[1];
            it0.getAction().setChecked(this.fOrder == 2);
            it1.getAction().setChecked(this.fOrder == 3);
        }
    }

    public String getLabel() {
        if (this.layout == 4) {
            AbstractTextSearchResult input = this.getInput();
            if (input != null) {
                int matchCount;
                String label = input.getLabel();
                TableViewer viewer = (TableViewer)this.getViewer();
                int itemCount = viewer.getTable().getItemCount();
                if (itemCount < (matchCount = input.getMatchCount())) {
                    return org.eclipse.search.internal.ui.Messages.format((String)Messages.AptanaFileSearchPage_NOT_ALL_MATCHES, (Object[])new Object[]{label, new Integer(itemCount), new Integer(matchCount)});
                }
            } else {
                return "";
            }
        }
        return super.getLabel();
    }

    public void init(IPageSite site) {
        super.init(site);
        site.getActionBars().getMenuManager().appendToGroup("group.viewerSetup", (IAction)this.fFlatAction);
    }

    public AptanaFileSystemSearchPage() {
        this.fFlatAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.aptana.ide.search.epl", (String)"/icons/verticalOrientation.gif"));
    }

    public void setSortOrder(int sortOrder) {
        if (this.layout == 4) {
            this.fOrder = sortOrder;
            this.getSettings().put(KEY_SORTING, sortOrder);
            this.getViewer().refresh();
            return;
        }
        super.setSortOrder(sortOrder);
    }

    public void restoreState(IMemento memento) {
        Integer value;
        Integer l;
        try {
            this.layout = this.getSettings().getInt(KEY_LAYOUT);
        }
        catch (NumberFormatException numberFormatException) {
            this.layout = 2;
        }
        if (this.layout == 4) {
            this.getSettings().put(KEY_LAYOUT, 1);
        }
        if (memento != null && (l = memento.getInteger(KEY_LAYOUT)) != null) {
            this.layout = l;
            if (this.layout == 4) {
                memento.putInteger(KEY_LAYOUT, 1);
            }
        }
        super.restoreState(memento);
        try {
            this.fOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {
            this.fOrder = 2;
        }
        if (memento != null && (value = memento.getInteger(KEY_SORTING)) != null) {
            this.fOrder = value;
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.layout == 4) {
            this.layout = 1;
            this.setLayout(4);
        }
    }

    public void saveState(IMemento memento) {
        memento.putInteger(KEY_LAYOUT, this.layout);
    }

    public void setLayout(int layout) {
        if (this.layout == layout) {
            return;
        }
        if (layout == 4) {
            this.getControl().setRedraw(false);
            if (this.getLayout() != 1) {
                super.setLayout(1);
            }
            this.layout = layout;
            this.reconfigureTableViewer();
            this.getControl().setRedraw(true);
            ((Composite)this.getControl()).layout(true, true);
            this.getControl().redraw();
            Separator find = (Separator)this.getSite().getActionBars().getMenuManager().find("group.viewerSetup");
            IContributionItem[] items = find.getParent().getItems();
            int indexOf = Arrays.asList(items).indexOf(find);
            SubContributionItem contributionItem = (SubContributionItem)items[indexOf + 1];
            ActionContributionItem ac = (ActionContributionItem)contributionItem.getInnerItem();
            ac.getAction().setChecked(false);
            contributionItem = (SubContributionItem)items[indexOf + 3];
            ac = (ActionContributionItem)contributionItem.getInnerItem();
            ac.getAction().setChecked(true);
            this.getSettings().put(KEY_LAYOUT, layout);
        } else {
            if (this.layout == 4) {
                this.layout = layout;
                if (layout == 1) {
                    this.getControl().setRedraw(false);
                    super.setLayout(2);
                    super.setLayout(1);
                    ((Composite)this.getControl()).layout(true, true);
                    this.getControl().setRedraw(true);
                    return;
                }
            }
            this.layout = layout;
            super.setLayout(layout);
        }
    }

    public Match getCurrentMatch() {
        if (this.layout == 4) {
            StackTraceElement[] stackTrace = new Exception().getStackTrace();
            String methodName = stackTrace[1].getMethodName();
            if (methodName.equals("gotoNextMatch")) {
                return null;
            }
            if (methodName.equals("gotoPreviousMatch")) {
                return null;
            }
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            Object element = selection.getFirstElement();
            return (Match)element;
        }
        return super.getCurrentMatch();
    }

    public void internalRemoveSelected() {
        if (this.layout != 4) {
            super.internalRemoveSelected();
        } else {
            TableViewer cc = (TableViewer)this.getViewer();
            StructuredSelection ss = (StructuredSelection)cc.getSelection();
            List list = ss.toList();
            Match[] ms = new Match[list.size()];
            list.toArray(ms);
            this.getInput().removeMatches(ms);
            this.getViewPart().updateLabel();
        }
    }

    protected void handleSearchResultChanged(SearchResultEvent e) {
        if (this.layout != 4) {
            super.handleSearchResultChanged(e);
            return;
        }
        if (e instanceof MatchEvent) {
            MatchEvent me = (MatchEvent)e;
            int kind = me.getKind();
            if (Display.getCurrent() != null && kind == 2) {
                TableViewer cc = (TableViewer)this.getViewer();
                Table table = cc.getTable();
                int selectionIndex = table.getSelectionIndex();
                cc.refresh();
                if (selectionIndex != -1 && selectionIndex < table.getItemCount()) {
                    TableItem item = cc.getTable().getItem(selectionIndex);
                    cc.setSelection((ISelection)new StructuredSelection(item.getData()));
                }
            } else {
                super.handleSearchResultChanged(e);
            }
        } else if (e instanceof RemoveAllEvent) {
            super.handleSearchResultChanged(e);
        }
    }

    private void reconfigureTableViewer() {
        TableViewer tViewer = (TableViewer)this.getViewer();
        TableColumn[] columns = tViewer.getTable().getColumns();
        int a = 0;
        while (a < columns.length) {
            columns[a].dispose();
            ++a;
        }
        this.metrics = new PixelConverter(tViewer.getControl());
        tViewer.getTable().setHeaderVisible(true);
        TableColumn clmn = new TableColumn(tViewer.getTable(), 16384);
        clmn.setText(Messages.AptanaFileSearchPage_File);
        TableColumn clmn1 = new TableColumn(tViewer.getTable(), 16384);
        clmn1.setText(Messages.AptanaFileSearchPage_Line);
        TableColumn clmn2 = new TableColumn(tViewer.getTable(), 16384);
        clmn2.setText(Messages.AptanaFileSearchPage_Source);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(50));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        PreferenceUtils.persist((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (Table)tViewer.getTable(), (String)"tviewer");
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                AptanaFileSystemMatch aptanaFileMatch;
                if (event.index == 2 && (aptanaFileMatch = (AptanaFileSystemMatch)event.item.getData()) != null) {
                    event.gc.drawText(aptanaFileMatch.getLineContent(), event.x, event.y);
                }
            }
        };
        this.listener1 = new Listener(){

            public void handleEvent(Event event) {
                AptanaFileSystemMatch aptanaFileMatch;
                if (event.index == 2 && (aptanaFileMatch = (AptanaFileSystemMatch)event.item.getData()) != null) {
                    event.width = AptanaFileSystemSearchPage.this.metrics.convertWidthInCharsToPixels(aptanaFileMatch.getLineContent().length());
                }
            }
        };
        tViewer.getTable().addListener(42, this.listener);
        tViewer.getTable().setLayout((Layout)tableLayout);
        this.baseLabelProvider = (LabelProvider)tViewer.getLabelProvider();
        tViewer.setInput(null);
        tViewer.setLabelProvider((IBaseLabelProvider)new MatchesTableLabelProvider());
        IContentProvider contentProvider = tViewer.getContentProvider();
        this.structuredContentProvider = new MatchesContentProvider(this, contentProvider);
        tViewer.setContentProvider((IContentProvider)this.structuredContentProvider);
        tViewer.setInput((Object)this.getInput());
        tViewer.getTable().getParent().layout(true);
    }

    protected void clear() {
        StructuredViewer viewer = this.getViewer();
        if (this.layout == 4) {
            viewer.getControl().setRedraw(false);
            viewer.getControl().removeListener(42, this.listener);
            viewer.getControl().removeListener(41, this.listener1);
            super.clear();
            viewer.getControl().setRedraw(true);
            viewer.getControl().addListener(42, this.listener);
            viewer.getControl().addListener(41, this.listener1);
        } else {
            super.clear();
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.layout != 4) {
            super.elementsChanged(objects);
        } else {
            this.structuredContentProvider.elementsChanged(objects);
        }
    }

    protected void configureTableViewer(TableViewer viewer) {
        super.configureTableViewer(viewer);
    }

    public void setInput(ISearchResult newSearch, Object viewState) {
        super.setInput(newSearch, viewState);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        super.configureTreeViewer(viewer);
        final DecoratingLabelProvider labelProvider = (DecoratingLabelProvider)viewer.getLabelProvider();
        DecoratingLabelProvider decoratingLabelProvider = new DecoratingLabelProvider((ILabelProvider)labelProvider, new AptanaExtraDecorator(this)){

            public void setLabelDecorator(ILabelDecorator decorator) {
                if (decorator != null) {
                    AptanaFileSystemSearchPage.this.turnOff = true;
                }
                labelProvider.setLabelDecorator(decorator);
                AptanaFileSystemSearchPage.this.turnOff = false;
            }
        };
        this.provider = (ITreeContentProvider)viewer.getContentProvider();
        viewer.setLabelProvider((IBaseLabelProvider)decoratingLabelProvider);
    }

    private final class MatchesTableLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private WorkbenchLabelProvider fLabelProvider = new WorkbenchLabelProvider();
        private String[] fArgs = new String[2];
        private static final String fgSeparatorFormat = "{0} - {1}";

        private MatchesTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return AptanaFileSystemSearchPage.this.baseLabelProvider.getImage(((Match)element).getElement());
            }
            return null;
        }

        public String getText(File resource) {
            String text;
            if (!resource.exists()) {
                text = SearchMessages.FileLabelProvider_removed_resource_label;
            } else {
                IPath path = new Path(resource.getAbsolutePath()).removeLastSegments(1);
                if (path.getDevice() == null) {
                    path = path.makeRelative();
                }
                if (AptanaFileSystemSearchPage.this.fOrder == 1 || AptanaFileSystemSearchPage.this.fOrder == 2) {
                    text = this.fLabelProvider.getText((Object)resource);
                    if (path != null && AptanaFileSystemSearchPage.this.fOrder == 2) {
                        this.fArgs[0] = resource.getName();
                        this.fArgs[1] = path.toString();
                        text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                    }
                } else {
                    text = path != null ? path.toString() : "";
                    if (AptanaFileSystemSearchPage.this.fOrder == 3) {
                        this.fArgs[0] = text;
                        this.fArgs[1] = resource.getName();
                        text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                    }
                }
            }
            return text;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof File) {
                return "";
            }
            AptanaFileSystemMatch match = (AptanaFileSystemMatch)element;
            if (columnIndex == 0) {
                return this.getText(match.getFile());
            }
            if (columnIndex == 1) {
                return Integer.toString(match.getLineNumber());
            }
            if (columnIndex == 2) {
                return "";
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
            AptanaFileSystemSearchPage.this.baseLabelProvider.addListener(listener);
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return AptanaFileSystemSearchPage.this.baseLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            AptanaFileSystemSearchPage.this.baseLabelProvider.removeListener(listener);
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            StringBuilder bld = new StringBuilder();
            bld.append(this.getColumnText(element, 0));
            bld.append('\t');
            bld.append(this.getColumnText(element, 1));
            bld.append('\t');
            bld.append(((AptanaFileSystemMatch)element).getLineContent());
            return bld.toString();
        }
    }
}

