/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.editors.preferences.formatter;

import com.aptana.ide.editors.codeassist.Activator;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterMessages;
import com.aptana.ide.ui.editors.preferences.formatter.ModifyDialogTabPage;
import com.aptana.ide.ui.editors.preferences.formatter.Preview;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormatterTabPage
extends ModifyDialogTabPage {
    private static final String SHOW_INVISIBLE_PREFERENCE_KEY = "com.aptana.ide.editors.codeassist.formatter_page.show_invisible_characters";
    private Preview fPreview;
    private final IDialogSettings fDialogSettings = Activator.getDefault().getDialogSettings();
    private Button fShowInvisibleButton;

    public FormatterTabPage(ModifyDialogTabPage.IModificationListener modifyListener, Map<String, String> workingValues) {
        super(modifyListener, workingValues);
    }

    @Override
    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        FormatterTabPage.createLabel(numColumns - 1, composite, FormatterMessages.ModifyDialogTabPage_preview_label_text);
        this.fShowInvisibleButton = new Button(composite, 32);
        this.fShowInvisibleButton.setText(FormatterMessages.FormatterTabPage_ShowInvisibleCharacters_label);
        this.fShowInvisibleButton.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.fShowInvisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatterTabPage.this.fPreview.showInvisibleCharacters(FormatterTabPage.this.fShowInvisibleButton.getSelection());
                FormatterTabPage.this.fDialogSettings.put(FormatterTabPage.SHOW_INVISIBLE_PREFERENCE_KEY, FormatterTabPage.this.fShowInvisibleButton.getSelection());
                FormatterTabPage.this.doUpdatePreview();
            }
        });
        this.fShowInvisibleButton.setSelection(this.isShowInvisible());
        this.fPreview = this.doCreateJavaPreview(composite);
        this.fDefaultFocusManager.add(this.fPreview.getControl());
        this.fPreview.showInvisibleCharacters(this.fShowInvisibleButton.getSelection());
        GridData gd = FormatterTabPage.createGridData(numColumns, 1808, 0);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fPreview.getControl().setLayoutData((Object)gd);
        return composite;
    }

    private boolean isShowInvisible() {
        return this.fDialogSettings.getBoolean(SHOW_INVISIBLE_PREFERENCE_KEY);
    }

    @Override
    protected void doUpdatePreview() {
        boolean showInvisible = this.isShowInvisible();
        this.fPreview.showInvisibleCharacters(showInvisible);
        this.fShowInvisibleButton.setSelection(showInvisible);
    }
}

