/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.contentassist;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.unified.contentassist.Messages;
import java.util.ArrayList;

public class CodeAssistExpression {
    private String _expression;
    private String _xPath;
    private String _context;
    public static String FIELD_SEPARATOR = "~~~~";
    public static String DESCRIPTOR_SEPARATOR = "####";

    public String getExpression() {
        return this._expression;
    }

    public String getXPath() {
        return this._xPath;
    }

    public String getContext() {
        return this._context;
    }

    public void setExpression(String expression) {
        this._expression = expression;
    }

    public void setXPath(String xPath) {
        this._xPath = xPath;
    }

    public void setContext(String context) {
        this._context = context;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getContext() != null) {
            sb.append(this.getContext());
        }
        sb.append(FIELD_SEPARATOR);
        if (this.getExpression() != null) {
            sb.append(this.getExpression());
        }
        sb.append(FIELD_SEPARATOR);
        sb.append(this.getXPath());
        return sb.toString();
    }

    public void fromString(String values) {
        String[] vals = values.split(FIELD_SEPARATOR, 3);
        if (vals.length != 3) {
            throw new IllegalArgumentException(Messages.CodeAssistExpression_MustHaveThreeValues);
        }
        if (!"".equals(vals[0])) {
            this._context = vals[0];
        }
        if (!"".equals(vals[1])) {
            this._expression = vals[1];
        }
        if (!"".equals(vals[2])) {
            this._xPath = vals[2];
        }
    }

    public static String serializeErrorDescriptors(CodeAssistExpression[] expressions) {
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        while (i < expressions.length) {
            CodeAssistExpression descriptor = expressions[i];
            al.add(descriptor.toString());
            ++i;
        }
        return StringUtils.join((String)DESCRIPTOR_SEPARATOR, (String[])al.toArray(new String[0]));
    }

    public static CodeAssistExpression[] deserializeErrorDescriptors(String expressions) {
        if (expressions == null || "".equals(expressions)) {
            return new CodeAssistExpression[0];
        }
        ArrayList<CodeAssistExpression> al = new ArrayList<CodeAssistExpression>();
        String[] errorDescriptors = expressions.split(DESCRIPTOR_SEPARATOR);
        int i = 0;
        while (i < errorDescriptors.length) {
            String descriptor = errorDescriptors[i];
            CodeAssistExpression ed = new CodeAssistExpression();
            ed.fromString(descriptor);
            al.add(ed);
            ++i;
        }
        return al.toArray(new CodeAssistExpression[0]);
    }

    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 instanceof CodeAssistExpression) {
            CodeAssistExpression s = (CodeAssistExpression)arg0;
            result = this.toString().equals(s.toString());
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

