/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager.postinstall;

import artofillusion.ModellingApp;
import artofillusion.Plugin;
import artofillusion.spmanager.SPMTranslate;
import buoy.widget.BLabel;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextArea;
import buoy.widget.Widget;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class PostInstall
implements Plugin {
    protected ArrayList ok;
    protected ArrayList err;
    protected static File tempDir = null;
    private static final String okMsg = "SPManager PostInstall: One or more scripts or plugins has be updated.";
    private static final String restartMsg = "You should exit ArtOfIllusion and restart.";
    private static final String errMsg = "SPManager PostInstall: One or more scripts or plugins could not be updated.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(int msg, Object[] args) {
        switch (msg) {
            case 0: {
                try {
                    SPMTranslate.setLocale(ModellingApp.getPreferences().getLocale());
                    if (tempDir == null) {
                        tempDir = new File(System.getProperty("java.io.tmpdir"), "SPManager");
                    }
                    if (!tempDir.exists()) {
                        tempDir = new File(ModellingApp.APP_DIRECTORY, "temp");
                    }
                    if (!tempDir.exists()) {
                        tempDir = new File(System.getProperty("user.dir"), "SPMtemp");
                    }
                    if (!tempDir.exists()) {
                        System.out.println("PostInstall:temp dir does not exist - exiting");
                        return;
                    }
                    this.ok = new ArrayList(128);
                    this.err = new ArrayList(128);
                    PostInstall.cleanup(ModellingApp.PLUGIN_DIRECTORY, this.ok, this.err);
                    PostInstall.cleanup(ModellingApp.TOOL_SCRIPT_DIRECTORY, this.ok, this.err);
                    PostInstall.cleanup(ModellingApp.OBJECT_SCRIPT_DIRECTORY, this.ok, this.err);
                    PostInstall.cleanup(ModellingApp.STARTUP_SCRIPT_DIRECTORY, this.ok, this.err);
                }
                catch (Exception e) {
                    System.out.println("PostInstall: exception raised - aborting: " + e.toString());
                    this.err.add("Exception raised - aborting: " + e.toString());
                }
                break;
            }
            case 2: {
                try {
                    BLabel messg;
                    BScrollPane detail;
                    int i;
                    BTextArea txt;
                    if (this.err != null && this.err.size() > 0) {
                        txt = new BTextArea(5, 45);
                        txt.setEditable(false);
                        for (i = 0; i < this.err.size(); ++i) {
                            txt.append(this.err.get(i) + "\n");
                        }
                        detail = new BScrollPane((Widget)txt, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
                        messg = SPMTranslate.bLabel("errMsg");
                        new BStandardDialog("PostInstall", (Object)new Widget[]{messg, detail}, BStandardDialog.WARNING).showMessageDialog(null);
                    }
                    if (this.ok == null || this.ok.size() <= 0) break;
                    txt = new BTextArea(5, 45);
                    txt.setEditable(false);
                    for (i = 0; i < this.ok.size(); ++i) {
                        txt.append(this.ok.get(i).toString() + "\n");
                    }
                    detail = new BScrollPane((Widget)txt, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
                    messg = SPMTranslate.bLabel("okMsg");
                    BLabel restart = SPMTranslate.bLabel("restartMsg");
                    new BStandardDialog("PostInstall: ", (Object)new Widget[]{messg, restart, detail}, BStandardDialog.INFORMATION).showMessageDialog(null);
                    break;
                }
                finally {
                    this.ok = null;
                    this.err = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(String path, ArrayList ok, ArrayList err) {
        boolean count = false;
        File to = new File(path);
        File from = new File(tempDir, to.getName());
        if (!from.exists()) {
            System.out.println("PostInstall: FROM path does not exist: " + from.getAbsolutePath());
            return;
        }
        if (!to.exists()) {
            System.out.println("PostInstall: TO path does not exist: " + to.getAbsolutePath());
            return;
        }
        String[] files = from.list();
        if (files == null || files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(".upd")) continue;
            File update = new File(from, files[i]);
            if (update.length() == 0L) {
                if (update.delete()) {
                    System.out.println("PostInstall: deleted zero-length file: " + update.getAbsolutePath());
                    continue;
                }
                System.out.println("PostInstall.cleanup: Could not delete: " + update.getAbsolutePath());
                err.add("could not delete " + update.getAbsolutePath());
                continue;
            }
            String fname = files[i].substring(0, files[i].length() - ".upd".length());
            File plugin = new File(to, fname);
            if (plugin.exists()) {
                plugin.delete();
            }
            if (update.renameTo(plugin)) {
                System.out.println("PostInstall.cleanup: Updated " + fname);
                ok.add("Updated " + fname);
                continue;
            }
            BufferedInputStream is = null;
            OutputStream os = null;
            try {
                int b;
                is = new BufferedInputStream(new FileInputStream(update));
                os = new BufferedOutputStream(new FileOutputStream(plugin));
                while ((b = ((InputStream)is).read()) >= 0) {
                    os.write((byte)b);
                }
                System.out.println("PostInstall.cleanup: Updated " + fname);
                ok.add("Updated (copied) " + fname);
                continue;
            }
            catch (Exception e) {
                System.out.println("PostInstall.cleanup: **Error updating " + fname);
                err.add("couldn't rename or copy " + fname);
                continue;
            }
            finally {
                try {
                    os.flush();
                    os.close();
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
                if (!update.delete()) {
                    System.out.println("PostInstall.cleanup: **Error: Could not delete: " + update.getAbsolutePath());
                    err.add("couldn't delete " + update.getAbsolutePath());
                }
            }
        }
    }
}

