/*
 * Decompiled with CFR 0.152.
 */
package nik777.chat;

import java.util.ArrayList;
import java.util.HashMap;
import nik777.chat.Chat;
import org.jibble.pircbot.PircBot;
import org.jibble.pircbot.User;

public class IRCConnector
extends PircBot
implements Chat.Connector {
    protected String me;
    protected int chatid;
    protected Chat.Connector local;
    protected int userCount = 0;
    protected String host = "irc.freenode.net";
    protected int port = 6667;
    protected ArrayList user;
    protected HashMap chat;

    public void open(Chat.Connector conn) {
        this.local = conn;
    }

    public void close(Chat.Connector conn) {
        this.local = null;
    }

    public int join(String conn, String name, String password) {
        this.me = name;
        try {
            this.setVersion("ArtOfIllusion IRC client v1.0");
            this.setName(name);
            this.connect(this.host, this.port, password);
            this.joinChannel(conn);
        }
        catch (Exception e) {
            System.out.println("IRCConncetor.join: " + e);
            return -1;
        }
        return 1;
    }

    public void leave(int id) {
        this.disconnect();
    }

    public void add(String conn, String name, String details) {
    }

    public void remove(String conn, String name) {
    }

    public void accept(int id, String from, String to, String msg) {
        if (to == null || msg.trim().startsWith("/")) {
            this.sendRawLine(msg);
        } else {
            this.sendMessage(to, msg);
        }
    }

    protected void onUserList(String channel, User[] users) {
        System.out.println("receiving USER list of " + users.length + " entries");
        for (int i = 0; i < users.length; ++i) {
            if (users[i].getNick().equals(this.me)) continue;
            this.local.add(channel, users[i].getNick(), null);
            ++this.userCount;
        }
    }

    protected void onJoin(String channel, String sender, String login, String hostname) {
        System.out.println("new user: " + sender);
        this.local.add(channel, sender, "User " + sender + "\n(" + login + "@" + hostname + ")");
        ++this.userCount;
    }

    protected void onQuit(String nick, String login, String hostname, String reason) {
        --this.userCount;
        this.local.remove(null, nick);
    }

    protected void onMessage(String channel, String sender, String login, String hostname, String message) {
        this.local.accept(this.chatid, sender, this.me, message);
    }

    protected void onPrivateMessage(String sender, String login, String hostname, String message) {
        Integer sessn = (Integer)this.chat.get(sender);
        if (sessn == null) {
            sessn = new Integer(this.chat.size() + 1);
            this.chat.put(sender, sessn);
        }
        this.local.accept(sessn, sender, this.me, message);
    }

    protected void onTopic(String channel, String topic, String author, long date, boolean changed) {
        System.out.println("onTopic...");
        this.local.accept(this.chatid, null, this.me, topic);
    }
}

