/*
 * Decompiled with CFR 0.152.
 */
package nik777.aoi;

import artofillusion.ApplicationPreferences;
import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.Plugin;
import artofillusion.PluginRegistry;
import artofillusion.ViewerCanvas;
import artofillusion.keystroke.KeystrokeManager;
import artofillusion.keystroke.KeystrokeRecord;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.util.SearchlistClassLoader;
import buoy.event.MouseClickedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BOutline;
import buoy.widget.BPasswordField;
import buoy.widget.BTabbedPane;
import buoy.widget.BTextField;
import buoy.widget.BWindow;
import buoy.widget.MenuWidget;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import buoyx.docking.DockableWidget;
import buoyx.docking.DockingContainer;
import com.jstatcom.component.JHelpAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.sourceforge.helpgui.gui.HelpFrame;
import net.sourceforge.helpgui.page.Page;
import net.sourceforge.helpgui.parser.DocSet;
import nik777.chat.ChatFrame;
import nik777.chat.IRCConnector;

public class HelpPlugin
implements Plugin {
    public static final int REGISTER = -1;
    public static final int UNREGISTER = -2;
    public static final int HELP = -3;
    public static final int WHAT = -4;
    public static final int HUH = -5;
    public static final int CONTEXT = -6;
    static int helplib = 0;
    static boolean initialised = false;
    static boolean enabled = false;
    static HelpSet global;
    static HelpBroker broker;
    static DocSet docset;
    static String theme;
    protected static Properties helpprefs;
    static Writer map;
    static BWindow aboutWin;
    protected static BFrame curr;
    StringBuffer buff = null;
    protected static final int JAVAHELP_LIB = 1;
    protected static final int HELPGUI_LIB = 2;
    protected static final int MB = 0x100000;
    protected static final String mapHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE map PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN\" \"http://java.sun.com/products/javahelp/map_2_0.dtd\"><!-- generated by ArtOfIllusion HelpPlugin Version: 1.0, see aoisp.sourceforge.net -->\n<map version=\"1.0\">\n";
    static /* synthetic */ Class class$buoy$widget$Widget;
    static /* synthetic */ Class class$java$awt$Component;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processMessage(int message, Object[] args) {
        File prefdir = ApplicationPreferences.getPreferencesDirectory();
        switch (message) {
            case 0: {
                File helpflags;
                String script = this.load("/huh.bsh");
                if (script != null) {
                    KeystrokeManager.addRecord((KeystrokeRecord)new KeystrokeRecord(114, 0, "Huh Focus (HelpPlugin)", script));
                }
                if ((script = this.load("/help.bsh")) != null) {
                    KeystrokeManager.addRecord((KeystrokeRecord)new KeystrokeRecord(113, 0, "Help (HelpPlugin)", script));
                }
                if ((script = this.load("/what.bsh")) != null) {
                    KeystrokeManager.addRecord((KeystrokeRecord)new KeystrokeRecord(112, 0, "What's This? (HelpPlugin)", script));
                }
                if ((helpflags = new File(prefdir, "HelpPlugin.props")).exists()) {
                    System.out.println("HelpPlugin.init: processing prefs");
                    InputStream in = null;
                    try {
                        helpprefs = new Properties();
                        in = new FileInputStream(helpflags);
                        helpprefs.load(in);
                        String mapfile = helpprefs.getProperty("MapFile");
                        if (mapfile != null && mapfile.length() > 0) {
                            System.out.println("HelpPlugin.init: mapfile=" + mapfile);
                            map = new OutputStreamWriter((OutputStream)new FileOutputStream(mapfile), "UTF-8");
                            map.write(mapHeader);
                        }
                        theme = helpprefs.getProperty("Theme");
                    }
                    catch (IOException e) {
                        System.out.println("HelpPlugin: reading HelpFlags: " + e);
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                if (theme != null) break;
                theme = "plastic";
                break;
            }
            case 1: {
                if (map == null) break;
                map.write("\n</map>");
                map.flush();
                try {
                    map.close();
                }
                catch (IOException e1) {}
                break;
                catch (Exception e) {
                    try {
                        map.close();
                    }
                    catch (IOException e1) {}
                    break;
                    catch (Throwable throwable) {
                        try {
                            map.close();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            case 2: {
                int i;
                LayoutWindow win = (LayoutWindow)args[0];
                if (!initialised) {
                    initialised = true;
                    Locale local = Translate.getLocale();
                    Locale.setDefault(local);
                    SearchlistClassLoader loader = new SearchlistClassLoader(this.getClass().getClassLoader());
                    String[] jars = new String[]{"helpgui-1.1a.jar", "jhall.jar", "jhelpaction.jar", "pircbot.jar", "AOIHelp.zip"};
                    URLClassLoader myldr = null;
                    Method addURL = null;
                    File urlfile = null;
                    Object[] urlarg = new Object[1];
                    File dir = new File(ModellingApp.PLUGIN_DIRECTORY, "Help");
                    try {
                        myldr = (URLClassLoader)this.getClass().getClassLoader();
                        Class[] sig = new Class[]{URL.class};
                        addURL = URLClassLoader.class.getDeclaredMethod("addURL", sig);
                        addURL.setAccessible(true);
                    }
                    catch (Exception e) {
                        System.out.println("failed to get addURL: " + e);
                    }
                    for (i = 0; i < jars.length; ++i) {
                        try {
                            urlfile = new File(dir, jars[i]);
                            urlarg[0] = urlfile.toURI().toURL();
                            addURL.invoke((Object)myldr, urlarg);
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("failed to update classloader: " + e);
                        }
                    }
                    try {
                        List list;
                        if (loader.getResource("helpset/AOIHelp.hs") == null) {
                            throw new RuntimeException("cannot load global helpset");
                        }
                        try {
                            JHelpAction.startHelpWorker((String)"helpset/AOIHelp.hs");
                            Method getbroker = JHelpAction.class.getDeclaredMethod("getHelpBroker", null);
                            getbroker.setAccessible(true);
                            global = ((HelpBroker)getbroker.invoke(null, null)).getHelpSet();
                            helplib = 1;
                        }
                        catch (Throwable e) {
                            System.out.println("HelpPlugin: could not initialise JavaHelp");
                        }
                        if (helplib == 0) {
                            try {
                                docset = new DocSet(Translate.getLocale());
                                list = PluginRegistry.getPlugins((Class)DocSet.Parser.class);
                                for (i = 0; i < list.size(); ++i) {
                                    DocSet.Parser parser = (DocSet.Parser)list.get(i);
                                    System.out.println("HelpPlugin.INIT: registering parser: " + parser.getClass().getName());
                                    DocSet.registerParser((DocSet.Parser)parser);
                                }
                                docset.setLoader((ClassLoader)loader);
                                docset.add("helpset/AOIHelp.hs", null);
                                helplib = 2;
                            }
                            catch (Throwable t) {
                                System.out.println("HelpPlugin: could not initialise HelpGUI");
                            }
                        }
                        HelpSet helpset = global;
                        Page parent = null;
                        enabled = helplib != 0;
                        File[] files = dir.listFiles();
                        ZipFile zf = null;
                        ZipEntry ze = null;
                        URL[] url = new URL[1];
                        for (i = 0; i < files.length; ++i) {
                            int subcount;
                            File[] subdir;
                            if (files[i].isDirectory()) {
                                subdir = files[i].listFiles();
                                subcount = subdir.length;
                                if (subcount > 0) {
                                    if (helplib == 1) {
                                        helpset = new HelpSet((ClassLoader)loader);
                                        global.add(helpset);
                                    } else if (helplib == 2) {
                                        parent = docset.addSection(files[i].getName(), null);
                                    }
                                }
                            } else {
                                subdir = null;
                                subcount = 1;
                                helpset = global;
                                parent = null;
                            }
                            for (int k = 0; k < subcount; ++k) {
                                File helpfile = subdir != null ? subdir[k] : files[i];
                                try {
                                    zf = new ZipFile(helpfile);
                                    Enumeration<? extends ZipEntry> iter = zf.entries();
                                    while (iter.hasMoreElements()) {
                                        ze = iter.nextElement();
                                        if (ze.isDirectory()) continue;
                                        if (ze.getName().endsWith(".hs")) break;
                                        ze = null;
                                    }
                                    if (ze == null) continue;
                                    String basename = ze.getName();
                                    int cut = basename.lastIndexOf(46);
                                    if (cut > 0) {
                                        basename = basename.substring(0, cut);
                                    }
                                    System.out.println("HelpPlugin.ADD: " + basename);
                                    url[0] = helpfile.toURI().toURL();
                                    URLClassLoader ldr = new URLClassLoader(url);
                                    PluginRegistry.registerResource((String)"help", (String)basename, (ClassLoader)ldr, (String)ze.getName(), null);
                                    continue;
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                finally {
                                    if (zf != null) {
                                        zf.close();
                                        zf = null;
                                    }
                                }
                            }
                        }
                        HelpSet plugset = null;
                        if (helplib == 1) {
                            plugset = new HelpSet((ClassLoader)loader);
                        }
                        list = PluginRegistry.getResources((String)"help");
                        System.out.println("resources found=" + list.size());
                        if (list.size() > 0) {
                            if (docset != null) {
                                parent = docset.addSection("Plugins", null);
                            }
                            for (i = 0; i < list.size(); ++i) {
                                PluginRegistry.PluginResource resource = (PluginRegistry.PluginResource)list.get(i);
                                if (resource.getId().equals("helpset/AOIHelp")) continue;
                                System.out.println("Help: linking: " + resource.getURL().getPath());
                                loader.add(resource.getClassLoader());
                                System.out.println("loading: " + resource.getId() + " from " + resource.getURL().getPath());
                                if (plugset != null) {
                                    plugset.add(new HelpSet((ClassLoader)loader, resource.getURL()));
                                    continue;
                                }
                                loader.add(resource.getClassLoader());
                                docset.add(resource.getURL().getPath(), parent);
                            }
                        }
                        if (helpset != null) {
                            helpset.add(plugset);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("HelpPlugin.INIT: " + e);
                        e.printStackTrace(System.out);
                    }
                }
                try {
                    BMenuBar mbar = win.getMenuBar();
                    BMenu helpmenu = Translate.menu((String)"Help");
                    mbar.add(helpmenu);
                    BMenuItem item = Translate.menuItem((String)"Art Of Illusion Help", (Object)this, (String)"show");
                    helpmenu.add((MenuWidget)item);
                    item.setEnabled(enabled);
                    item = Translate.menuItem((String)"What's This?", (Object)this, (String)"what");
                    helpmenu.add((MenuWidget)item);
                    item.setEnabled(enabled && helplib == 1);
                    item = Translate.menuItem((String)"Live help", (Object)this, (String)"chat");
                    helpmenu.add((MenuWidget)item);
                    helpmenu.addSeparator();
                    item = Translate.menuItem((String)"About Art Of Illusion", (Object)this, (String)"about");
                    helpmenu.add((MenuWidget)item);
                }
                catch (Exception e) {
                    System.out.println("HelpPlugin: error adding menu: " + e);
                }
                catch (Throwable t) {
                    System.out.println("HelpPlugin: error adding menu: " + t);
                    t.printStackTrace(System.out);
                    return;
                }
                for (i = 0; i < 4; ++i) {
                    DockingContainer dock;
                    switch (i) {
                        case 0: {
                            dock = win.getDockingContainer(BTabbedPane.TOP);
                            break;
                        }
                        case 1: {
                            dock = win.getDockingContainer(BTabbedPane.BOTTOM);
                            break;
                        }
                        case 2: {
                            dock = win.getDockingContainer(BTabbedPane.LEFT);
                            break;
                        }
                        case 3: {
                            dock = win.getDockingContainer(BTabbedPane.RIGHT);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    Iterator iter = dock.getChildren().iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof DockableWidget)) continue;
                        DockableWidget dockable = (DockableWidget)obj;
                        Component comp = dockable.getComponent();
                        if (helplib != 1 || CSH.getHelpIDString((Component)comp) != null) continue;
                        HelpPlugin.register(comp, "Docking." + dockable.getLabel(), null);
                    }
                }
                HelpPlugin.register(args[0], "LayoutWindow", null);
                break;
            }
            case 3: {
                HelpPlugin.register(args[0], null, null);
                break;
            }
            case -1: {
                HelpPlugin.register(args[0], (String)args[1], null);
                break;
            }
            case -2: {
                HelpPlugin.register(args[0], null, null);
                break;
            }
            case -3: {
                this.show(null);
                break;
            }
            case -5: {
                this.huh(null);
                break;
            }
            case -4: {
                this.what(null);
                break;
            }
            case -6: {
                System.out.println("Help.CONTEXT: " + curr);
                args[0] = curr;
            }
        }
    }

    public BFrame getContext() {
        return curr;
    }

    public void show(WidgetEvent ev) {
        if (ev != null) {
            curr = UIUtilities.findFrame((Widget)ev.getWidget());
        }
        System.out.println("Help.show: curr=" + curr);
        if (helplib == 1) {
            JHelpAction.showHelp();
        } else if (helplib == 2) {
            HelpFrame helpframe = new HelpFrame(docset, theme);
            try {
                URL url = this.getClass().getResource("/artofillusion/Icons/appIcon.png");
                if (url != null) {
                    helpframe.setIconImage((Image)ImageIO.read(url.openStream()));
                } else {
                    System.out.println("HelpPlugin.show: cannot find icon");
                }
            }
            catch (Exception e) {
                System.out.println("HelpPlugin.show: " + e);
            }
            helpframe.setVisible(true);
        }
    }

    public void huh(WidgetEvent ev) {
        if (ev != null) {
            curr = UIUtilities.findFrame((Widget)ev.getWidget());
        }
        if (helplib == 1) {
            JHelpAction.showHelpFromFocus();
        }
    }

    public void what(WidgetEvent ev) {
        if (ev != null) {
            curr = UIUtilities.findFrame((Widget)ev.getWidget());
        }
        if (helplib == 1) {
            JHelpAction.trackFieldHelp();
        }
    }

    public void chat(WidgetEvent ev) {
        WindowWidget parent = UIUtilities.findWindow((Widget)ev.getWidget());
        Color frameColour = null;
        Font font = null;
        String id = null;
        String chan = "#aoi";
        if (helpprefs != null) {
            String tmp;
            try {
                tmp = helpprefs.getProperty("chat.colour");
                if (tmp != null) {
                    frameColour = Color.decode(tmp);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                tmp = helpprefs.getProperty("chat.font");
                if (tmp != null) {
                    font = Font.decode(tmp);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            chan = helpprefs.getProperty("chat.channel");
            id = helpprefs.getProperty("chat.id");
        }
        if (frameColour == null) {
            frameColour = new Color(204, 204, 255);
        }
        if (font == null) {
            font = Font.decode("Arial-PLAIN-12");
        }
        if (chan == null) {
            chan = "#aoi";
        }
        BTextField chanField = new BTextField(chan, 15);
        BTextField idField = new BTextField(id, 15);
        BPasswordField pwField = new BPasswordField("", 15);
        idField.requestFocus();
        Widget[] widgets = new Widget[]{chanField, idField, pwField};
        String[] labels = new String[]{Translate.text((String)"channel"), Translate.text((String)"name"), Translate.text((String)"password")};
        ComponentsDialog dlg = new ComponentsDialog(parent, Translate.text((String)"login"), widgets, labels);
        if (!dlg.clickedOk()) {
            return;
        }
        chan = chanField.getText();
        id = idField.getText();
        ChatFrame chat = new ChatFrame(frameColour, font, id, chan, true);
        IRCConnector irc = new IRCConnector();
        chat.open(irc);
        chat.join(chan, id, pwField.getText());
        chat.setVisible(true);
        if (helpprefs != null) {
            helpprefs.setProperty("chat.channel", chan);
            helpprefs.setProperty("chat.id", id);
            helpprefs.setProperty("chat.font", font.getFontName() + " " + font.getSize());
            try {
                File prefdir = ApplicationPreferences.getPreferencesDirectory();
                File helpflags = new File(prefdir, "HelpPlugin.props");
                helpprefs.store(new FileOutputStream(helpflags), "# (re)generated by HelpPlugin");
            }
            catch (Exception e) {
                System.out.println("HelpPlugin.chat: savinf prfs: " + e);
            }
        }
    }

    public void about() {
        try {
            aboutWin = new BWindow();
            aboutWin.addEventLink(MouseClickedEvent.class, new Object(){

                void processEvent() {
                    aboutWin.setVisible(false);
                    aboutWin.dispose();
                }
            });
            Runtime runtime = Runtime.getRuntime();
            int cpus = 1;
            try {
                cpus = runtime.availableProcessors();
            }
            catch (Exception e) {
                // empty catch block
            }
            Field vers = ModellingApp.class.getField("VERSION");
            String vname = vers.get(null).toString();
            int imageNumber = new Random(System.currentTimeMillis()).nextInt(8);
            ImageIcon image = new ImageIcon(this.getClass().getResource("/artofillusion/titleImages/titleImage" + imageNumber + ".jpg"));
            String text = "<html><div align='center'>Art Of Illusion v" + vname + "<br>Copyright 1999-2007 by Peter Eastman and others" + "<br>(See the README file for details.)" + "<br>This program may be freely distributed under" + "<br>the terms of the accompanying license.</div>" + "<p><div align='left'><hr>" + "Running in Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")" + "<br>on " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")" + "<br>Memory: " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L + " MB used out of " + runtime.totalMemory() / 0x100000L + " MB allocated (" + runtime.maxMemory() / 0x100000L + " MB max)" + "<br>Reported CPUs: " + cpus + "<br>OpenGL is " + (ViewerCanvas.isOpenGLAvailable() ? "available" : "unavailable") + "</div></html>";
            BLabel label = new BLabel(text, (Icon)image, BLabel.NORTH, BLabel.SOUTH);
            label.setFont(new Font("Serif", 0, 12));
            BOutline content = BOutline.createLineBorder((Widget)new BOutline((Widget)label, BorderFactory.createEmptyBorder(0, 0, 5, 0)), (Color)Color.BLACK, (int)1);
            Color background = Color.white;
            if (imageNumber == 4) {
                background = new Color(204, 204, 255);
            } else if (imageNumber == 6) {
                background = new Color(232, 255, 232);
            }
            UIUtilities.applyBackground((Widget)content, (Color)background);
            aboutWin.setContent((Widget)content);
            aboutWin.pack();
            Rectangle bounds = aboutWin.getBounds();
            ++bounds.height;
            aboutWin.setBounds(bounds);
            UIUtilities.centerWindow((WindowWidget)aboutWin);
            aboutWin.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("HelpPlugin.about: " + e);
        }
    }

    public static void register(Object obj, String id) {
        HelpPlugin.register(obj, id, null);
    }

    public static void unregister(Object obj) {
        HelpPlugin.register(obj, null, null);
    }

    public static void register(Object obj, String id, HelpSet helpset) {
        System.out.println(id != null ? "registering " + id : "unregistering");
        if (helplib != 1) {
            return;
        }
        Component component = null;
        if (obj instanceof Component) {
            component = (Component)obj;
        } else if (obj instanceof Widget) {
            component = ((Widget)obj).getComponent();
        }
        if (component != null) {
            System.out.println("component= " + component.getClass().getName());
            CSH.setHelpIDString((Component)component, (String)id);
            if (id != null) {
                if (global == null) {
                    System.out.println("global is null");
                }
                if (helpset != null) {
                    CSH.setHelpSet((Component)component, (HelpSet)helpset);
                } else if (global != null) {
                    CSH.setHelpSet((Component)component, (HelpSet)global);
                }
                System.out.println("Mapped ID=" + CSH.getHelpIDString((Component)component));
                if (map != null) {
                    try {
                        map.write("\n<mapID target=\"");
                        map.write(id);
                        map.write("\" url=\"\" />");
                    }
                    catch (IOException e) {
                        System.out.println("HelpPlugin.register writing map: " + e);
                    }
                }
            }
        }
    }

    public static void makeMap_dont_use(String id, Object obj, Writer map) {
        Field fld;
        int i;
        Object parent;
        Field[] field = null;
        Object widget = null;
        Object component = null;
        if (obj instanceof Widget) {
            widget = (Widget)obj;
            parent = widget.getParent();
            try {
                while (parent != null) {
                    System.out.println("Help.makeMap: parent=" + parent.getClass().getName());
                    System.out.println("pop");
                    widget = parent;
                    parent = widget.getParent();
                }
            }
            catch (Exception e) {
                System.out.println("HelpPlugin.makeMap: finding top: " + e);
            }
            obj = widget;
        } else if (obj instanceof Component) {
            component = (Component)obj;
            parent = ((Component)component).getParent();
            try {
                while (parent != null) {
                    field = parent.getClass().getDeclaredFields();
                    System.out.println("Help.makeMap: parent=" + parent.getClass().getName());
                    System.out.println("pop");
                    component = parent;
                    parent = ((Component)component).getParent();
                    for (i = 0; i < field.length; ++i) {
                        fld = field[i];
                        fld.setAccessible(true);
                        if (fld.get(parent) != component) continue;
                        System.out.println("Help.makeMap: found top");
                        parent = null;
                        break;
                    }
                    if (i < field.length) continue;
                    System.out.println("pop...");
                    component = parent;
                    parent = ((Component)component).getParent();
                }
            }
            catch (Exception e) {
                System.out.println("HelpPlugin.makeMap: finding top: " + e);
            }
            obj = component;
        }
        System.out.println("HelpPlugin.makeMap: top level is a " + obj.getClass().getName());
        try {
            if (widget != null || component != null) {
                map.write("\n<mapID target='");
                map.write(id);
                map.write("' url='' />");
            }
            field = obj.getClass().getDeclaredFields();
            for (i = 0; i < field.length; ++i) {
                fld = field[i];
                String name = fld.getName();
                System.out.println("Help.makeMap: field=" + name);
                if (Modifier.isStatic(fld.getModifiers()) || name.length() == 0 || name.indexOf(36) >= 0) continue;
                try {
                    Class<?> type = fld.getType();
                    if (!(class$buoy$widget$Widget == null ? HelpPlugin.class$("buoy.widget.Widget") : class$buoy$widget$Widget).isAssignableFrom(type) && !(class$java$awt$Component == null ? HelpPlugin.class$("java.awt.Component") : class$java$awt$Component).isAssignableFrom(type)) continue;
                    fld.setAccessible(true);
                    Object child = fld.get(obj);
                    if (child == null || child == obj) continue;
                    HelpPlugin.makeMap_dont_use(id + "." + name, child, map);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("HelpPlugin.makeMap (" + id + "): " + e);
                }
            }
        }
        catch (IOException e) {
            System.out.println("HelpPlugin.makeMap: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String load(String path) {
        if (this.buff == null) {
            this.buff = new StringBuffer(512);
        } else {
            this.buff.setLength(0);
        }
        InputStream is = null;
        try {
            int c;
            is = this.getClass().getResourceAsStream(path);
            if (is == null) {
                String string = null;
                return string;
            }
            InputStreamReader in = new InputStreamReader(is, "UTF-8");
            while ((c = in.read()) != -1) {
                this.buff.append((char)c);
            }
        }
        catch (IOException e) {
            System.out.println("HelpPlugin: unable to load resource: " + e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return this.buff.length() > 0 ? this.buff.toString() : null;
    }

    static {
        theme = null;
        map = null;
    }
}

