/*
 * Decompiled with CFR 0.152.
 */
package buoyx.docking;

import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.internal.SingleWidgetPanel;
import buoy.internal.WidgetContainerPanel;
import buoy.widget.BSplitPane;
import buoy.widget.BTabbedPane;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoyx.docking.DockableWidget;
import buoyx.docking.DragManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class DockingContainer
extends WidgetContainer {
    private Widget content;
    private ArrayList childrenInTab;
    private BTabbedPane.TabPosition tabPosition;
    private BSplitPane splitPane;
    private BTabbedPane tabs;
    private boolean hideSingleTab;
    private int visibleDividerSize;

    public DockingContainer() {
        this.component = new WidgetContainerPanel(this);
        this.splitPane = new BSplitPane(BSplitPane.HORIZONTAL);
        ((JSplitPane)this.splitPane.getComponent()).setBorder(null);
        this.tabPosition = BTabbedPane.TOP;
        ((Container)this.component).add(this.splitPane.getComponent());
        this.setAsParent(this.splitPane);
        this.childrenInTab = new ArrayList();
        this.visibleDividerSize = ((JSplitPane)this.splitPane.getComponent()).getDividerSize();
    }

    public DockingContainer(Widget content, BTabbedPane.TabPosition tabPosition) {
        this();
        this.setTabPosition(tabPosition);
        this.setContent(content);
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget widget) {
        if (widget != null && widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        if (this.content != null) {
            this.splitPane.remove(this.content);
        }
        this.content = widget;
        if (this.content != null) {
            this.splitPane.add(this.content, this.tabPosition == BTabbedPane.BOTTOM || this.tabPosition == BTabbedPane.RIGHT ? 0 : 1);
            this.setAsParent(this.content);
        }
    }

    public void addDockableWidget(DockableWidget widget) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        ArrayList<DockableWidget> newTab = new ArrayList<DockableWidget>();
        newTab.add(widget);
        this.childrenInTab.add(newTab);
        this.rebuildContents(this.getDockedChildCount() > 1);
    }

    public void addDockableWidget(DockableWidget widget, int tab, int indexInTab) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        if (tab == this.childrenInTab.size() && indexInTab == 0) {
            this.addDockableWidget(widget);
            return;
        }
        ((ArrayList)this.childrenInTab.get(tab)).add(indexInTab, widget);
        this.rebuildContents(this.getDockedChildCount() > 1);
    }

    public int getChildTabIndex(DockableWidget widget) {
        for (int i = 0; i < this.childrenInTab.size(); ++i) {
            if (!((ArrayList)this.childrenInTab.get(i)).contains(widget)) continue;
            return i;
        }
        return -1;
    }

    public int getChildIndexInTab(DockableWidget widget) {
        for (int i = 0; i < this.childrenInTab.size(); ++i) {
            int index = ((ArrayList)this.childrenInTab.get(i)).indexOf(widget);
            if (index <= -1) continue;
            return index;
        }
        return -1;
    }

    public int getTabCount() {
        return this.childrenInTab.size();
    }

    public int getTabChildCount(int tabIndex) {
        return ((ArrayList)this.childrenInTab.get(tabIndex)).size();
    }

    public BTabbedPane.TabPosition getTabPosition() {
        return this.tabPosition;
    }

    public void setTabPosition(BTabbedPane.TabPosition position) {
        this.tabPosition = position;
        this.splitPane.setOrientation(this.tabPosition == BTabbedPane.TOP || this.tabPosition == BTabbedPane.BOTTOM ? BSplitPane.VERTICAL : BSplitPane.HORIZONTAL);
        if (this.content != null) {
            Widget theContent = this.content;
            this.remove(this.content);
            this.setContent(theContent);
        }
        this.rebuildContents(true);
    }

    public int getSelectedTab() {
        if (this.tabs == null) {
            return this.childrenInTab.size() == 0 ? -1 : 0;
        }
        return this.tabs.getSelectedTab();
    }

    public void setSelectedTab(int index) {
        if (this.tabs != null) {
            this.tabs.setSelectedTab(index);
        }
    }

    public boolean getHideSingleTab() {
        return this.hideSingleTab;
    }

    public void setHideSingleTab(boolean hide) {
        this.hideSingleTab = hide;
        if (this.childrenInTab.size() == 1) {
            this.rebuildContents(true);
        }
    }

    public void resetToPreferredSizes(int tabIndex) {
        Widget child;
        if (this.tabs == null) {
            int dockPosition = this.tabPosition == BTabbedPane.BOTTOM || this.tabPosition == BTabbedPane.RIGHT ? 1 : 0;
            child = this.splitPane.getChild(dockPosition);
        } else {
            child = this.tabs.getChild(tabIndex);
        }
        if (child != null) {
            this.recursivelyResetToPreferredSizes(child.getComponent());
        }
    }

    private void recursivelyResetToPreferredSizes(Component c) {
        if (c instanceof SingleWidgetPanel) {
            c = ((SingleWidgetPanel)c).getComponent(0);
        }
        if (c instanceof JSplitPane) {
            JSplitPane js = (JSplitPane)c;
            js.resetToPreferredSizes();
            this.recursivelyResetToPreferredSizes(js.getTopComponent());
            this.recursivelyResetToPreferredSizes(js.getBottomComponent());
        }
    }

    Rectangle getTabBounds(int index) {
        Rectangle tabBounds;
        if (this.tabs == null) {
            Rectangle bounds = this.getBounds();
            int TAB_REGION_SIZE = 30;
            if (this.tabPosition == BTabbedPane.TOP) {
                return new Rectangle(0, 0, bounds.width, 30);
            }
            if (this.tabPosition == BTabbedPane.BOTTOM) {
                return new Rectangle(0, bounds.height - 30, bounds.width, 30);
            }
            if (this.tabPosition == BTabbedPane.LEFT) {
                return new Rectangle(0, 0, 30, bounds.height);
            }
            return new Rectangle(bounds.width - 30, 0, 30, bounds.height);
        }
        if (index < this.getTabCount()) {
            tabBounds = ((JTabbedPane)this.tabs.getComponent()).getBoundsAt(index);
        } else {
            Rectangle lastTabBounds;
            int lastVisibleTab = this.getTabCount() - 1;
            do {
                if ((lastTabBounds = ((JTabbedPane)this.tabs.getComponent()).getBoundsAt(lastVisibleTab)) == null) {
                    --lastVisibleTab;
                }
                if (lastVisibleTab != -1) continue;
                return null;
            } while (lastTabBounds == null);
            Rectangle bounds = this.tabs.getBounds();
            tabBounds = this.tabPosition == BTabbedPane.TOP || this.tabPosition == BTabbedPane.BOTTOM ? new Rectangle(lastTabBounds.x + lastTabBounds.width, lastTabBounds.y, bounds.x + bounds.width - lastTabBounds.x - lastTabBounds.width, lastTabBounds.height) : new Rectangle(lastTabBounds.x, lastTabBounds.y + lastTabBounds.height, lastTabBounds.width, bounds.y + bounds.height - lastTabBounds.y - lastTabBounds.height);
        }
        if (tabBounds == null) {
            return null;
        }
        if (this.tabs != null) {
            for (Container parent = this.tabs.getComponent().getParent(); parent != this.getComponent(); parent = parent.getParent()) {
                tabBounds.x += parent.getX();
                tabBounds.y += parent.getY();
            }
        }
        return tabBounds;
    }

    private void rebuildContents(boolean preserveSize) {
        int i;
        int mainPosition = this.tabPosition == BTabbedPane.BOTTOM || this.tabPosition == BTabbedPane.RIGHT ? 0 : 1;
        BSplitPane.Orientation splitOrient = this.tabPosition == BTabbedPane.LEFT || this.tabPosition == BTabbedPane.RIGHT ? BSplitPane.VERTICAL : BSplitPane.HORIZONTAL;
        this.splitPane.setResizeWeight(this.tabPosition == BTabbedPane.BOTTOM || this.tabPosition == BTabbedPane.RIGHT ? 1.0 : 0.0);
        int splitLocation = this.splitPane.getDividerLocation();
        Iterator allChildren = this.getChildren().iterator();
        while (allChildren.hasNext()) {
            Widget child = (Widget)allChildren.next();
            if (child == this.content) continue;
            this.removeAsParent(child);
        }
        this.splitPane.remove(1 - mainPosition);
        if (this.getDockedChildCount() == 0) {
            this.tabs = null;
            this.splitPane.remove(1 - mainPosition);
            ((JSplitPane)this.splitPane.getComponent()).setDividerSize(0);
            return;
        }
        ((JSplitPane)this.splitPane.getComponent()).setDividerSize(this.visibleDividerSize);
        Widget[] tabContents = new Widget[this.childrenInTab.size()];
        for (i = 0; i < tabContents.length; ++i) {
            ArrayList children = (ArrayList)this.childrenInTab.get(i);
            if (children.size() == 1) {
                tabContents[i] = (Widget)children.get(0);
                continue;
            }
            BSplitPane split = new BSplitPane(splitOrient);
            split.setResizeWeight(1.0 / (double)children.size());
            tabContents[i] = split;
            split.add((Widget)children.get(0), 0);
            for (int j = 1; j < children.size() - 1; ++j) {
                BSplitPane nextSplit = new BSplitPane(splitOrient);
                ((JSplitPane)nextSplit.getComponent()).setBorder(null);
                nextSplit.setResizeWeight(1.0 / (double)(children.size() - j));
                split.add(nextSplit, 1);
                split = nextSplit;
                split.add((Widget)children.get(j), 0);
            }
            split.add((Widget)children.get(children.size() - 1), 1);
        }
        if (tabContents.length == 1 && this.hideSingleTab) {
            this.splitPane.add(tabContents[0], 1 - mainPosition);
            this.tabs = null;
        } else if (tabContents.length > 0) {
            this.tabs = new BTabbedPane(this.tabPosition);
            DragManager manager = DragManager.getDragManager();
            this.tabs.addEventLink(MousePressedEvent.class, (Object)this, "mousePressedOnTab");
            this.tabs.addEventLink(MouseDraggedEvent.class, (Object)manager, "mouseDragged");
            this.tabs.addEventLink(MouseReleasedEvent.class, (Object)manager, "mouseReleased");
            for (int i2 = 0; i2 < tabContents.length; ++i2) {
                ArrayList children = (ArrayList)this.childrenInTab.get(i2);
                StringBuffer label = new StringBuffer();
                for (int j = 0; j < children.size(); ++j) {
                    if (j > 0) {
                        label.append(", ");
                    }
                    label.append(((DockableWidget)children.get(j)).getLabel());
                }
                this.tabs.add(tabContents[i2], label.toString());
            }
            this.splitPane.add(this.tabs, 1 - mainPosition);
        }
        for (i = 0; i < this.childrenInTab.size(); ++i) {
            ArrayList children = (ArrayList)this.childrenInTab.get(i);
            for (int j = 0; j < children.size(); ++j) {
                this.setAsParent((Widget)children.get(j));
            }
        }
        if (preserveSize) {
            this.splitPane.setDividerLocation(splitLocation);
        } else {
            this.splitPane.resetToPreferredSizes();
        }
        this.invalidateSize();
    }

    private void mousePressedOnTab(MousePressedEvent ev) {
        Point pos = ev.getPoint();
        JTabbedPane tp = (JTabbedPane)this.tabs.getComponent();
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle bounds = tp.getBoundsAt(i);
            if (!bounds.contains(pos)) continue;
            bounds.x -= pos.x;
            bounds.y -= pos.y;
            DragManager.getDragManager().beginDraggingTab(this, i, bounds);
        }
    }

    public int getChildCount() {
        int count = this.content == null ? 0 : 1;
        for (int i = 0; i < this.childrenInTab.size(); ++i) {
            count += ((ArrayList)this.childrenInTab.get(i)).size();
        }
        return count;
    }

    private int getDockedChildCount() {
        return this.getChildCount() - (this.content == null ? 0 : 1);
    }

    public Collection getChildren() {
        ArrayList<Widget> children = new ArrayList<Widget>(0);
        if (this.content != null) {
            children.add(this.content);
        }
        for (int i = 0; i < this.childrenInTab.size(); ++i) {
            ArrayList thisTab = (ArrayList)this.childrenInTab.get(i);
            for (int j = 0; j < thisTab.size(); ++j) {
                children.add((Widget)thisTab.get(j));
            }
        }
        return children;
    }

    public DockableWidget getChild(int tab, int index) {
        return (DockableWidget)((ArrayList)this.childrenInTab.get(tab)).get(index);
    }

    public void remove(Widget widget) {
        if (widget == this.content) {
            this.setContent(null);
        } else {
            for (int i = 0; i < this.childrenInTab.size(); ++i) {
                ArrayList thisTab = (ArrayList)this.childrenInTab.get(i);
                int index = thisTab.indexOf(widget);
                if (index <= -1) continue;
                thisTab.remove(index);
                this.removeAsParent(widget);
                if (thisTab.size() == 0) {
                    this.childrenInTab.remove(i);
                }
                this.rebuildContents(this.getDockedChildCount() > 0);
                return;
            }
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.childrenInTab.size(); ++i) {
            ArrayList thisTab = (ArrayList)this.childrenInTab.get(i);
            for (int j = 0; j < thisTab.size(); ++j) {
                this.removeAsParent((Widget)thisTab.get(j));
            }
        }
        this.childrenInTab.clear();
        this.setContent(null);
    }

    public void layoutChildren() {
        this.splitPane.getComponent().setBounds(this.getBounds());
        this.splitPane.layoutChildren();
    }

    public Dimension getMinimumSize() {
        return this.splitPane.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.splitPane.getPreferredSize();
    }

    public BSplitPane getSplitPane() {
        return this.splitPane;
    }
}

